/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.jenkins;

import com.soasta.jenkins.CloudTestServer;
import com.soasta.jenkins.ProxyChecker;
import com.soasta.jenkins.SCommandInstaller;
import hudson.AbortException;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.net.URL;
import jenkins.model.Jenkins;

public abstract class AbstractSCommandBuilder
extends Builder {
    private final String url;
    private final String cloudTestServerID;

    public AbstractSCommandBuilder(String url, String cloudTestServerID) {
        this.url = url;
        this.cloudTestServerID = cloudTestServerID;
    }

    public CloudTestServer getServer() {
        return CloudTestServer.getByID(this.cloudTestServerID);
    }

    public String getUrl() {
        return this.url;
    }

    public String getCloudTestServerID() {
        return this.cloudTestServerID;
    }

    protected ArgumentListBuilder getSCommandArgs(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        String host;
        ProxyConfiguration proxyConfig;
        CloudTestServer s = this.getServer();
        if (s == null) {
            throw new AbortException("No TouchTest server is configured in the system configuration.");
        }
        FilePath scommand = new SCommandInstaller(s).scommand(build.getBuiltOn(), (TaskListener)listener);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add((Object)scommand);
        args.add("url=" + s.getUrl());
        if (!s.getApitoken().trim().isEmpty() && s.getUsername().trim().isEmpty() && s.getPassword() == null) {
            args.add("apitoken=" + s.getApitoken());
        } else {
            if (!(s.getApitoken().trim().isEmpty() || s.getUsername().trim().isEmpty() && s.getPassword() == null)) {
                throw new AbortException("Cannot set both Username or Password and API Token");
            }
            if (s.getApitoken().trim().isEmpty() && !s.getUsername().trim().isEmpty()) {
                args.add("username=" + s.getUsername());
                args.addMasked("password=" + s.getPassword());
            }
        }
        if (s.getKeyStoreLocation() != null && !s.getKeyStoreLocation().isEmpty()) {
            args.add("keystore=" + s.getKeyStoreLocation());
            if (s.getKeyStorePassword() != null) {
                args.addMasked("keystorepass=" + s.getKeyStorePassword());
            }
        }
        if ((proxyConfig = Jenkins.getInstance().proxy) != null && proxyConfig.name != null && ProxyChecker.useProxy(host = new URL(s.getUrl()).getHost(), proxyConfig)) {
            args.add("httpproxyhost=" + proxyConfig.name).add("httpproxyport=" + proxyConfig.port);
            if (proxyConfig.getUserName() != null) {
                args.add("httpproxyusername=" + proxyConfig.getUserName()).addMasked("httpproxypassword=" + proxyConfig.getPassword());
            }
        }
        return args;
    }
}

