/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.manifest.dynamodb;

import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.ValidatedIdSyntax$;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.snowplowanalytics.iglu.core.SelfDescribingData;
import com.snowplowanalytics.manifest.core.Agent;
import com.snowplowanalytics.manifest.core.Application;
import com.snowplowanalytics.manifest.core.Author;
import com.snowplowanalytics.manifest.core.ManifestError;
import com.snowplowanalytics.manifest.core.ManifestError$;
import com.snowplowanalytics.manifest.core.Payload$;
import com.snowplowanalytics.manifest.core.Record;
import com.snowplowanalytics.manifest.core.State;
import com.snowplowanalytics.manifest.core.State$;
import com.snowplowanalytics.manifest.dynamodb.Common$;
import io.circe.Json;
import io.circe.ParsingFailure$;
import io.circe.parser.package$;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function8;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;

public final class Serialization$ {
    public static Serialization$ MODULE$;

    static {
        new Serialization$();
    }

    public Either<ManifestError, Record> parse(Map<String, AttributeValue> dbItem) {
        Either either;
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)scala.collection.convert.package$.MODULE$.decorateAsScala().mapAsScalaMapConverter(dbItem).asScala();
        if (map.isEmpty()) {
            either = EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)ManifestError$.MODULE$.parseError("DynamoDB record does not contain any payload")));
        } else {
            Validated id = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.ItemIdKey(), map)));
            Validated application2 = (Validated)implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.ApplicationNameKey(), map))), (Object)EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.ApplicationVersionKey(), map))), (Object)ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Serialization$.getS$1(Common$.MODULE$.ApplicationInstanceIdKey(), map).toOption().flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.expand((String)s)))))).mapN((Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
                Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String name = (String)tuple3._1();
                String version = (String)tuple3._2();
                Option instanceId = (Option)tuple3._3();
                Application application = new Application(new Agent(name, version), (Option<String>)instanceId);
                return application;
            }, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
            Validated recordId2 = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.RecordIdKey(), map).flatMap((Function1 & Serializable & scala.Serializable)s -> MODULE$.parseId((String)s))));
            Validated state2 = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.StateKey(), map).flatMap((Function1 & Serializable & scala.Serializable)s -> State$.MODULE$.parse((String)s))));
            Validated author2 = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$1(Common$.MODULE$.AuthorKey(), map))).andThen((Function1 & Serializable & scala.Serializable)v -> {
                Validated validated;
                List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v.split(Pattern.quote(((Object)BoxesRunTime.boxToCharacter((char)Common$.MODULE$.Separator())).toString()), -1))).toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    String name = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String version = (String)((LinearSeqOptimized)some.get()).apply(1);
                    String manifestVersion = (String)((LinearSeqOptimized)some.get()).apply(2);
                    validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new Author(new Agent(name, version), manifestVersion)));
                } else {
                    validated = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(49).append("Value of ").append(Common$.MODULE$.AuthorKey()).append(" key [").append((String)v).append("] does not conform expected format").toString()));
                }
                return validated;
            });
            Validated timestamp2 = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getT$1(Common$.MODULE$.TimestampKey(), map)));
            Validated data = EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getData$1(map)));
            Validated validated = (Validated)implicits$.MODULE$.catsSyntaxTuple8Semigroupal(new Tuple8((Object)id, (Object)application2, (Object)recordId2, (Object)Serialization$.getPreviousRecordId$1(map), (Object)state2, (Object)timestamp2, (Object)author2, (Object)data)).mapN((Function8 & Serializable & scala.Serializable)(itemId, application, recordId, previousRecordId, state, timestamp, author, payload) -> new Record((String)itemId, (Application)application, (UUID)recordId, (Option<UUID>)previousRecordId, (State)state, (Instant)timestamp, (Author)author, (Option<SelfDescribingData<Json>>)payload), (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
            either = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(validated.toEither()), (Function1 & Serializable & scala.Serializable)errors -> ManifestError$.MODULE$.parseError(new StringBuilder(65).append("Cannot parse manifest record from DynamoDB due following errors: ").append(errors.toList().mkString(", ")).toString()));
        }
        return either;
    }

    public String showAuthor(Author author) {
        return new StringBuilder(0).append(author.agent().name()).append(Common$.MODULE$.Separator()).append(author.agent().version()).append(Common$.MODULE$.Separator()).append(author.manifestVersion()).toString();
    }

    public Either<String, UUID> parseId(String s) {
        Either either;
        try {
            either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)UUID.fromString(s)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            either = EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new StringBuilder(26).append("UUID [").append(s).append("] has invalid format").toString()));
        }
        return either;
    }

    public Either<ManifestError, String> parseItemId(Map<String, AttributeValue> dbRecord) {
        return EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(Serialization$.getS$2(Common$.MODULE$.ItemIdKey(), dbRecord)), (Function1 & Serializable & scala.Serializable)message -> ManifestError$.MODULE$.parseError((String)message));
    }

    private Option<String> expand(String s) {
        return s.isEmpty() ? None$.MODULE$ : new Some((Object)s);
    }

    private static final Either getS$1(String key, scala.collection.mutable.Map map$1) {
        return Common$.MODULE$.foldO(map$1.get((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Key ").append(key).append(" does not exist").toString()).flatMap((Function1 & Serializable & scala.Serializable)value -> Common$.MODULE$.foldO(Option$.MODULE$.apply((Object)value.getS()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Key ").append(key).append(" is not a string").toString()).map((Function1 & Serializable & scala.Serializable)str -> str));
    }

    private static final Validated getPreviousRecordId$1(scala.collection.mutable.Map map$1) {
        return EitherOps$.MODULE$.toValidatedNel$extension(implicits$.MODULE$.catsSyntaxEither((Either)implicits$.MODULE$.toTraverseOps((Object)map$1.get((Object)Common$.MODULE$.PreviousRecordId()).flatMap((Function1 & Serializable & scala.Serializable)value -> Option$.MODULE$.apply((Object)value.getS()).map((Function1 & Serializable & scala.Serializable)s -> MODULE$.parseId((String)s)).map((Function1 & Serializable & scala.Serializable)str -> str)), implicits$.MODULE$.catsStdInstancesForOption()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())));
    }

    public static final /* synthetic */ Instant $anonfun$parse$14(long l) {
        return Instant.ofEpochMilli(l);
    }

    private static final Either getT$1(String key, scala.collection.mutable.Map map$1) {
        return Common$.MODULE$.foldO(map$1.get((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Key ").append(key).append(" does not exist").toString()).flatMap((Function1 & Serializable & scala.Serializable)value -> Common$.MODULE$.foldO(Option$.MODULE$.apply((Object)value.getN()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Key ").append(key).append(" is not a number").toString()).flatMap((Function1 & Serializable & scala.Serializable)str -> Common$.MODULE$.foldO(Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(str)).toLong()).toOption(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Key ").append(key).append(" is not an integer").toString()).map((Function1 & Serializable & scala.Serializable)object -> Serialization$.$anonfun$parse$14(BoxesRunTime.unboxToLong((Object)object)))));
    }

    private static final Either getData$1(scala.collection.mutable.Map map$1) {
        Option data = map$1.get((Object)Common$.MODULE$.DataKey()).map((Function1 & Serializable & scala.Serializable)value -> {
            Option opt = Option$.MODULE$.apply((Object)value.getS());
            return new Tuple2(value, (Object)opt);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option opt = (Option)tuple2._2();
            Option option = opt.map((Function1 & Serializable & scala.Serializable)input -> package$.MODULE$.parse(input)).map((Function1 & Serializable & scala.Serializable)jsonE -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(jsonE), (Function1 & Serializable & scala.Serializable)x$1 -> implicits$.MODULE$.toShow(x$1, ParsingFailure$.MODULE$.showParsingFailure()).show()).flatMap((Function1 & Serializable & scala.Serializable)json -> Payload$.MODULE$.parse((Json)json)));
            return option;
        });
        return EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither((Either)implicits$.MODULE$.toTraverseOps((Object)data, implicits$.MODULE$.catsStdInstancesForOption()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())), (Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(32).append("Key ").append(Common$.MODULE$.DataKey()).append(" does not contain valid JSON").toString());
    }

    private static final Either getS$2(String key, Map dbRecord$1) {
        return Common$.MODULE$.foldO(((MapLike)scala.collection.convert.package$.MODULE$.decorateAsScala().mapAsScalaMapConverter(dbRecord$1).asScala()).get((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Key ").append(key).append(" does not exist in ").append(dbRecord$1).toString()).flatMap((Function1 & Serializable & scala.Serializable)value -> Common$.MODULE$.foldO(Option$.MODULE$.apply((Object)value.getS()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Key ").append(key).append(" is not a string").toString()).map((Function1 & Serializable & scala.Serializable)str -> str));
    }

    private Serialization$() {
        MODULE$ = this;
    }
}

