/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.manifest.core;

import cats.syntax.EitherOps$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.snowplowanalytics.iglu.core.SchemaKey;
import com.snowplowanalytics.iglu.core.SchemaVer;
import com.snowplowanalytics.iglu.core.SelfDescribingData;
import com.snowplowanalytics.iglu.core.SelfDescribingData$;
import com.snowplowanalytics.iglu.core.circe.implicits$;
import com.snowplowanalytics.iglu.core.typeclasses.ToData;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonObject$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.package$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class Payload$ {
    public static Payload$ MODULE$;
    private final SchemaKey LockedSchemaKey;
    private final SchemaKey ApplicationErrorSchemaKey;
    private final int MaxMessageLength;
    private final int MaxStackLength;
    private final int MaxExceptionNameLength;

    static {
        new Payload$();
    }

    public SchemaKey LockedSchemaKey() {
        return this.LockedSchemaKey;
    }

    public SchemaKey ApplicationErrorSchemaKey() {
        return this.ApplicationErrorSchemaKey;
    }

    private int MaxMessageLength() {
        return this.MaxMessageLength;
    }

    private int MaxStackLength() {
        return this.MaxStackLength;
    }

    private int MaxExceptionNameLength() {
        return this.MaxExceptionNameLength;
    }

    public SelfDescribingData<Json> exception(Throwable throwable) {
        Option<String> stackTrace = this.stackTraceToString(throwable);
        Option causeStackTrace = Option$.MODULE$.apply((Object)throwable.getCause()).flatMap((Function1 & Serializable & scala.Serializable)e -> MODULE$.stackTraceToString((Throwable)e));
        Option lineNumber = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throwable.getStackTrace())).headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getLineNumber()));
        Json message = (Json)this.truncateString(throwable.getMessage(), this.MaxMessageLength()).map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromString(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.fromString("No message available"));
        Json exceptionName = (Json)this.truncateString(throwable.getClass().getName(), this.MaxExceptionNameLength()).map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromString(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.Null());
        scala.collection.immutable.Map data = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"programmingLanguage"), (Object)Json$.MODULE$.fromString("SCALA")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threadId"), (Object)Json$.MODULE$.fromLong(Thread.currentThread().getId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stackTrace"), stackTrace.map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromString(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.Null())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"causeStackTrace"), causeStackTrace.map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromString(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.Null())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineNumber"), lineNumber.map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromInt(BoxesRunTime.unboxToInt((Object)value))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.Null())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exceptionName"), (Object)exceptionName)}));
        return new SelfDescribingData(this.ApplicationErrorSchemaKey(), (Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)JsonObject$.MODULE$.fromMap(data)), (Encoder)Encoder$.MODULE$.encodeJsonObject()));
    }

    public SelfDescribingData<Json> locked(UUID lockedBy) {
        return new SelfDescribingData(this.LockedSchemaKey(), (Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)JsonObject$.MODULE$.fromMap((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordId"), (Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)lockedBy), Encoder$.MODULE$.encodeUUID()))})))), (Encoder)Encoder$.MODULE$.encodeJsonObject()));
    }

    public Either<String, SelfDescribingData<Json>> parse(Json json) {
        return EitherOps$.MODULE$.leftMap$extension(cats.implicits$.MODULE$.catsSyntaxEither(SelfDescribingData$.MODULE$.parse((Object)json, (ToData)implicits$.MODULE$.igluAttachToDataCirce())), (Function1 & Serializable & scala.Serializable)c -> new StringBuilder(43).append("Not valid self-describing JSON in payload, ").append(c).toString());
    }

    public JsonNode circeToJackson(Json json) {
        return (JsonNode)json.fold((Function0 & Serializable & scala.Serializable)() -> NullNode.instance, (Function1 & Serializable & scala.Serializable)b -> Payload$.$anonfun$circeToJackson$2(BoxesRunTime.unboxToBoolean((Object)b)), (Function1 & Serializable & scala.Serializable)number -> {
            LongNode longNode;
            Option option = number.toLong();
            if (option instanceof Some) {
                Some some = (Some)option;
                long l = BoxesRunTime.unboxToLong((Object)some.value());
                longNode = new LongNode(l);
            } else if (None$.MODULE$.equals(option)) {
                DoubleNode doubleNode;
                Option option2 = number.toBigDecimal();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    BigDecimal bigDecimal = (BigDecimal)some.value();
                    doubleNode = new DecimalNode(bigDecimal.bigDecimal());
                } else if (None$.MODULE$.equals(option2)) {
                    doubleNode = new DoubleNode(number.toDouble());
                } else {
                    throw new MatchError((Object)option2);
                }
                longNode = doubleNode;
            } else {
                throw new MatchError((Object)option);
            }
            return longNode;
        }, (Function1 & Serializable & scala.Serializable)string -> new TextNode(string), (Function1 & Serializable & scala.Serializable)array -> {
            JsonNodeFactory factory = JsonNodeFactory.instance;
            List javaList = (List)package$.MODULE$.decorateAsJava().seqAsJavaListConverter((Seq)((TraversableOnce)array.map((Function1 & Serializable & scala.Serializable)json -> MODULE$.circeToJackson((Json)json), Vector$.MODULE$.canBuildFrom())).toList()).asJava();
            ArrayNode node = new ArrayNode(factory);
            return node.addAll((Collection)javaList);
        }, (Function1 & Serializable & scala.Serializable)jsonObject -> {
            JsonNodeFactory factory = JsonNodeFactory.instance;
            java.util.Map javaMap = (java.util.Map)package$.MODULE$.decorateAsJava().mapAsJavaMapConverter((Map)jsonObject.toMap().mapValues((Function1 & Serializable & scala.Serializable)json -> MODULE$.circeToJackson((Json)json))).asJava();
            return new ObjectNode(factory, javaMap);
        });
    }

    private Option<String> stackTraceToString(Throwable e) {
        return this.truncateString(((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace())).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), List$.MODULE$.canBuildFrom())).mkString("\n"), this.MaxStackLength());
    }

    private Option<String> truncateString(String s, int maxLength) {
        return s.isEmpty() ? None$.MODULE$ : new Some(new StringOps(Predef$.MODULE$.augmentString(s)).take(maxLength));
    }

    public static final /* synthetic */ BooleanNode $anonfun$circeToJackson$2(boolean b) {
        return BooleanNode.valueOf((boolean)b);
    }

    private Payload$() {
        MODULE$ = this;
        this.LockedSchemaKey = new SchemaKey("com.snowplowanalytics.manifest", "locked_payload", "jsonschema", new SchemaVer.Full(1, 0, 0));
        this.ApplicationErrorSchemaKey = new SchemaKey("com.snowplowanalytics.snowplow", "application_error", "jsonschema", new SchemaVer.Full(1, 0, 2));
        this.MaxMessageLength = 2048;
        this.MaxStackLength = 8192;
        this.MaxExceptionNameLength = 1024;
    }
}

