/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.manifest.core;

import cats.Show;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.implicits$;
import com.snowplowanalytics.manifest.core.Application;
import com.snowplowanalytics.manifest.core.Application$;
import com.snowplowanalytics.manifest.core.Item;
import com.snowplowanalytics.manifest.core.ManifestError;
import com.snowplowanalytics.manifest.core.Record;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.LambdaDeserialize;

public final class ManifestError$
implements scala.Serializable {
    public static ManifestError$ MODULE$;
    private final Show<ManifestError> manifestErrorShow;

    static {
        new ManifestError$();
    }

    public ManifestError parseError(String message) {
        return new ManifestError.Corrupted(new ManifestError.Corruption.ParseError(message));
    }

    public ManifestError invalidContent(String message) {
        return new ManifestError.Corrupted(new ManifestError.Corruption.InvalidContent((NonEmptyList<String>)NonEmptyList$.MODULE$.one((Object)message)));
    }

    public Show<ManifestError> manifestErrorShow() {
        return this.manifestErrorShow;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ManifestError$() {
        MODULE$ = this;
        this.manifestErrorShow = new Show<ManifestError>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String show(ManifestError t) {
                ManifestError.Corruption corruption;
                ManifestError.Corruption corruption2;
                boolean bl = false;
                ManifestError.Locked locked = null;
                boolean bl2 = false;
                ManifestError.Corrupted corrupted = null;
                ManifestError manifestError = t;
                if (manifestError instanceof ManifestError.Locked) {
                    bl = true;
                    locked = (ManifestError.Locked)manifestError;
                    NonEmptyList<Record> reason = locked.reason();
                    Option<UUID> option = locked.acquired();
                    if (None$.MODULE$.equals(option)) {
                        List recordList = (List)reason.toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.show(), List$.MODULE$.canBuildFrom());
                        return new StringBuilder(134).append("Manifest is locked and app cannot proceed due following unconsumed records:\n").append(recordList.mkString("\n")).append(" ").append("\nResolve the problem and add `Resolved` record to proceed").toString();
                    }
                }
                if (bl) {
                    NonEmptyList<Record> reason = locked.reason();
                    Option<UUID> option = locked.acquired();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        UUID acquired = (UUID)some.value();
                        List recordList = (List)reason.toList().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.show(), List$.MODULE$.canBuildFrom());
                        return new StringBuilder(78).append("Manifest is locked and app cannot proceed due following unconsumed records:\n ").append(recordList.mkString("\n")).append(" ").append(new StringBuilder(80).append("This is probably happened due race condition for ").append(acquired).append(". Safe to add `Resolved` record").toString()).toString();
                    }
                }
                if (manifestError instanceof ManifestError.IoError) {
                    ManifestError.IoError ioError = (ManifestError.IoError)manifestError;
                    String message = ioError.message();
                    return new StringBuilder(74).append("IO Error during communication with manifest. Contact system administrator\n").append(message).toString();
                }
                if (manifestError instanceof ManifestError.ApplicationError) {
                    ManifestError.ApplicationError applicationError = (ManifestError.ApplicationError)manifestError;
                    Throwable throwable = applicationError.underlying();
                    Application app = applicationError.app();
                    UUID runId = applicationError.runId();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application ", " failed during ", " run. Action should be taken by operator. Exception details:\\n ", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)implicits$.MODULE$.toShow((Object)app, Application$.MODULE$.manifestErrorShow()).show(), (Show.ContravariantShow)implicits$.MODULE$.catsStdShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)runId, (Show.ContravariantShow)implicits$.MODULE$.catsStdShowForUUID())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)sw.toString(), (Show.ContravariantShow)implicits$.MODULE$.catsStdShowForString()))}));
                }
                if (manifestError instanceof ManifestError.Corrupted) {
                    bl2 = true;
                    corrupted = (ManifestError.Corrupted)manifestError;
                    ManifestError.Corruption corruption3 = corrupted.reason();
                    if (corruption3 instanceof ManifestError.Corruption.InvalidRequest) {
                        ManifestError.Corruption.InvalidRequest invalidRequest = (ManifestError.Corruption.InvalidRequest)corruption3;
                        String error = invalidRequest.message();
                        return new StringBuilder(26).append("Invalid manifest request. ").append(error).toString();
                    }
                }
                if (bl2 && (corruption2 = corrupted.reason()) instanceof ManifestError.Corruption.ItemLost) {
                    ManifestError.Corruption.ItemLost itemLost = (ManifestError.Corruption.ItemLost)corruption2;
                    Item item = itemLost.item();
                    return new StringBuilder(84).append("Invalid manifest state. Item ").append(item.id()).append(" disappeared between two requests. Contact developers. ").append(new StringBuilder(21).append("Full lost item info: ").append(item).toString()).toString();
                }
                if (bl2 && (corruption = corrupted.reason()) instanceof ManifestError.Corruption.InvalidContent) {
                    ManifestError.Corruption.InvalidContent invalidContent = (ManifestError.Corruption.InvalidContent)corruption;
                    NonEmptyList<String> errors = invalidContent.errors();
                    return new StringBuilder(106).append("Invalid manifest state. Item was constructed with unexpected content or content wasn't validated properly.").append(Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Contact developers. ", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)errors.toList().mkString(","), (Show.ContravariantShow)implicits$.MODULE$.catsStdShowForString()))}))).toString();
                }
                if (!bl2) throw new MatchError((Object)manifestError);
                ManifestError.Corruption corruption4 = corrupted.reason();
                if (!(corruption4 instanceof ManifestError.Corruption.ParseError)) throw new MatchError((Object)manifestError);
                ManifestError.Corruption.ParseError parseError = (ManifestError.Corruption.ParseError)corruption4;
                String errors = parseError.message();
                return Show.ShowInterpolator$.MODULE$.show$extension(implicits$.MODULE$.showInterpolator(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid manifest state. Some entity has unexpected content. Contact developers. \\n", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)errors, (Show.ContravariantShow)implicits$.MODULE$.catsStdShowForString()))}));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$show$1(com.snowplowanalytics.manifest.core.Record ), $anonfun$show$2(com.snowplowanalytics.manifest.core.Record )}, serializedLambda);
            }
        };
    }
}

