/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.payload;

import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.payload.Payload;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016J0\u0010\u0014\u001a\u00020\u00112\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u001e\u0010\u0014\u001a\u00020\u00112\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR0\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/snowplowanalytics/snowplow/payload/TrackerPayload;", "Lcom/snowplowanalytics/snowplow/payload/Payload;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "byteSize", "", "getByteSize", "()J", "map", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "add", "", "key", "value", "addMap", "", "base64_encoded", "", "type_encoded", "type_no_encoded", "toString", "snowplow-android-tracker_release"})
public final class TrackerPayload
implements Payload {
    private final String TAG = TrackerPayload.class.getSimpleName();
    @NotNull
    private final HashMap<String, Object> map = new HashMap();

    @NotNull
    public HashMap<String, Object> getMap() {
        return this.map;
    }

    @Override
    public void add(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null || ((CharSequence)value).length() == 0) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{key};
            Logger.v(string, "The keys value is empty, removing the key: %s", objectArray);
            ((HashMap)this.getMap()).remove(key);
            return;
        }
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{value};
        Logger.v(string, "Adding new kv pair: " + key + "->%s", objectArray);
        this.getMap().put(key, value);
    }

    @Override
    public void add(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{key};
            Logger.v(string, "The value is empty, removing the key: %s", objectArray);
            ((HashMap)this.getMap()).remove(key);
            return;
        }
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{value};
        Logger.v(string, "Adding new kv pair: " + key + "->%s", objectArray);
        this.getMap().put(key, value);
    }

    @Override
    public void addMap(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{map};
        Logger.v(string, "Adding new map: %s", objectArray);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.add(key, value);
        }
    }

    @Override
    public void addMap(@NotNull Map<?, ?> map, boolean base64_encoded, @NotNull String type_encoded, @NotNull String type_no_encoded) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)type_encoded, (String)"type_encoded");
        Intrinsics.checkNotNullParameter((Object)type_no_encoded, (String)"type_no_encoded");
        String string = new JSONObject(map).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(map).toString()");
        String mapString = string;
        String string2 = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        Object[] objectArray = new Object[]{map};
        Logger.v(string2, "Adding new map: %s", objectArray);
        if (base64_encoded) {
            this.add(type_encoded, Util.base64Encode(mapString));
        } else {
            this.add(type_no_encoded, mapString);
        }
    }

    @Override
    @NotNull
    public String toString() {
        Map map = this.getMap();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        String string = new JSONObject(map).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject(map as Map<*, *>).toString()");
        return string;
    }

    @Override
    public long getByteSize() {
        return Util.getUTF8Length(this.toString());
    }
}

