/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ$\u0010\u0011\u001a\u00020\u00052\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/snowplowanalytics/snowplow/network/RequestResult;", "", "statusCode", "", "oversize", "", "eventIds", "", "", "(IZLjava/util/List;)V", "getEventIds", "()Ljava/util/List;", "isSuccessful", "()Z", "getOversize", "getStatusCode", "()I", "shouldRetry", "customRetryForStatusCodes", "", "retryAllowed", "snowplow-android-tracker_release"})
public final class RequestResult {
    private final int statusCode;
    private final boolean oversize;
    @NotNull
    private final List<Long> eventIds;

    public RequestResult(int statusCode, boolean oversize, @NotNull List<Long> eventIds) {
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        this.statusCode = statusCode;
        this.oversize = oversize;
        this.eventIds = eventIds;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final boolean getOversize() {
        return this.oversize;
    }

    @NotNull
    public final List<Long> getEventIds() {
        return this.eventIds;
    }

    public final boolean isSuccessful() {
        int n = this.statusCode;
        return 200 <= n ? n < 300 : false;
    }

    public final boolean shouldRetry(@Nullable Map<Integer, Boolean> customRetryForStatusCodes, boolean retryAllowed) {
        if (this.isSuccessful()) {
            return false;
        }
        if (!retryAllowed) {
            return false;
        }
        if (this.oversize) {
            return false;
        }
        Map<Integer, Boolean> map = customRetryForStatusCodes;
        boolean bl = map != null ? map.containsKey(this.statusCode) : false;
        if (bl) {
            Boolean bl2 = customRetryForStatusCodes.get(this.statusCode);
            Intrinsics.checkNotNull((Object)bl2);
            return bl2;
        }
        Object[] objectArray = new Integer[]{400, 401, 403, 410, 422};
        Set dontRetryStatusCodes = new HashSet(CollectionsKt.listOf((Object[])objectArray));
        return !dontRetryStatusCodes.contains(this.statusCode);
    }
}

