/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import android.content.Context;
import android.content.SharedPreferences;
import com.snowplowanalytics.snowplow.network.CollectorCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/snowplowanalytics/snowplow/network/CollectorCookieJar;", "Lokhttp3/CookieJar;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cookies", "", "Lcom/snowplowanalytics/snowplow/network/CollectorCookie;", "sharedPreferences", "Landroid/content/SharedPreferences;", "clear", "", "loadForRequest", "", "Lokhttp3/Cookie;", "url", "Lokhttp3/HttpUrl;", "loadFromSharedPreferences", "removeAll", "cookiesToRemove", "", "saveAll", "newCookies", "saveFromResponse", "snowplow-android-tracker_release"})
public final class CollectorCookieJar
implements CookieJar {
    @NotNull
    private final Set<CollectorCookie> cookies;
    @NotNull
    private final SharedPreferences sharedPreferences;

    public CollectorCookieJar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(ConcurrentHashMap())");
        this.cookies = set;
        SharedPreferences sharedPreferences = context.getSharedPreferences("cookie_persistance", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026CE, Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        this.loadFromSharedPreferences();
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        List cookiesToRemove = new ArrayList();
        List validCookies = new ArrayList();
        for (CollectorCookie currentCookie : this.cookies) {
            if (currentCookie.isExpired()) {
                cookiesToRemove.add(currentCookie);
                continue;
            }
            if (!currentCookie.getCookie().matches(url)) continue;
            validCookies.add(currentCookie.getCookie());
        }
        if (!((Collection)cookiesToRemove).isEmpty()) {
            this.removeAll(cookiesToRemove);
        }
        return validCookies;
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        this.saveAll((Collection<Cookie>)cookies);
    }

    public final void clear() {
        this.sharedPreferences.edit().clear().apply();
        this.cookies.clear();
    }

    private final void loadFromSharedPreferences() {
        List cookiesToRemove = new ArrayList();
        Map map = this.sharedPreferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"sharedPreferences.all");
        for (Map.Entry object : map.entrySet()) {
            String serializedCookie;
            String key = (String)object.getKey();
            Object value = object.getValue();
            if ((value instanceof String ? (String)value : null) == null) continue;
            serializedCookie = serializedCookie;
            try {
                CollectorCookie cookie = new CollectorCookie(serializedCookie);
                this.cookies.add(cookie);
            }
            catch (JSONException ignored) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                cookiesToRemove.add(key);
            }
        }
        if (!((Collection)cookiesToRemove).isEmpty()) {
            SharedPreferences.Editor editor = this.sharedPreferences.edit();
            for (String cookie : cookiesToRemove) {
                editor.remove(cookie);
            }
            editor.apply();
        }
    }

    private final void saveAll(Collection<Cookie> newCookies) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (CollectorCookie cookie : CollectorCookie.Companion.decorateAll(newCookies)) {
            this.cookies.remove(cookie);
            this.cookies.add(cookie);
            editor.putString(cookie.getCookieKey(), cookie.serialize());
        }
        editor.apply();
    }

    private final void removeAll(Collection<CollectorCookie> cookiesToRemove) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (CollectorCookie cookie : cookiesToRemove) {
            this.cookies.remove(cookie);
            editor.remove(cookie.getCookieKey());
        }
        editor.apply();
    }
}

