/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.event;

import com.snowplowanalytics.core.tracker.Tracker;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.ConsentDocument;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013\u00a8\u0006%"}, d2={"Lcom/snowplowanalytics/snowplow/event/ConsentGranted;", "Lcom/snowplowanalytics/snowplow/event/AbstractSelfDescribing;", "expiry", "", "documentId", "documentVersion", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "consentDocuments", "", "Lcom/snowplowanalytics/snowplow/event/ConsentDocument;", "getConsentDocuments", "()Ljava/util/List;", "dataPayload", "", "", "getDataPayload", "()Ljava/util/Map;", "documentDescription", "getDocumentDescription", "()Ljava/lang/String;", "setDocumentDescription", "(Ljava/lang/String;)V", "getDocumentId", "documentName", "getDocumentName", "setDocumentName", "getDocumentVersion", "documents", "", "getDocuments", "getExpiry", "schema", "getSchema", "beginProcessing", "", "tracker", "Lcom/snowplowanalytics/core/tracker/Tracker;", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nConsentGranted.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentGranted.kt\ncom/snowplowanalytics/snowplow/event/ConsentGranted\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class ConsentGranted
extends AbstractSelfDescribing {
    @NotNull
    private final String expiry;
    @NotNull
    private final String documentId;
    @NotNull
    private final String documentVersion;
    @Nullable
    private String documentName;
    @Nullable
    private String documentDescription;
    @NotNull
    private final List<ConsentDocument> consentDocuments;

    public ConsentGranted(@NotNull String expiry, @NotNull String documentId, @NotNull String documentVersion) {
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentVersion, (String)"documentVersion");
        this.consentDocuments = new LinkedList();
        if (!(((CharSequence)expiry).length() > 0)) {
            boolean $i$a$-require-ConsentGranted$42 = false;
            String $i$a$-require-ConsentGranted$42 = "Expiry cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ConsentGranted$42.toString());
        }
        if (!(((CharSequence)documentId).length() > 0)) {
            boolean $i$a$-require-ConsentGranted$52 = false;
            String $i$a$-require-ConsentGranted$52 = "Document ID cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ConsentGranted$52.toString());
        }
        if (!(((CharSequence)documentVersion).length() > 0)) {
            boolean bl = false;
            String string = "Document version cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        this.expiry = expiry;
        this.documentId = documentId;
        this.documentVersion = documentVersion;
    }

    @NotNull
    public final String getExpiry() {
        return this.expiry;
    }

    @NotNull
    public final String getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final String getDocumentVersion() {
        return this.documentVersion;
    }

    @Nullable
    public final String getDocumentName() {
        return this.documentName;
    }

    public final void setDocumentName(@Nullable String string) {
        this.documentName = string;
    }

    @Nullable
    public final String getDocumentDescription() {
        return this.documentDescription;
    }

    public final void setDocumentDescription(@Nullable String string) {
        this.documentDescription = string;
    }

    @NotNull
    public final List<ConsentDocument> getConsentDocuments() {
        return this.consentDocuments;
    }

    @NotNull
    public final ConsentGranted documentName(@Nullable String documentName) {
        this.documentName = documentName;
        return this;
    }

    @NotNull
    public final ConsentGranted documentDescription(@Nullable String documentDescription) {
        this.documentDescription = documentDescription;
        return this;
    }

    @NotNull
    public final ConsentGranted documents(@NotNull List<ConsentDocument> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.consentDocuments.clear();
        this.consentDocuments.addAll((Collection<ConsentDocument>)documents);
        return this;
    }

    @NotNull
    public final List<ConsentDocument> getDocuments() {
        List docs = new ArrayList();
        ConsentDocument doc = new ConsentDocument(this.documentId, this.documentVersion).documentDescription(this.documentDescription).documentName(this.documentName);
        docs.add(doc);
        docs.addAll((Collection)this.consentDocuments);
        return docs;
    }

    @Override
    @NotNull
    public Map<String, Object> getDataPayload() {
        HashMap payload = new HashMap();
        ((Map)payload).put("expiry", this.expiry);
        return payload;
    }

    @Override
    @NotNull
    public String getSchema() {
        return "iglu:com.snowplowanalytics.snowplow/consent_granted/jsonschema/1-0-0";
    }

    @Override
    public void beginProcessing(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        for (ConsentDocument document : this.getDocuments()) {
            SelfDescribingJson context = new SelfDescribingJson(document.getSchema(), document.getDataPayload());
            this.customContexts.add(context);
        }
    }
}

