/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.configuration;

import android.net.Uri;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.PluginAfterTrackCallable;
import com.snowplowanalytics.snowplow.configuration.PluginAfterTrackConfiguration;
import com.snowplowanalytics.snowplow.configuration.PluginIdentifiable;
import com.snowplowanalytics.snowplow.entity.ClientSessionEntity;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/snowplowanalytics/snowplow/configuration/FocalMeterConfiguration;", "Lcom/snowplowanalytics/snowplow/configuration/Configuration;", "Lcom/snowplowanalytics/snowplow/configuration/PluginAfterTrackCallable;", "Lcom/snowplowanalytics/snowplow/configuration/PluginIdentifiable;", "kantarEndpoint", "", "processUserId", "Ljava/util/function/Function;", "(Ljava/lang/String;Ljava/util/function/Function;)V", "TAG", "kotlin.jvm.PlatformType", "afterTrackConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/PluginAfterTrackConfiguration;", "getAfterTrackConfiguration", "()Lcom/snowplowanalytics/snowplow/configuration/PluginAfterTrackConfiguration;", "identifier", "getIdentifier", "()Ljava/lang/String;", "getKantarEndpoint", "lastUserId", "getProcessUserId", "()Ljava/util/function/Function;", "copy", "makeRequest", "", "userId", "shouldUpdate", "", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nFocalMeterConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocalMeterConfiguration.kt\ncom/snowplowanalytics/snowplow/configuration/FocalMeterConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class FocalMeterConfiguration
implements Configuration,
PluginAfterTrackCallable,
PluginIdentifiable {
    @NotNull
    private final String kantarEndpoint;
    @Nullable
    private final Function<String, String> processUserId;
    private final String TAG;
    @Nullable
    private String lastUserId;

    public FocalMeterConfiguration(@NotNull String kantarEndpoint, @Nullable Function<String, String> processUserId) {
        Intrinsics.checkNotNullParameter((Object)kantarEndpoint, (String)"kantarEndpoint");
        this.kantarEndpoint = kantarEndpoint;
        this.processUserId = processUserId;
        this.TAG = FocalMeterConfiguration.class.getSimpleName();
    }

    public /* synthetic */ FocalMeterConfiguration(String string, Function function, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function = null;
        }
        this(string, function);
    }

    @NotNull
    public final String getKantarEndpoint() {
        return this.kantarEndpoint;
    }

    @Nullable
    public final Function<String, String> getProcessUserId() {
        return this.processUserId;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "KantarFocalMeter";
    }

    @Override
    @Nullable
    public PluginAfterTrackConfiguration getAfterTrackConfiguration() {
        return new PluginAfterTrackConfiguration(null, arg_0 -> FocalMeterConfiguration._get_afterTrackConfiguration_$lambda$2(this, arg_0), 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean shouldUpdate(String userId) {
        FocalMeterConfiguration focalMeterConfiguration = this;
        synchronized (focalMeterConfiguration) {
            block4: {
                boolean bl = false;
                if (this.lastUserId != null && Intrinsics.areEqual((Object)this.lastUserId, (Object)userId)) break block4;
                this.lastUserId = userId;
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
    }

    private final void makeRequest(String userId) {
        Uri.Builder uriBuilder = Uri.parse((String)this.kantarEndpoint).buildUpon();
        uriBuilder.appendQueryParameter("vendor", "snowplow");
        uriBuilder.appendQueryParameter("cs_fpid", userId);
        uriBuilder.appendQueryParameter("c12", "not_set");
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build();
        Request.Builder builder2 = new Request.Builder();
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
        Request request = builder2.url(string).build();
        try {
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String string2 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Logger.d(string2, "Request to Kantar endpoint sent with user ID: " + userId, new Object[0]);
            } else {
                String string3 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                Logger.e(string3, "Request to Kantar endpoint failed with code: " + response.code(), new Object[0]);
            }
        }
        catch (IOException e) {
            String string4 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            Logger.e(string4, "Request to Kantar endpoint failed with exception: " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    @NotNull
    public Configuration copy() {
        return new FocalMeterConfiguration(this.kantarEndpoint, null, 2, null);
    }

    private static final void _get_afterTrackConfiguration_$lambda$2(FocalMeterConfiguration this$0, InspectableEvent event) {
        block4: {
            ClientSessionEntity session;
            Object object;
            Object var3_8;
            block3: {
                Object v0;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Iterable iterable = event.getEntities();
                for (Object t : iterable) {
                    SelfDescribingJson it = (SelfDescribingJson)t;
                    boolean bl = false;
                    if (!(it instanceof ClientSessionEntity)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = var3_8 = null;
            }
            if ((object = (session = var3_8 instanceof ClientSessionEntity ? (ClientSessionEntity)var3_8 : null)) == null || (object = ((ClientSessionEntity)object).getUserId()) == null) break block4;
            Object newUserId = object;
            boolean bl = false;
            if (this$0.shouldUpdate((String)newUserId)) {
                Function<String, String> function = this$0.processUserId;
                if (function == null || (function = function.apply((String)newUserId)) == null) {
                    function = newUserId;
                }
                Intrinsics.checkNotNullExpressionValue((Object)function, (String)"processUserId?.apply(newUserId) ?: newUserId");
                Function<String, String> processedUserId = function;
                this$0.makeRequest((String)((Object)processedUserId));
            }
        }
    }
}

