/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Base64;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010#\u001a\u00020\u00042\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0%H\u0007J5\u0010&\u001a\u00020\"2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040(\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010)J(\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000fH\u0007J\u001e\u0010+\u001a\u0004\u0018\u00010\u00112\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0007J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\b\u00101\u001a\u00020\u0004H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/snowplowanalytics/core/utils/Util;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "addToMap", "", "key", "value", "map", "", "base64Encode", "string", "deserializer", "", "bytes", "", "getApplicationContext", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "context", "Landroid/content/Context;", "getDateTimeFromDate", "date", "Ljava/util/Date;", "getDateTimeFromTimestamp", "timestamp", "", "getGeoLocationContext", "getLastKnownLocation", "Landroid/location/Location;", "getUTF8Length", "s", "isOnline", "", "joinLongList", "list", "", "mapHasKeys", "keys", "", "(Ljava/util/Map;[Ljava/lang/String;)Z", "objectMapToString", "serialize", "stackTraceToString", "e", "", "truncateUrlScheme", "url", "uUIDString", "snowplow-android-tracker_release"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();
    private static final String TAG = Util.class.getSimpleName();

    private Util() {
    }

    @JvmStatic
    @NotNull
    public static final String timestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    @JvmStatic
    @NotNull
    public static final String getDateTimeFromTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        return Util.getDateTimeFromDate(date);
    }

    @JvmStatic
    @NotNull
    public static final String getDateTimeFromDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", new Locale("en"));
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(date)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String base64Encode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string3 = Base64.encodeToString((byte[])byArray, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(string.to\u2026eArray(), Base64.NO_WRAP)");
        return string3;
    }

    @JvmStatic
    @NotNull
    public static final String uUIDString() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @JvmStatic
    public static final long getUTF8Length(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        long len = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            if (code <= '\u007f') {
                ++len;
                continue;
            }
            if (code <= '\u07ff') {
                len += (long)2;
                continue;
            }
            char c = code;
            boolean bl = '\ud800' <= c ? c < '\ue000' : false;
            if (bl) {
                len += (long)4;
                ++i;
                continue;
            }
            if (code < '\uffff') {
                len += (long)3;
                continue;
            }
            len += (long)4;
        }
        return len;
    }

    @JvmStatic
    public static final boolean isOnline(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Checking tracker internet connectivity.", new Object[0]);
        Object object = context.getSystemService("connectivity");
        ConnectivityManager cm = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        try {
            ConnectivityManager connectivityManager = cm;
            NetworkInfo ni = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
            boolean connected = ni != null && ni.isConnected();
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{connected};
            Logger.d(string2, "Tracker connection online: %s", objectArray);
            bl = connected;
        }
        catch (SecurityException e) {
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            Object[] objectArray = new Object[]{e.toString()};
            Logger.e(string3, "Security exception checking connection: %s", objectArray);
            bl = true;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String joinLongList(@NotNull List<Long> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        StringBuilder s = new StringBuilder();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Long longVal = list.get(i);
            if (longVal == null) continue;
            s.append(list.get(i));
            if (i >= list.size() - 1) continue;
            s.append(",");
        }
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s.toString()");
        if (StringsKt.endsWith$default((String)string, (String)",", (boolean)false, (int)2, null)) {
            s = new StringBuilder(s.substring(0, s.length() - 1));
        }
        String string2 = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"s.toString()");
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final SelfDescribingJson getGeoLocationContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Location location = INSTANCE.getLastKnownLocation(context);
        if (location != null) {
            Map pairs = new HashMap();
            Util.addToMap("latitude", location.getLatitude(), pairs);
            Util.addToMap("longitude", location.getLongitude(), pairs);
            Util.addToMap("altitude", location.getAltitude(), pairs);
            Util.addToMap("latitudeLongitudeAccuracy", Float.valueOf(location.getAccuracy()), pairs);
            Util.addToMap("speed", Float.valueOf(location.getSpeed()), pairs);
            Util.addToMap("bearing", Float.valueOf(location.getBearing()), pairs);
            Util.addToMap("timestamp", System.currentTimeMillis(), pairs);
            String[] stringArray = new String[]{"latitude", "longitude"};
            if (Util.mapHasKeys(pairs, stringArray)) {
                return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/geolocation_context/jsonschema/1-1-0", pairs);
            }
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public final Location getLastKnownLocation(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        LocationManager locationManager = object instanceof LocationManager ? (LocationManager)object : null;
        Location location = null;
        try {
            Object it;
            String locationProvider = null;
            LocationManager locationManager2 = locationManager;
            boolean bl = locationManager2 != null ? locationManager2.isProviderEnabled("gps") : false;
            if (bl) {
                locationProvider = "gps";
            } else {
                LocationManager locationManager3 = locationManager;
                boolean bl2 = locationManager3 != null ? locationManager3.isProviderEnabled("network") : false;
                if (bl2) {
                    locationProvider = "network";
                } else {
                    List locationProviders;
                    LocationManager locationManager4 = locationManager;
                    List list = locationProviders = locationManager4 != null ? locationManager4.getProviders(true) : null;
                    if (list != null) {
                        it = list;
                        boolean bl3 = false;
                        if (it.size() > 0) {
                            locationProvider = it.get(0);
                        }
                    }
                }
            }
            String string = locationProvider;
            if (string != null) {
                it = string;
                boolean bl4 = false;
                if (((CharSequence)it).length() > 0) {
                    LocationManager locationManager5 = locationManager;
                    location = locationManager5 != null ? locationManager5.getLastKnownLocation((String)it) : null;
                }
            }
        }
        catch (SecurityException ex) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{ex.toString()};
            Logger.e(string, "Exception occurred when retrieving location: %s", objectArray);
        }
        return location;
    }

    @JvmStatic
    @Nullable
    public static final SelfDescribingJson getApplicationContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            String versionCode;
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = pInfo.versionName;
            String string = versionCode = Build.VERSION.SDK_INT >= 28 ? String.valueOf(pInfo.getLongVersionCode()) : String.valueOf(pInfo.versionCode);
            if (versionName != null) {
                Map pairs = new HashMap();
                Util.addToMap("version", versionName, pairs);
                Util.addToMap("build", versionCode, pairs);
                return new SelfDescribingJson("iglu:com.snowplowanalytics.mobile/application/jsonschema/1-0-0", pairs);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{e.getMessage()};
            Logger.e(string, "Failed to find application context: %s", objectArray);
        }
        return null;
    }

    @JvmStatic
    public static final boolean mapHasKeys(@NotNull Map<String, ? extends Object> map, String ... keys) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        for (String key : keys) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final void addToMap(@Nullable String key, @Nullable Object value, @NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (key != null && value != null && !(((CharSequence)key).length() == 0)) {
            map.put(key, value);
        }
    }

    @JvmStatic
    @Nullable
    public static final byte[] serialize(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        byte[] newByteArray = null;
        try {
            ByteArrayOutputStream memOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(memOut);
            out.writeObject(map);
            out.close();
            memOut.close();
            newByteArray = memOut.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newByteArray;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> deserializer(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Map newMap = null;
        try {
            ByteArrayInputStream memIn = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(memIn);
            Object object = in.readObject();
            Map map = object instanceof HashMap ? (HashMap)object : null;
            in.close();
            memIn.close();
            newMap = map;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newMap;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> objectMapToString(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Map stringsMap = new HashMap();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            stringsMap.put(key, value.toString());
        }
        return stringsMap;
    }

    @JvmStatic
    @NotNull
    public static final String stackTraceToString(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    @NotNull
    public final String truncateUrlScheme(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String[] stringArray = new String[]{"://"};
        List parts = StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() > 1) {
            List updatedParts = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)StringsKt.take((String)((String)CollectionsKt.first((List)parts)), (int)16)), (Iterable)CollectionsKt.drop((Iterable)parts, (int)1));
            return CollectionsKt.joinToString$default((Iterable)updatedParts, (CharSequence)"://", null, null, (int)0, null, null, (int)62, null);
        }
        return url;
    }
}

