/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.utils;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\nH\u0007J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/snowplowanalytics/core/utils/NotificationCenter;", "", "()V", "notificationMap", "", "", "", "Lcom/snowplowanalytics/core/utils/NotificationCenter$WeakObserver;", "observerMap", "Ljava/util/WeakHashMap;", "Lcom/snowplowanalytics/core/utils/NotificationCenter$FunctionalObserver;", "addObserver", "", "notificationType", "observer", "postNotification", "", "data", "", "removeAll", "removeObserver", "FunctionalObserver", "WeakObserver", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nNotificationCenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationCenter.kt\ncom/snowplowanalytics/core/utils/NotificationCenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class NotificationCenter {
    @NotNull
    public static final NotificationCenter INSTANCE = new NotificationCenter();
    @NotNull
    private static final Map<String, List<WeakObserver>> notificationMap = new HashMap();
    @NotNull
    private static final WeakHashMap<FunctionalObserver, WeakObserver> observerMap = new WeakHashMap();

    private NotificationCenter() {
    }

    @JvmStatic
    public static final synchronized void addObserver(@NotNull String notificationType, @NotNull FunctionalObserver observer) {
        WeakObserver previousObserver;
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        WeakObserver weakObserver = new WeakObserver(observer);
        WeakObserver weakObserver2 = previousObserver = observerMap.put(observer, weakObserver);
        if (weakObserver2 != null) {
            weakObserver2.invalidate();
        }
        List observers = notificationMap.get(notificationType);
        if (observers == null) {
            observers = new LinkedList();
            notificationMap.put(notificationType, observers);
        }
        observers.add((WeakObserver)weakObserver);
    }

    @JvmStatic
    public static final synchronized boolean removeObserver(@NotNull FunctionalObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        WeakObserver weakObserver = observerMap.remove(observer);
        if (weakObserver != null) {
            weakObserver.invalidate();
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final synchronized void removeAll() {
        observerMap.clear();
        notificationMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final synchronized boolean postNotification(@NotNull String notificationType, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        List<WeakObserver> observers = notificationMap.get(notificationType);
        if (observers == null || observers.isEmpty()) {
            return false;
        }
        Iterator<WeakObserver> iterator = observers.iterator();
        while (iterator.hasNext()) {
            WeakObserver weakObserver = iterator.next();
            if (!weakObserver.isValid()) {
                Class<NotificationCenter> clazz = NotificationCenter.class;
                synchronized (clazz) {
                    boolean bl = false;
                    iterator.remove();
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
            }
            Map dataCopy = new HashMap<String, Object>(data);
            FunctionalObserver functionalObserver = (FunctionalObserver)weakObserver.get();
            if (functionalObserver == null) continue;
            functionalObserver.apply(dataCopy);
        }
        return !((Collection)observers).isEmpty();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H&\u00a8\u0006\b"}, d2={"Lcom/snowplowanalytics/core/utils/NotificationCenter$FunctionalObserver;", "", "()V", "apply", "", "data", "", "", "snowplow-android-tracker_release"})
    public static abstract class FunctionalObserver {
        public abstract void apply(@NotNull Map<String, ? extends Object> var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/snowplowanalytics/core/utils/NotificationCenter$WeakObserver;", "Ljava/lang/ref/WeakReference;", "Lcom/snowplowanalytics/core/utils/NotificationCenter$FunctionalObserver;", "referent", "(Lcom/snowplowanalytics/core/utils/NotificationCenter$FunctionalObserver;)V", "valid", "", "invalidate", "", "isValid", "snowplow-android-tracker_release"})
    private static final class WeakObserver
    extends WeakReference<FunctionalObserver> {
        private boolean valid = true;

        public WeakObserver(@Nullable FunctionalObserver referent) {
            super(referent);
        }

        public final synchronized boolean isValid() {
            return this.valid && this.get() != null;
        }

        public final synchronized void invalidate() {
            this.valid = false;
            this.clear();
        }
    }
}

