/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.tracker.SubjectConfigurationInterface;
import com.snowplowanalytics.snowplow.util.Size;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010042\u0006\u00105\u001a\u000206J\b\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u0002082\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010:\u001a\u000208H\u0002R*\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R(\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R(\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R(\u0010%\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001c\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010*\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010\u0014R(\u0010-\u001a\u0004\u0018\u00010\u00102\b\u0010-\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010\u0014R(\u00100\u001a\u0004\u0018\u00010\u00102\b\u00100\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0012\"\u0004\b2\u0010\u0014\u00a8\u0006<"}, d2={"Lcom/snowplowanalytics/core/tracker/Subject;", "", "context", "Landroid/content/Context;", "config", "Lcom/snowplowanalytics/core/tracker/SubjectConfigurationInterface;", "(Landroid/content/Context;Lcom/snowplowanalytics/core/tracker/SubjectConfigurationInterface;)V", "depth", "", "colorDepth", "getColorDepth", "()Ljava/lang/Integer;", "setColorDepth", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "domainUserId", "", "getDomainUserId", "()Ljava/lang/String;", "setDomainUserId", "(Ljava/lang/String;)V", "ipAddress", "getIpAddress", "setIpAddress", "language", "getLanguage", "setLanguage", "networkUserId", "getNetworkUserId", "setNetworkUserId", "size", "Lcom/snowplowanalytics/snowplow/util/Size;", "screenResolution", "getScreenResolution", "()Lcom/snowplowanalytics/snowplow/util/Size;", "setScreenResolution", "(Lcom/snowplowanalytics/snowplow/util/Size;)V", "screenViewPort", "getScreenViewPort", "setScreenViewPort", "standardPairs", "Ljava/util/HashMap;", "timezone", "getTimezone", "setTimezone", "userId", "getUserId", "setUserId", "useragent", "getUseragent", "setUseragent", "getSubject", "", "userAnonymisation", "", "setDefaultLanguage", "", "setDefaultScreenResolution", "setDefaultTimezone", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nSubject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Subject.kt\ncom/snowplowanalytics/core/tracker/Subject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class Subject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, String> standardPairs;
    @Nullable
    private String userId;
    @Nullable
    private String networkUserId;
    @Nullable
    private String domainUserId;
    @Nullable
    private String useragent;
    @Nullable
    private String ipAddress;
    @Nullable
    private String timezone;
    @Nullable
    private String language;
    @Nullable
    private Size screenResolution;
    @Nullable
    private Size screenViewPort;
    @Nullable
    private Integer colorDepth;
    private static final String TAG = Subject.class.getSimpleName();

    public Subject(@NotNull Context context, @Nullable SubjectConfigurationInterface config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.standardPairs = new HashMap();
        this.setDefaultTimezone();
        this.setDefaultLanguage();
        this.setDefaultScreenResolution(context);
        if (config != null) {
            Object it;
            String string = config.getUserId();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.setUserId((String)it);
            }
            String string2 = config.getNetworkUserId();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.setNetworkUserId((String)it);
            }
            String string3 = config.getDomainUserId();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                this.setDomainUserId((String)it);
            }
            String string4 = config.getUseragent();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                this.setUseragent((String)it);
            }
            String string5 = config.getIpAddress();
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                this.setIpAddress((String)it);
            }
            String string6 = config.getTimezone();
            if (string6 != null) {
                it = string6;
                boolean bl = false;
                this.setTimezone((String)it);
            }
            String string7 = config.getLanguage();
            if (string7 != null) {
                it = string7;
                boolean bl = false;
                this.setLanguage((String)it);
            }
            Size size = config.getScreenResolution();
            if (size != null) {
                it = size;
                boolean bl = false;
                this.setScreenResolution((Size)it);
            }
            Size size2 = config.getScreenViewPort();
            if (size2 != null) {
                it = size2;
                boolean bl = false;
                this.setScreenViewPort((Size)it);
            }
            Integer n = config.getColorDepth();
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                this.setColorDepth(it2);
            }
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Subject created successfully.", new Object[0]);
    }

    @Nullable
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@Nullable String userId) {
        this.userId = userId;
        ((Map)this.standardPairs).put("uid", userId);
    }

    @Nullable
    public final String getNetworkUserId() {
        return this.networkUserId;
    }

    public final void setNetworkUserId(@Nullable String networkUserId) {
        if (networkUserId == null) {
            return;
        }
        this.networkUserId = networkUserId;
        ((Map)this.standardPairs).put("tnuid", networkUserId);
    }

    @Nullable
    public final String getDomainUserId() {
        return this.domainUserId;
    }

    public final void setDomainUserId(@Nullable String domainUserId) {
        if (domainUserId == null) {
            return;
        }
        this.domainUserId = domainUserId;
        ((Map)this.standardPairs).put("duid", domainUserId);
    }

    @Nullable
    public final String getUseragent() {
        return this.useragent;
    }

    public final void setUseragent(@Nullable String useragent) {
        if (useragent == null) {
            return;
        }
        this.useragent = useragent;
        ((Map)this.standardPairs).put("ua", useragent);
    }

    @Nullable
    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final void setIpAddress(@Nullable String ipAddress) {
        if (ipAddress == null) {
            return;
        }
        this.ipAddress = ipAddress;
        ((Map)this.standardPairs).put("ip", ipAddress);
    }

    @Nullable
    public final String getTimezone() {
        return this.timezone;
    }

    public final void setTimezone(@Nullable String timezone) {
        if (timezone == null) {
            return;
        }
        this.timezone = timezone;
        ((Map)this.standardPairs).put("tz", timezone);
    }

    @Nullable
    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(@Nullable String language) {
        if (language == null) {
            return;
        }
        this.language = language;
        ((Map)this.standardPairs).put("lang", language);
    }

    @Nullable
    public final Size getScreenResolution() {
        return this.screenResolution;
    }

    public final void setScreenResolution(@Nullable Size size) {
        if (size == null) {
            return;
        }
        this.screenResolution = size;
        String res = "" + size.getWidth() + 'x' + size.getHeight();
        ((Map)this.standardPairs).put("res", res);
    }

    @Nullable
    public final Size getScreenViewPort() {
        return this.screenViewPort;
    }

    public final void setScreenViewPort(@Nullable Size size) {
        if (size == null) {
            return;
        }
        this.screenViewPort = size;
        String res = "" + size.getWidth() + 'x' + size.getHeight();
        ((Map)this.standardPairs).put("vp", res);
    }

    @Nullable
    public final Integer getColorDepth() {
        return this.colorDepth;
    }

    public final void setColorDepth(@Nullable Integer depth) {
        if (depth == null) {
            return;
        }
        this.colorDepth = depth;
        ((Map)this.standardPairs).put("cd", depth.toString());
    }

    private final void setDefaultTimezone() {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        this.setTimezone(tz.getID());
    }

    private final void setDefaultLanguage() {
        this.setLanguage(Locale.getDefault().getDisplayLanguage());
    }

    private final void setDefaultScreenResolution(Context context) {
        WindowManager windowManager;
        Object object = context.getSystemService("window");
        WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Display display = windowManager2 != null ? windowManager2.getDefaultDisplay() : null;
        Point size = new Point();
        Display display2 = display;
        if (display2 != null) {
            display2.getSize(size);
        }
        this.setScreenResolution(new Size(size.x, size.y));
    }

    @NotNull
    public final Map<String, String> getSubject(boolean userAnonymisation) {
        if (userAnonymisation) {
            Map pairsCopy = new HashMap(this.standardPairs);
            pairsCopy.remove("uid");
            pairsCopy.remove("duid");
            pairsCopy.remove("tnuid");
            pairsCopy.remove("ip");
            return pairsCopy;
        }
        return this.standardPairs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/tracker/Subject$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

