/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.statemachine.State;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002JR\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J,\u0010\u001d\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/snowplowanalytics/core/tracker/ScreenState;", "Lcom/snowplowanalytics/core/statemachine/State;", "()V", "activityClassName", "", "activityTag", "fragmentClassName", "fragmentTag", "id", "name", "<set-?>", "previousId", "getPreviousId", "()Ljava/lang/String;", "previousName", "getPreviousName", "previousType", "getPreviousType", "transitionType", "type", "getCurrentScreen", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "debug", "", "getValidName", "s1", "s2", "populatePreviousFields", "", "updateScreenState", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ScreenState
implements State {
    @NotNull
    private String name = "Unknown";
    @Nullable
    private String type;
    @NotNull
    private String id = Util.uUIDString();
    @Nullable
    private String previousName;
    @Nullable
    private String previousId;
    @Nullable
    private String previousType;
    @Nullable
    private String transitionType;
    @Nullable
    private String fragmentClassName;
    @Nullable
    private String fragmentTag;
    @Nullable
    private String activityClassName;
    @Nullable
    private String activityTag;

    @Nullable
    public final String getPreviousName() {
        return this.previousName;
    }

    @Nullable
    public final String getPreviousId() {
        return this.previousId;
    }

    @Nullable
    public final String getPreviousType() {
        return this.previousType;
    }

    public final synchronized void updateScreenState(@Nullable String id, @NotNull String name, @Nullable String type, @Nullable String transitionType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.populatePreviousFields();
        this.name = name;
        this.type = type;
        this.transitionType = transitionType;
        this.id = id != null ? id : Util.uUIDString();
    }

    public final synchronized void updateScreenState(@NotNull String id, @NotNull String name, @Nullable String type, @Nullable String transitionType, @Nullable String fragmentClassName, @Nullable String fragmentTag, @Nullable String activityClassName, @Nullable String activityTag) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.updateScreenState(id, name, type, transitionType);
        this.fragmentClassName = fragmentClassName;
        this.fragmentTag = fragmentTag;
        this.activityClassName = activityClassName;
        this.activityTag = activityTag;
    }

    private final void populatePreviousFields() {
        this.previousName = this.name;
        this.previousType = this.type;
        this.previousId = this.id;
    }

    @NotNull
    public final SelfDescribingJson getCurrentScreen(boolean debug) {
        TrackerPayload contextPayload = new TrackerPayload();
        contextPayload.add("id", this.id);
        contextPayload.add("name", this.name);
        contextPayload.add("type", this.type);
        if (debug) {
            contextPayload.add("fragment", this.getValidName(this.fragmentClassName, this.fragmentTag));
            contextPayload.add("activity", this.getValidName(this.activityClassName, this.activityTag));
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.mobile/screen/jsonschema/1-0-0", contextPayload);
    }

    private final String getValidName(String s1, String s2) {
        if (s1 != null && ((CharSequence)s1).length() > 0) {
            return s1;
        }
        return s2 != null && ((CharSequence)s2).length() > 0 ? s2 : null;
    }
}

