/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/snowplowanalytics/core/tracker/SchemaRule;", "", "rule", "", "ruleParts", "", "(Ljava/lang/String;Ljava/util/List;)V", "getRule", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "matchWithSchema", "schema", "Companion", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nSchemaRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaRule.kt\ncom/snowplowanalytics/core/tracker/SchemaRule\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n37#2,2:133\n37#2,2:135\n*S KotlinDebug\n*F\n+ 1 SchemaRule.kt\ncom/snowplowanalytics/core/tracker/SchemaRule\n*L\n28#1:133,2\n29#1:135,2\n*E\n"})
public final class SchemaRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rule;
    @NotNull
    private final List<String> ruleParts;
    @NotNull
    private static final String RULE_PATTERN = "^iglu:((?:(?:[a-zA-Z0-9-_]+|\\*)\\.)+(?:[a-zA-Z0-9-_]+|\\*))\\/([a-zA-Z0-9-_\\.]+|\\*)\\/([a-zA-Z0-9-_\\.]+|\\*)\\/([1-9][0-9]*|\\*)-(0|[1-9][0-9]*|\\*)-(0|[1-9][0-9]*|\\*)$";
    @NotNull
    private static final String URI_PATTERN = "^iglu:((?:(?:[a-zA-Z0-9-_]+)\\.)+(?:[a-zA-Z0-9-_]+))\\/([a-zA-Z0-9-_]+)\\/([a-zA-Z0-9-_]+)\\/([1-9][0-9]*)\\-(0|[1-9][0-9]*)\\-(0|[1-9][0-9]*)$";

    private SchemaRule(String rule, List<String> ruleParts) {
        this.rule = rule;
        this.ruleParts = ruleParts;
    }

    @NotNull
    public final String getRule() {
        return this.rule;
    }

    public final boolean matchWithSchema(@NotNull String schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        List uriParts = SchemaRule.Companion.getParts(schema, URI_PATTERN);
        if (uriParts == null || uriParts.size() < this.ruleParts.size()) {
            return false;
        }
        String[] stringArray = new String[]{"."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.ruleParts.get(0), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] ruleVendor = thisCollection$iv.toArray(new String[0]);
        String[] $i$f$toTypedArray22 = new String[]{"."};
        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)((CharSequence)uriParts.get(0)), (String[])$i$f$toTypedArray22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] uriVendor = thisCollection$iv2.toArray(new String[0]);
        if (uriVendor.length != ruleVendor.length) {
            return false;
        }
        int index = 0;
        for (String ruleVendorPart : ruleVendor) {
            if (!Intrinsics.areEqual((Object)"*", (Object)ruleVendorPart) && !Intrinsics.areEqual((Object)uriVendor[index], (Object)ruleVendorPart)) {
                return false;
            }
            ++index;
        }
        index = 1;
        for (String rulePart : this.ruleParts.subList(1, this.ruleParts.size())) {
            if (!Intrinsics.areEqual((Object)"*", (Object)rulePart) && !Intrinsics.areEqual(uriParts.get(index), (Object)rulePart)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean equals(@Nullable Object other) {
        SchemaRule that;
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        SchemaRule schemaRule = that = other instanceof SchemaRule ? (SchemaRule)other : null;
        return Intrinsics.areEqual((Object)this.rule, (Object)(schemaRule != null ? schemaRule.rule : null));
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    @JvmStatic
    @Nullable
    public static final SchemaRule build(@NotNull String rule) {
        return Companion.build(rule);
    }

    public /* synthetic */ SchemaRule(String rule, List ruleParts, DefaultConstructorMarker $constructor_marker) {
        this(rule, ruleParts);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/snowplowanalytics/core/tracker/SchemaRule$Companion;", "", "()V", "RULE_PATTERN", "", "URI_PATTERN", "build", "Lcom/snowplowanalytics/core/tracker/SchemaRule;", "rule", "getParts", "", "uri", "regex", "validateVendor", "", "vendor", "snowplow-android-tracker_release"})
    @SourceDebugExtension(value={"SMAP\nSchemaRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaRule.kt\ncom/snowplowanalytics/core/tracker/SchemaRule$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n1#2:133\n37#3,2:134\n*S KotlinDebug\n*F\n+ 1 SchemaRule.kt\ncom/snowplowanalytics/core/tracker/SchemaRule$Companion\n*L\n104#1:134,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SchemaRule build(@NotNull String rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            if (((CharSequence)rule).length() == 0) {
                return null;
            }
            List<String> parts = this.getParts(rule, SchemaRule.RULE_PATTERN);
            return parts == null || parts.isEmpty() || !this.validateVendor(parts.get(0)) ? null : new SchemaRule(rule, parts, null);
        }

        private final List<String> getParts(String uri, String regex) {
            List result = new ArrayList(6);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(uri);
            if (!matcher.find()) {
                return null;
            }
            int n = matcher.groupCount();
            for (int i = 1; i < n; ++i) {
                String it;
                if (i > 6) {
                    return null;
                }
                String part = matcher.group(i);
                if (part == null) continue;
                boolean bl = false;
                result.add(it);
            }
            return result;
        }

        private final boolean validateVendor(String vendor) {
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)vendor, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] components = thisCollection$iv.toArray(new String[0]);
            if (components.length > 1 && (((CharSequence)components[0]).length() == 0 || ((CharSequence)components[components.length - 1]).length() == 0)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)"*", (Object)components[0]) || Intrinsics.areEqual((Object)"*", (Object)components[1])) {
                return false;
            }
            if (components.length <= 2) {
                return true;
            }
            Object[] $i$f$toTypedArray22 = components;
            int n = 2;
            int n2 = components.length;
            String[] trailingComponents = (String[])ArraysKt.copyOfRange((Object[])$i$f$toTypedArray22, (int)n, (int)n2);
            boolean asterisk = false;
            for (String part : trailingComponents) {
                if (Intrinsics.areEqual((Object)"*", (Object)part)) {
                    asterisk = true;
                    continue;
                }
                if (!asterisk) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

