/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.DefaultLoggerDelegate;
import com.snowplowanalytics.core.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014J5\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J5\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J5\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/snowplowanalytics/core/tracker/Logger;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "delegate", "Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;", "getDelegate", "()Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;", "setDelegate", "(Lcom/snowplowanalytics/snowplow/tracker/LoggerDelegate;)V", "level", "", "d", "", "tag", "msg", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "getMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getTag", "thread", "track", "updateLogLevel", "newLevel", "Lcom/snowplowanalytics/snowplow/tracker/LogLevel;", "v", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static final String TAG = Logger.class.getSimpleName();
    private static int level;
    @Nullable
    private static LoggerDelegate delegate;

    private Logger() {
    }

    @Nullable
    public final LoggerDelegate getDelegate() {
        return delegate;
    }

    public final void setDelegate(@Nullable LoggerDelegate delegate) {
        LoggerDelegate loggerDelegate = delegate;
        if (loggerDelegate == null) {
            loggerDelegate = new DefaultLoggerDelegate();
        }
        Logger.delegate = loggerDelegate;
    }

    @JvmStatic
    public static final void updateLogLevel(@NotNull LogLevel newLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)newLevel), (String)"newLevel");
        level = newLevel.getLevel();
    }

    @JvmStatic
    public static final void track(@NotNull String tag, @NotNull String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Logger.e(tag, msg, Arrays.copyOf(args, args.length));
        try {
            Throwable throwable = null;
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                Object arg = args[i];
                if (!Throwable.class.isInstance(arg)) continue;
                throwable = arg instanceof Throwable ? (Throwable)arg : null;
                break;
            }
            TrackerError event = new TrackerError(tag, INSTANCE.getMessage(msg, Arrays.copyOf(args, args.length)), throwable);
            Map notificationData = new HashMap();
            notificationData.put("event", event);
            NotificationCenter.postNotification("SnowplowTrackerDiagnostic", notificationData);
        }
        catch (Exception e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.v(string, "Error logger can't report the error: " + e, new Object[0]);
        }
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @NotNull String msg, Object ... args) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (level < 1) break block1;
            String source = INSTANCE.getTag(tag);
            String message = INSTANCE.getMessage(msg, Arrays.copyOf(args, args.length));
            LoggerDelegate loggerDelegate = delegate;
            if (loggerDelegate != null) {
                loggerDelegate.error(source, message);
            }
        }
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @NotNull String msg, Object ... args) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (level < 2) break block1;
            String source = INSTANCE.getTag(tag);
            String message = INSTANCE.getMessage(msg, Arrays.copyOf(args, args.length));
            LoggerDelegate loggerDelegate = delegate;
            if (loggerDelegate != null) {
                loggerDelegate.debug(source, message);
            }
        }
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @NotNull String msg, Object ... args) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (level < 3) break block1;
            String source = INSTANCE.getTag(tag);
            String message = INSTANCE.getMessage(msg, Arrays.copyOf(args, args.length));
            LoggerDelegate loggerDelegate = delegate;
            if (loggerDelegate != null) {
                loggerDelegate.verbose(source, message);
            }
        }
    }

    private final String getMessage(String msg, Object ... args) {
        StringBuilder stringBuilder = new StringBuilder().append(this.thread()).append('|');
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(msg, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        return stringBuilder.append(string).toString();
    }

    private final String getTag(String tag) {
        return "SnowplowTracker->" + tag;
    }

    private final String thread() {
        String string = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentThread().name");
        return string;
    }

    static {
        delegate = new DefaultLoggerDelegate();
    }
}

