/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.tracker;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.event.ScreenView;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/snowplowanalytics/core/tracker/ActivityLifecycleHandler;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "Companion", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ActivityLifecycleHandler
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = ActivityLifecycleHandler.class.getSimpleName();
    @Nullable
    private static ActivityLifecycleHandler sharedInstance;

    private ActivityLifecycleHandler(Context context) {
        block0: {
            Application application;
            Context context2 = context.getApplicationContext();
            Application application2 = application = context2 instanceof Application ? (Application)context2 : null;
            if (application2 == null) break block0;
            application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "Auto screenview occurred - activity has resumed", new Object[0]);
        try {
            ScreenView event = ScreenView.Companion.buildWithActivity(activity);
            Map notificationData = new HashMap();
            notificationData.put("event", event);
            NotificationCenter.postNotification("SnowplowScreenView", notificationData);
        }
        catch (Exception e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{e};
            Logger.e(string2, "Method onActivityResumed raised an exception: %s", objectArray);
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @JvmStatic
    @NotNull
    public static final synchronized ActivityLifecycleHandler getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public /* synthetic */ ActivityLifecycleHandler(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/snowplowanalytics/core/tracker/ActivityLifecycleHandler$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "sharedInstance", "Lcom/snowplowanalytics/core/tracker/ActivityLifecycleHandler;", "getInstance", "context", "Landroid/content/Context;", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final synchronized ActivityLifecycleHandler getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sharedInstance == null) {
                sharedInstance = new ActivityLifecycleHandler(context, null);
            }
            ActivityLifecycleHandler activityLifecycleHandler = sharedInstance;
            Intrinsics.checkNotNull((Object)activityLifecycleHandler);
            return activityLifecycleHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

