/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.session;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.StrictMode;
import androidx.core.util.Consumer;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.entity.ClientSessionEntity;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 L2\u00020\u0001:\u0001LB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020)H\u0002J\u0012\u0010;\u001a\u00020:2\b\u0010<\u001a\u0004\u0018\u00010\u0018H\u0002J \u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\"J*\u0010B\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010C2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010D\u001a\u00020\bH\u0002J\u000e\u0010E\u001a\u00020:2\u0006\u0010!\u001a\u00020\"J\u000e\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020\"J\b\u0010H\u001a\u00020\"H\u0002J\u0006\u0010I\u001a\u00020:J\u0010\u0010J\u001a\u00020:2\u0006\u00103\u001a\u00020)H\u0002J\u0018\u0010K\u001a\u00020:2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u0003H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u000e\u0010$\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00103\u001a\u0004\u0018\u00010)2\b\u0010\u000e\u001a\u0004\u0018\u00010)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001e\u00106\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006M"}, d2={"Lcom/snowplowanalytics/core/session/Session;", "", "foregroundTimeout", "", "backgroundTimeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "namespace", "", "context", "Landroid/content/Context;", "(JJLjava/util/concurrent/TimeUnit;Ljava/lang/String;Landroid/content/Context;)V", "_isBackground", "Ljava/util/concurrent/atomic/AtomicBoolean;", "<set-?>", "", "backgroundIndex", "getBackgroundIndex", "()I", "getBackgroundTimeout", "()J", "setBackgroundTimeout", "(J)V", "backgroundTimeoutCallback", "Ljava/lang/Runnable;", "backgroundTransitionCallback", "eventIndex", "foregroundIndex", "getForegroundIndex", "getForegroundTimeout", "setForegroundTimeout", "foregroundTimeoutCallback", "foregroundTransitionCallback", "isBackground", "", "()Z", "isNewSession", "isSessionCheckerEnabled", "lastSessionCheck", "onSessionUpdate", "Landroidx/core/util/Consumer;", "Lcom/snowplowanalytics/snowplow/tracker/SessionState;", "getOnSessionUpdate", "()Landroidx/core/util/Consumer;", "setOnSessionUpdate", "(Landroidx/core/util/Consumer;)V", "sessionIndex", "getSessionIndex", "()Ljava/lang/Integer;", "sharedPreferences", "Landroid/content/SharedPreferences;", "state", "getState", "()Lcom/snowplowanalytics/snowplow/tracker/SessionState;", "userId", "getUserId", "()Ljava/lang/String;", "callOnSessionUpdateCallback", "", "executeEventCallback", "callback", "getSessionContext", "Lcom/snowplowanalytics/snowplow/payload/SelfDescribingJson;", "eventId", "eventTimestamp", "userAnonymisation", "getSessionMap", "", "sessionVarsName", "setBackground", "setIsSuspended", "isSuspended", "shouldUpdateSession", "startNewSession", "storeSessionState", "updateSession", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\ncom/snowplowanalytics/core/session/Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class Session {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String userId;
    private int eventIndex;
    private volatile int backgroundIndex;
    private volatile int foregroundIndex;
    @Nullable
    private SessionState state;
    @NotNull
    private final AtomicBoolean _isBackground;
    private long lastSessionCheck;
    @NotNull
    private final AtomicBoolean isNewSession;
    private volatile boolean isSessionCheckerEnabled;
    private long foregroundTimeout;
    private long backgroundTimeout;
    @Nullable
    private Runnable foregroundTransitionCallback;
    @Nullable
    private Runnable backgroundTransitionCallback;
    @Nullable
    private Runnable foregroundTimeoutCallback;
    @Nullable
    private Runnable backgroundTimeoutCallback;
    @Nullable
    private Consumer<SessionState> onSessionUpdate;
    @NotNull
    private SharedPreferences sharedPreferences;
    private static final String TAG = Session.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ApplySharedPref"})
    public Session(long foregroundTimeout, long backgroundTimeout, @NotNull TimeUnit timeUnit, @Nullable String namespace, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._isBackground = new AtomicBoolean(false);
        this.isNewSession = new AtomicBoolean(true);
        this.foregroundTimeout = timeUnit.toMillis(foregroundTimeout);
        this.backgroundTimeout = timeUnit.toMillis(backgroundTimeout);
        this.isSessionCheckerEnabled = true;
        String sessionVarsName = "snowplow_session_vars";
        if (namespace != null && ((CharSequence)namespace).length() > 0) {
            CharSequence charSequence = namespace;
            Regex regex = new Regex("[^a-zA-Z0-9_]+");
            String string = "-";
            String sessionVarsSuffix = regex.replace(charSequence, string);
            sessionVarsName = "snowplow_session_vars_" + sessionVarsSuffix;
        }
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map<String, Object> sessionInfo = this.getSessionMap(context, sessionVarsName);
            if (sessionInfo == null) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.track(string, "No previous session info available", new Object[0]);
            } else {
                this.state = SessionState.Companion.build(sessionInfo);
            }
            this.userId = Session.Companion.retrieveUserId(context, this.state);
            SharedPreferences sharedPreferences = context.getSharedPreferences(sessionVarsName, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026me, Context.MODE_PRIVATE)");
            this.sharedPreferences = sharedPreferences;
            this.lastSessionCheck = System.currentTimeMillis();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Tracker Session Object created.", new Object[0]);
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final int getBackgroundIndex() {
        return this.backgroundIndex;
    }

    public final int getForegroundIndex() {
        return this.foregroundIndex;
    }

    @Nullable
    public final SessionState getState() {
        return this.state;
    }

    public final boolean isBackground() {
        return this._isBackground.get();
    }

    public final long getForegroundTimeout() {
        return this.foregroundTimeout;
    }

    public final void setForegroundTimeout(long l) {
        this.foregroundTimeout = l;
    }

    public final long getBackgroundTimeout() {
        return this.backgroundTimeout;
    }

    public final void setBackgroundTimeout(long l) {
        this.backgroundTimeout = l;
    }

    @Nullable
    public final Consumer<SessionState> getOnSessionUpdate() {
        return this.onSessionUpdate;
    }

    public final void setOnSessionUpdate(@Nullable Consumer<SessionState> consumer) {
        this.onSessionUpdate = consumer;
    }

    @Nullable
    public final synchronized SelfDescribingJson getSessionContext(@NotNull String eventId, long eventTimestamp, boolean userAnonymisation) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Getting session context...", new Object[0]);
        if (this.isSessionCheckerEnabled) {
            if (this.shouldUpdateSession()) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Logger.d(string2, "Update session information.", new Object[0]);
                this.updateSession(eventId, eventTimestamp);
                if (this.isBackground()) {
                    this.executeEventCallback(this.backgroundTimeoutCallback);
                } else {
                    this.executeEventCallback(this.foregroundTimeoutCallback);
                }
            }
            this.lastSessionCheck = System.currentTimeMillis();
        }
        ++this.eventIndex;
        SessionState sessionState = this.state;
        if (sessionState == null) {
            Session $this$getSessionContext_u24lambda_u240 = this;
            boolean bl = false;
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            Logger.v(string3, "Session state not present", new Object[0]);
            return null;
        }
        SessionState state = sessionState;
        Map<String, Object> sessionValues = state.getSessionValues();
        Map sessionCopy = new HashMap<String, Object>(sessionValues);
        sessionCopy.put("eventIndex", this.eventIndex);
        if (userAnonymisation) {
            sessionCopy.put("userId", "00000000-0000-0000-0000-000000000000");
            sessionCopy.put("previousSessionId", null);
        }
        return new ClientSessionEntity(sessionCopy);
    }

    private final boolean shouldUpdateSession() {
        if (this.isNewSession.get()) {
            return true;
        }
        long now = System.currentTimeMillis();
        long timeout = this.isBackground() ? this.backgroundTimeout : this.foregroundTimeout;
        return now < this.lastSessionCheck || now - this.lastSessionCheck > timeout;
    }

    private final synchronized void updateSession(String eventId, long eventTimestamp) {
        block1: {
            SessionState it;
            this.isNewSession.set(false);
            String currentSessionId = Util.uUIDString();
            String eventTimestampDateTime = Util.getDateTimeFromTimestamp(eventTimestamp);
            int sessionIndex = 0;
            sessionIndex = 1;
            this.eventIndex = 0;
            String previousSessionId = null;
            String storage = null;
            storage = "LOCAL_STORAGE";
            SessionState sessionState = this.state;
            if (sessionState != null) {
                it = sessionState;
                boolean bl = false;
                sessionIndex = it.getSessionIndex() + 1;
                previousSessionId = it.getSessionId();
                storage = it.getStorage();
            }
            SessionState sessionState2 = this.state = new SessionState(eventId, eventTimestampDateTime, currentSessionId, previousSessionId, sessionIndex, this.userId, storage);
            if (sessionState2 == null) break block1;
            it = sessionState2;
            boolean bl = false;
            this.storeSessionState(it);
            this.callOnSessionUpdateCallback(it);
        }
    }

    private final void storeSessionState(SessionState state) {
        JSONObject jsonObject = new JSONObject(state.getSessionValues());
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        String jsonString = string;
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString("session_state", jsonString);
        editor.apply();
    }

    private final void callOnSessionUpdateCallback(SessionState state) {
        Consumer<SessionState> consumer = this.onSessionUpdate;
        if (consumer == null) {
            return;
        }
        Consumer<SessionState> onSessionUpdate = consumer;
        Thread thread = new Thread(() -> Session.callOnSessionUpdateCallback$lambda$3(onSessionUpdate, state));
        thread.setDaemon(true);
        thread.start();
    }

    private final void executeEventCallback(Runnable callback) {
        if (callback == null) {
            return;
        }
        try {
            callback.run();
        }
        catch (Exception e) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.e(string, "Session event callback failed", new Object[0]);
        }
    }

    public final void startNewSession() {
        this.isNewSession.set(true);
    }

    public final void setBackground(boolean isBackground) {
        if (!this._isBackground.compareAndSet(!isBackground, isBackground)) {
            return;
        }
        if (!isBackground) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Application moved to foreground", new Object[0]);
            this.executeEventCallback(this.foregroundTransitionCallback);
            try {
                this.setIsSuspended(false);
            }
            catch (Exception e) {
                String string2 = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Object[] objectArray = new Object[]{e};
                Logger.e(string2, "Could not resume checking as tracker not setup. Exception: %s", objectArray);
            }
            int n = this.foregroundIndex;
            this.foregroundIndex = n + 1;
        } else {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Application moved to background", new Object[0]);
            this.executeEventCallback(this.backgroundTransitionCallback);
            int n = this.backgroundIndex;
            this.backgroundIndex = n + 1;
        }
    }

    public final void setIsSuspended(boolean isSuspended) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{isSuspended};
        Logger.d(string, "Session is suspended: %s", objectArray);
        this.isSessionCheckerEnabled = !isSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> getSessionMap(Context context, String sessionVarsName) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            JSONObject jsonObject;
            JSONObject jSONObject;
            String jsonString;
            SharedPreferences sharedPreferences = context.getSharedPreferences(sessionVarsName, 0);
            if (!sharedPreferences.contains("session_state")) {
                Map<String, Object> map = null;
                return map;
            }
            Map sessionMap = new HashMap();
            String string = jsonString = sharedPreferences.getString("session_state", null);
            if (string != null) {
                String it = string;
                boolean bl = false;
                jSONObject = new JSONObject(it);
            } else {
                jSONObject = null;
            }
            JSONObject jSONObject2 = jsonObject = jSONObject;
            Iterator iterator = jSONObject2 != null ? jSONObject2.keys() : null;
            while (true) {
                Iterator iterator2 = iterator;
                boolean bl = iterator2 != null ? iterator2.hasNext() : false;
                if (!bl) break;
                String key = (String)iterator.next();
                Object value = jsonObject.get(key);
                sessionMap.put(key, value);
            }
            Map map = sessionMap;
            return map;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        return null;
    }

    @Nullable
    public final Integer getSessionIndex() {
        SessionState sessionState = this.state;
        return sessionState != null ? Integer.valueOf(sessionState.getSessionIndex()) : null;
    }

    private static final void callOnSessionUpdateCallback$lambda$3(Consumer $onSessionUpdate, SessionState $state) {
        Intrinsics.checkNotNullParameter((Object)$onSessionUpdate, (String)"$onSessionUpdate");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        $onSessionUpdate.accept((Object)$state);
    }

    @JvmStatic
    @NotNull
    public static final synchronized Session getInstance(@NotNull Context context, long foregroundTimeout, long backgroundTimeout, @NotNull TimeUnit timeUnit, @Nullable String namespace, @Nullable Runnable[] sessionCallbacks) {
        return Companion.getInstance(context, foregroundTimeout, backgroundTimeout, timeUnit, namespace, sessionCallbacks);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/snowplowanalytics/core/session/Session$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getInstance", "Lcom/snowplowanalytics/core/session/Session;", "context", "Landroid/content/Context;", "foregroundTimeout", "", "backgroundTimeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "namespace", "sessionCallbacks", "", "Ljava/lang/Runnable;", "(Landroid/content/Context;JJLjava/util/concurrent/TimeUnit;Ljava/lang/String;[Ljava/lang/Runnable;)Lcom/snowplowanalytics/core/session/Session;", "retrieveUserId", "state", "Lcom/snowplowanalytics/snowplow/tracker/SessionState;", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final synchronized Session getInstance(@NotNull Context context, long foregroundTimeout, long backgroundTimeout, @NotNull TimeUnit timeUnit, @Nullable String namespace, @Nullable Runnable[] sessionCallbacks) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            Session session = new Session(foregroundTimeout, backgroundTimeout, timeUnit, namespace, context);
            Runnable[] runnableArray = new Runnable[]{null, null, null, null};
            Runnable[] callbacks = runnableArray;
            if (sessionCallbacks != null && sessionCallbacks.length == 4) {
                callbacks = sessionCallbacks;
            }
            session.foregroundTransitionCallback = callbacks[0];
            session.backgroundTransitionCallback = callbacks[1];
            session.foregroundTimeoutCallback = callbacks[2];
            session.backgroundTimeoutCallback = callbacks[3];
            return session;
        }

        private final synchronized String retrieveUserId(Context context, SessionState state) {
            SharedPreferences generalPref;
            String storedUserId;
            Object userId;
            Object object = state;
            if (object == null || (object = ((SessionState)object).getUserId()) == null) {
                object = userId = Util.uUIDString();
            }
            if ((storedUserId = (generalPref = context.getSharedPreferences("snowplow_general_vars", 0)).getString("SPInstallationUserId", null)) != null) {
                userId = storedUserId;
            } else {
                generalPref.edit().putString("SPInstallationUserId", (String)userId).commit();
            }
            return userId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

