/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.session;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J*\u0010\u000b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/snowplowanalytics/core/session/FileStore;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "deleteFile", "", "filename", "context", "Landroid/content/Context;", "getMapFromFile", "", "saveMapToFile", "objects", "", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class FileStore {
    @NotNull
    public static final FileStore INSTANCE = new FileStore();
    private static final String TAG = FileStore.class.getSimpleName();

    private FileStore() {
    }

    @JvmStatic
    public static final boolean saveMapToFile(@NotNull String filename, @NotNull Map<?, ?> objects, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileOutputStream fos = null;
        try {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{objects};
            Logger.d(string, "Attempting to save: %s", objectArray);
            FileOutputStream fileOutputStream = context.openFileOutput(filename, 0);
            Intrinsics.checkNotNullExpressionValue((Object)fileOutputStream, (String)"context.openFileOutput(f\u2026me, Context.MODE_PRIVATE)");
            fos = fileOutputStream;
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(objects);
            oos.close();
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray2 = new Object[]{filename};
            Logger.d(string2, " + Successfully saved KV Pairs to: %s", objectArray2);
            return true;
        }
        catch (NullPointerException ioe) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{ioe.getMessage()};
            Logger.e(string, " + Exception saving vars map: %s", objectArray);
        }
        catch (IOException ioe) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{ioe.getMessage()};
            Logger.e(string, " + Exception saving vars map: %s", objectArray);
        }
        return false;
    }

    @JvmStatic
    @Nullable
    public static final synchronized Map<String, Object> getMapFromFile(@NotNull String filename, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            File file = context.getFileStreamPath(filename);
            if (file == null || !file.exists()) {
                return null;
            }
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{filename};
            Logger.d(string, "Attempting to retrieve map from: %s", objectArray);
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object[] objectArray2 = ois.readObject();
            Map varsMap = objectArray2 instanceof HashMap ? (HashMap)objectArray2 : null;
            ois.close();
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            objectArray2 = new Object[]{varsMap};
            Logger.d(string2, " + Retrieved map from file: %s", objectArray2);
            return varsMap;
        }
        catch (IOException ioe) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{ioe.getMessage()};
            Logger.e(string, " + Exception getting vars map: %s", objectArray);
        }
        catch (ClassNotFoundException ioe) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{ioe.getMessage()};
            Logger.e(string, " + Exception getting vars map: %s", objectArray);
        }
        return null;
    }

    @JvmStatic
    public static final boolean deleteFile(@NotNull String filename, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isSuccess = context.deleteFile(filename);
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{filename, isSuccess};
        Logger.d(string, "Deleted %s from internal storage: %s", objectArray);
        return isSuccess;
    }
}

