/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.remoteconfiguration;

import android.content.Context;
import androidx.core.util.Consumer;
import androidx.core.util.Pair;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationBundle;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationCache;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationFetcher;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationProvider;
import com.snowplowanalytics.snowplow.configuration.ConfigurationBundle;
import com.snowplowanalytics.snowplow.configuration.ConfigurationState;
import com.snowplowanalytics.snowplow.configuration.RemoteConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u00190\u0018J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationProvider;", "", "remoteConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;", "defaultBundles", "", "Lcom/snowplowanalytics/snowplow/configuration/ConfigurationBundle;", "defaultBundleVersion", "", "(Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;Ljava/util/List;I)V", "cache", "Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationCache;", "cacheBundle", "Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationBundle;", "defaultBundle", "fetcher", "Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationFetcher;", "retrieveConfiguration", "", "context", "Landroid/content/Context;", "onlyRemote", "", "onFetchCallback", "Landroidx/core/util/Consumer;", "Landroidx/core/util/Pair;", "Lcom/snowplowanalytics/snowplow/configuration/ConfigurationState;", "schemaCompatibility", "schema", "", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigurationProvider.kt\ncom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class RemoteConfigurationProvider {
    @NotNull
    private final RemoteConfiguration remoteConfiguration;
    @NotNull
    private final RemoteConfigurationCache cache;
    @Nullable
    private RemoteConfigurationFetcher fetcher;
    @Nullable
    private RemoteConfigurationBundle defaultBundle;
    @Nullable
    private RemoteConfigurationBundle cacheBundle;

    @JvmOverloads
    public RemoteConfigurationProvider(@NotNull RemoteConfiguration remoteConfiguration, @Nullable List<ConfigurationBundle> defaultBundles, int defaultBundleVersion) {
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        this.remoteConfiguration = remoteConfiguration;
        this.cache = new RemoteConfigurationCache(this.remoteConfiguration);
        if (defaultBundles != null) {
            RemoteConfigurationBundle bundle = new RemoteConfigurationBundle("1.0");
            bundle.setConfigurationVersion(defaultBundleVersion);
            bundle.setConfigurationBundle(defaultBundles);
            this.defaultBundle = bundle;
        }
    }

    public /* synthetic */ RemoteConfigurationProvider(RemoteConfiguration remoteConfiguration, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = null;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        this(remoteConfiguration, list, n);
    }

    public final synchronized void retrieveConfiguration(@NotNull Context context, boolean onlyRemote, @NotNull Consumer<Pair<RemoteConfigurationBundle, ConfigurationState>> onFetchCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onFetchCallback, (String)"onFetchCallback");
        if (!onlyRemote) {
            if (this.cacheBundle == null) {
                this.cacheBundle = this.cache.readCache(context);
            }
            if (this.cacheBundle != null) {
                RemoteConfigurationBundle remoteConfigurationBundle = this.defaultBundle;
                if (remoteConfigurationBundle != null) {
                    RemoteConfigurationBundle it = remoteConfigurationBundle;
                    boolean bl = false;
                    RemoteConfigurationBundle remoteConfigurationBundle2 = this.cacheBundle;
                    if (remoteConfigurationBundle2 != null) {
                        remoteConfigurationBundle2.updateSourceConfig(it);
                    }
                }
                onFetchCallback.accept((Object)new Pair((Object)this.cacheBundle, (Object)ConfigurationState.CACHED));
            } else if (this.defaultBundle != null) {
                onFetchCallback.accept((Object)new Pair((Object)this.defaultBundle, (Object)ConfigurationState.DEFAULT));
            }
        }
        this.fetcher = new RemoteConfigurationFetcher(context, this.remoteConfiguration, (Consumer<RemoteConfigurationBundle>)((Consumer)new Consumer<RemoteConfigurationBundle>(this, context, onFetchCallback){
            final /* synthetic */ RemoteConfigurationProvider this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Consumer<Pair<RemoteConfigurationBundle, ConfigurationState>> $onFetchCallback;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$onFetchCallback = $onFetchCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(@NotNull RemoteConfigurationBundle bundle) {
                Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
                if (!RemoteConfigurationProvider.access$schemaCompatibility(this.this$0, bundle.getSchema())) {
                    return;
                }
                RemoteConfigurationProvider remoteConfigurationProvider = this.this$0;
                Context context = this.$context;
                Consumer<Pair<RemoteConfigurationBundle, ConfigurationState>> consumer = this.$onFetchCallback;
                retrieveConfiguration.2 var5_5 = this;
                synchronized (var5_5) {
                    boolean isNewer;
                    boolean bl;
                    boolean bl2 = false;
                    RemoteConfigurationBundle remoteConfigurationBundle = RemoteConfigurationProvider.access$getCacheBundle$p(remoteConfigurationProvider);
                    if (remoteConfigurationBundle == null) {
                        remoteConfigurationBundle = RemoteConfigurationProvider.access$getDefaultBundle$p(remoteConfigurationProvider);
                    }
                    if (remoteConfigurationBundle != null) {
                        RemoteConfigurationBundle it = remoteConfigurationBundle;
                        boolean bl3 = false;
                        bl = it.getConfigurationVersion() < bundle.getConfigurationVersion();
                    } else {
                        bl = isNewer = true;
                    }
                    if (isNewer) {
                        RemoteConfigurationBundle remoteConfigurationBundle2 = RemoteConfigurationProvider.access$getDefaultBundle$p(remoteConfigurationProvider);
                        if (remoteConfigurationBundle2 != null) {
                            RemoteConfigurationBundle it = remoteConfigurationBundle2;
                            boolean bl4 = false;
                            bundle.updateSourceConfig(it);
                        }
                        RemoteConfigurationProvider.access$getCache$p(remoteConfigurationProvider).writeCache(context, bundle);
                        RemoteConfigurationProvider.access$setCacheBundle$p(remoteConfigurationProvider, bundle);
                        consumer.accept((Object)new Pair((Object)bundle, (Object)((Object)ConfigurationState.FETCHED)));
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
    }

    private final boolean schemaCompatibility(String schema) {
        return StringsKt.startsWith$default((String)schema, (String)"http://iglucentral.com/schemas/com.snowplowanalytics.mobile/remote_config/jsonschema/1-", (boolean)false, (int)2, null);
    }

    @JvmOverloads
    public RemoteConfigurationProvider(@NotNull RemoteConfiguration remoteConfiguration, @Nullable List<ConfigurationBundle> defaultBundles) {
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        this(remoteConfiguration, defaultBundles, 0, 4, null);
    }

    @JvmOverloads
    public RemoteConfigurationProvider(@NotNull RemoteConfiguration remoteConfiguration) {
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        this(remoteConfiguration, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$schemaCompatibility(RemoteConfigurationProvider $this, String schema) {
        return $this.schemaCompatibility(schema);
    }

    public static final /* synthetic */ RemoteConfigurationBundle access$getCacheBundle$p(RemoteConfigurationProvider $this) {
        return $this.cacheBundle;
    }

    public static final /* synthetic */ RemoteConfigurationBundle access$getDefaultBundle$p(RemoteConfigurationProvider $this) {
        return $this.defaultBundle;
    }

    public static final /* synthetic */ RemoteConfigurationCache access$getCache$p(RemoteConfigurationProvider $this) {
        return $this.cache;
    }

    public static final /* synthetic */ void access$setCacheBundle$p(RemoteConfigurationProvider $this, RemoteConfigurationBundle remoteConfigurationBundle) {
        $this.cacheBundle = remoteConfigurationBundle;
    }
}

