/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.remoteconfiguration;

import android.content.Context;
import android.net.TrafficStats;
import android.net.Uri;
import androidx.core.util.Consumer;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationBundle;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.snowplow.configuration.RemoteConfiguration;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationFetcher;", "", "context", "Landroid/content/Context;", "remoteConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;", "onFetchCallback", "Landroidx/core/util/Consumer;", "Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationBundle;", "(Landroid/content/Context;Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;Landroidx/core/util/Consumer;)V", "TAG", "", "kotlin.jvm.PlatformType", "exceptionHandler", "", "t", "", "getRunnable", "Ljava/lang/Runnable;", "performRequest", "Lokhttp3/ResponseBody;", "endpoint", "resolveRequest", "responseBody", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigurationFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigurationFetcher.kt\ncom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class RemoteConfigurationFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteConfiguration remoteConfiguration;
    @NotNull
    private final Consumer<RemoteConfigurationBundle> onFetchCallback;
    private final String TAG;
    private static final int TRAFFIC_STATS_TAG = 1;

    public RemoteConfigurationFetcher(@NotNull Context context, @NotNull RemoteConfiguration remoteConfiguration, @NotNull Consumer<RemoteConfigurationBundle> onFetchCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        Intrinsics.checkNotNullParameter(onFetchCallback, (String)"onFetchCallback");
        this.remoteConfiguration = remoteConfiguration;
        this.onFetchCallback = onFetchCallback;
        this.TAG = RemoteConfigurationFetcher.class.getSimpleName();
        Executor.execute(this.getRunnable(context), arg_0 -> RemoteConfigurationFetcher._init_$lambda$0(this, arg_0));
    }

    private final Runnable getRunnable(Context context) {
        return () -> RemoteConfigurationFetcher.getRunnable$lambda$2(this, context);
    }

    private final ResponseBody performRequest(String endpoint) throws IOException {
        Uri.Builder uriBuilder = Uri.parse((String)endpoint).buildUpon();
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
        String uri = string;
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(uri).get().build();
        TrafficStats.setThreadStatsTag((int)1);
        Response resp = client.newCall(request).execute();
        ResponseBody body = resp.body();
        return resp.isSuccessful() && body != null ? body : null;
    }

    private final void resolveRequest(Context context, ResponseBody responseBody, Consumer<RemoteConfigurationBundle> onFetchCallback) throws IOException, JSONException {
        String data = responseBody.string();
        JSONObject jsonObject = new JSONObject(data);
        RemoteConfigurationBundle bundle = new RemoteConfigurationBundle(context, jsonObject);
        onFetchCallback.accept((Object)bundle);
    }

    private final void exceptionHandler(Throwable t) {
        String message;
        Throwable throwable = t;
        String string = message = throwable != null ? throwable.getMessage() : null;
        if (message == null) {
            message = "no message provided";
        }
        String string2 = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        Object[] objectArray = new Object[]{t};
        Logger.e(string2, message, objectArray);
    }

    private static final void _init_$lambda$0(RemoteConfigurationFetcher this$0, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.exceptionHandler(t);
    }

    private static final void getRunnable$lambda$2(RemoteConfigurationFetcher this$0, Context $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            ResponseBody body;
            ResponseBody responseBody = body = this$0.performRequest(this$0.remoteConfiguration.getEndpoint());
            if (responseBody != null) {
                ResponseBody it = responseBody;
                boolean bl = false;
                this$0.resolveRequest($context, it, this$0.onFetchCallback);
            }
        }
        catch (Exception e) {
            String string = this$0.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Object[] objectArray = new Object[]{e};
            Logger.e(string, "Unable to get remote configuration: " + e.getMessage(), objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationFetcher$Companion;", "", "()V", "TRAFFIC_STATS_TAG", "", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

