/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.remoteconfiguration;

import android.content.Context;
import com.snowplowanalytics.core.remoteconfiguration.RemoteConfigurationBundle;
import com.snowplowanalytics.snowplow.configuration.RemoteConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationCache;", "", "remoteConfiguration", "Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;", "(Lcom/snowplowanalytics/snowplow/configuration/RemoteConfiguration;)V", "cacheFilePath", "", "configuration", "Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationBundle;", "clearCache", "", "context", "Landroid/content/Context;", "getCachePath", "loadCache", "readCache", "storeCache", "writeCache", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigurationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigurationCache.kt\ncom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class RemoteConfigurationCache {
    @NotNull
    private final RemoteConfiguration remoteConfiguration;
    @Nullable
    private String cacheFilePath;
    @Nullable
    private RemoteConfigurationBundle configuration;

    public RemoteConfigurationCache(@NotNull RemoteConfiguration remoteConfiguration) {
        Intrinsics.checkNotNullParameter((Object)remoteConfiguration, (String)"remoteConfiguration");
        this.remoteConfiguration = remoteConfiguration;
    }

    @Nullable
    public final synchronized RemoteConfigurationBundle readCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.configuration != null) {
            return this.configuration;
        }
        this.loadCache(context);
        return this.configuration;
    }

    public final synchronized void writeCache(@NotNull Context context, @NotNull RemoteConfigurationBundle configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.storeCache(context, configuration);
    }

    public final synchronized void clearCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = this.getCachePath(context);
        File file = new File(path);
        file.delete();
    }

    private final String getCachePath(Context context) {
        String string = this.cacheFilePath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        String cacheDirPath = context.getCacheDir().getAbsolutePath() + File.separator + "snowplow-cache";
        File cacheDir = new File(cacheDirPath);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        String fileName = "remoteConfig-" + this.remoteConfiguration.getEndpoint().hashCode() + ".data";
        String string2 = this.cacheFilePath = cacheDir.getAbsolutePath() + File.separator + fileName;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void loadCache(Context context) {
        String path = this.getCachePath(context);
        ObjectInputStream objectIn = null;
        try {
            FileInputStream fileIn = new FileInputStream(path);
            objectIn = new ObjectInputStream(fileIn);
            Object object = objectIn.readObject();
            this.configuration = object instanceof RemoteConfigurationBundle ? (RemoteConfigurationBundle)object : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (objectIn == null) return;
            try {
                objectIn.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (IOException iOException) {
                if (objectIn == null) return;
                try {
                    objectIn.close();
                    return;
                }
                catch (IOException iOException2) {
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (objectIn == null) return;
                    try {
                        objectIn.close();
                        return;
                    }
                    catch (IOException iOException3) {
                        return;
                    }
                    catch (Throwable throwable) {
                        if (objectIn == null) throw throwable;
                        try {
                            objectIn.close();
                            throw throwable;
                        }
                        catch (IOException iOException4) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        try {
            objectIn.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void storeCache(Context context, RemoteConfigurationBundle configuration) {
        block12: {
            String path = this.getCachePath(context);
            ObjectOutputStream objectOut = null;
            FileOutputStream fileOut = new FileOutputStream(path, false);
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(configuration);
            fileOut.getFD().sync();
            try {
                objectOut.close();
            }
            catch (IOException iOException) {}
            break block12;
            catch (IOException iOException) {
                if (objectOut != null) {
                    try {
                        objectOut.close();
                    }
                    catch (IOException iOException2) {}
                }
                catch (Throwable throwable) {
                    if (objectOut != null) {
                        try {
                            objectOut.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

