/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.remoteconfiguration;

import android.content.Context;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.ConfigurationBundle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u0001H\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u0004\u00a8\u0006\u001e"}, d2={"Lcom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationBundle;", "Lcom/snowplowanalytics/snowplow/configuration/Configuration;", "schema", "", "(Ljava/lang/String;)V", "context", "Landroid/content/Context;", "jsonObject", "Lorg/json/JSONObject;", "(Landroid/content/Context;Lorg/json/JSONObject;)V", "configurationBundle", "", "Lcom/snowplowanalytics/snowplow/configuration/ConfigurationBundle;", "getConfigurationBundle", "()Ljava/util/List;", "setConfigurationBundle", "(Ljava/util/List;)V", "configurationVersion", "", "getConfigurationVersion", "()I", "setConfigurationVersion", "(I)V", "getSchema", "()Ljava/lang/String;", "setSchema", "copy", "updateSourceConfig", "", "sourceRemoteBundle", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigurationBundle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigurationBundle.kt\ncom/snowplowanalytics/core/remoteconfiguration/RemoteConfigurationBundle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class RemoteConfigurationBundle
implements Configuration {
    @NotNull
    private String schema;
    private int configurationVersion;
    @NotNull
    private List<ConfigurationBundle> configurationBundle;

    @NotNull
    public final String getSchema() {
        return this.schema;
    }

    public final void setSchema(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.schema = string;
    }

    public final int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public final void setConfigurationVersion(int n) {
        this.configurationVersion = n;
    }

    @NotNull
    public final List<ConfigurationBundle> getConfigurationBundle() {
        return this.configurationBundle;
    }

    public final void setConfigurationBundle(@NotNull List<ConfigurationBundle> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.configurationBundle = list;
    }

    public RemoteConfigurationBundle(@NotNull String schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
        this.configurationVersion = -1;
        this.configurationBundle = CollectionsKt.emptyList();
    }

    public RemoteConfigurationBundle(@NotNull Context context, @NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        String string = jsonObject.getString("$schema");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(\"\\$schema\")");
        this.schema = string;
        this.configurationVersion = jsonObject.getInt("configurationVersion");
        ArrayList<ConfigurationBundle> tempBundle = new ArrayList<ConfigurationBundle>();
        JSONArray array = jsonObject.getJSONArray("configurationBundle");
        int n = array.length();
        for (int i = 0; i < n; ++i) {
            JSONObject bundleJson = array.getJSONObject(i);
            Intrinsics.checkNotNullExpressionValue((Object)bundleJson, (String)"bundleJson");
            ConfigurationBundle bundle = new ConfigurationBundle(context, bundleJson);
            tempBundle.add(bundle);
        }
        this.configurationBundle = CollectionsKt.toList((Iterable)tempBundle);
    }

    public final void updateSourceConfig(@NotNull RemoteConfigurationBundle sourceRemoteBundle) {
        Intrinsics.checkNotNullParameter((Object)sourceRemoteBundle, (String)"sourceRemoteBundle");
        for (ConfigurationBundle bundle : this.configurationBundle) {
            ConfigurationBundle it;
            Object v0;
            block2: {
                Iterable iterable = sourceRemoteBundle.configurationBundle;
                for (Object t : iterable) {
                    ConfigurationBundle it2 = (ConfigurationBundle)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getNamespace(), (Object)bundle.getNamespace())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((ConfigurationBundle)v0 == null) continue;
            boolean bl = false;
            bundle.updateSourceConfig(it);
        }
    }

    @Override
    @NotNull
    public Configuration copy() {
        RemoteConfigurationBundle copy = new RemoteConfigurationBundle(this.schema);
        copy.configurationVersion = this.configurationVersion;
        ArrayList<ConfigurationBundle> tempBundle = new ArrayList<ConfigurationBundle>();
        for (ConfigurationBundle bundle : this.configurationBundle) {
            ConfigurationBundle it;
            Configuration configuration = bundle.copy();
            if ((configuration instanceof ConfigurationBundle ? (ConfigurationBundle)configuration : null) == null) continue;
            it = it;
            boolean bl = false;
            tempBundle.add(it);
        }
        copy.configurationBundle = CollectionsKt.toList((Iterable)tempBundle);
        return copy;
    }
}

