/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.media.controller;

import com.snowplowanalytics.core.media.controller.Log;
import com.snowplowanalytics.core.media.entity.MediaSessionEntity;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.media.entity.MediaAdBreakEntity;
import com.snowplowanalytics.snowplow.media.entity.MediaAdBreakType;
import com.snowplowanalytics.snowplow.media.entity.MediaPlayerEntity;
import com.snowplowanalytics.snowplow.media.event.MediaAdBreakStartEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdClickEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdCompleteEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdFirstQuartileEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdMidpointEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdPauseEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdResumeEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdSkipEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdStartEvent;
import com.snowplowanalytics.snowplow.media.event.MediaAdThirdQuartileEvent;
import com.snowplowanalytics.snowplow.media.event.MediaBufferEndEvent;
import com.snowplowanalytics.snowplow.media.event.MediaBufferStartEvent;
import com.snowplowanalytics.snowplow.media.event.MediaPlayEvent;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u0006H\u0002\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010AJ$\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020G2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010IJ\u001a\u0010J\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010K\u001a\u00020$H\u0002J\u001a\u0010L\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010K\u001a\u00020$H\u0002J\u0010\u0010M\u001a\u00020C2\u0006\u0010K\u001a\u00020$H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001f8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010%\u001a\u00020\u001fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R%\u0010-\u001a\u00020\u001fX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b.\u0010!\"\u0004\b/\u00100R%\u00101\u001a\u00020\u001fX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b2\u0010!\"\u0004\b3\u00100R%\u00104\u001a\u00020\u001fX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b5\u0010!\"\u0004\b6\u00100R%\u00107\u001a\u00020\u001fX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b8\u0010!\"\u0004\b9\u00100R)\u0010;\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001f@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b<\u0010!\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006N"}, d2={"Lcom/snowplowanalytics/core/media/controller/MediaSessionTrackingStats;", "", "session", "Lcom/snowplowanalytics/core/media/entity/MediaSessionEntity;", "dateGenerator", "Lkotlin/Function0;", "Ljava/util/Date;", "(Lcom/snowplowanalytics/core/media/entity/MediaSessionEntity;Lkotlin/jvm/functions/Function0;)V", "adBreaks", "", "getAdBreaks", "()I", "setAdBreaks", "(I)V", "ads", "getAds", "setAds", "adsClicked", "getAdsClicked", "setAdsClicked", "adsSkipped", "getAdsSkipped", "setAdsSkipped", "avgPlaybackRate", "", "getAvgPlaybackRate", "()D", "bufferingStartTime", "Ljava/lang/Double;", "bufferingStartedAt", "contentWatched", "Lkotlin/time/Duration;", "getContentWatched-UwyO8pc", "()J", "lastAdUpdateAt", "lastLog", "Lcom/snowplowanalytics/core/media/controller/Log;", "playbackDurationWithPlaybackRate", "J", "playedSeconds", "", "getSession", "()Lcom/snowplowanalytics/core/media/entity/MediaSessionEntity;", "setSession", "(Lcom/snowplowanalytics/core/media/entity/MediaSessionEntity;)V", "timeBuffering", "getTimeBuffering-UwyO8pc", "setTimeBuffering-LRDsOJo", "(J)V", "timePaused", "getTimePaused-UwyO8pc", "setTimePaused-LRDsOJo", "timePlayed", "getTimePlayed-UwyO8pc", "setTimePlayed-LRDsOJo", "timePlayedMuted", "getTimePlayedMuted-UwyO8pc", "setTimePlayedMuted-LRDsOJo", "<set-?>", "timeSpentAds", "getTimeSpentAds-UwyO8pc", "timeDiff", "since", "until", "timeDiff-3nIYWDw", "(Ljava/util/Date;Ljava/util/Date;)J", "update", "", "event", "Lcom/snowplowanalytics/snowplow/event/Event;", "player", "Lcom/snowplowanalytics/snowplow/media/entity/MediaPlayerEntity;", "adBreak", "Lcom/snowplowanalytics/snowplow/media/entity/MediaAdBreakEntity;", "updateAdStats", "log", "updateBufferingStats", "updateDurationStats", "snowplow-android-tracker_release"})
public final class MediaSessionTrackingStats {
    @NotNull
    private MediaSessionEntity session;
    @NotNull
    private final Function0<Date> dateGenerator;
    @Nullable
    private Date lastAdUpdateAt;
    @Nullable
    private Date bufferingStartedAt;
    @Nullable
    private Double bufferingStartTime;
    private long playbackDurationWithPlaybackRate;
    @NotNull
    private Set<Integer> playedSeconds;
    @Nullable
    private Log lastLog;
    private long timeSpentAds;
    private long timePlayed;
    private long timePlayedMuted;
    private long timePaused;
    private long timeBuffering;
    private int adBreaks;
    private int ads;
    private int adsSkipped;
    private int adsClicked;

    public MediaSessionTrackingStats(@NotNull MediaSessionEntity session, @NotNull Function0<? extends Date> dateGenerator) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(dateGenerator, (String)"dateGenerator");
        this.session = session;
        this.dateGenerator = dateGenerator;
        this.playbackDurationWithPlaybackRate = Duration.Companion.getZERO-UwyO8pc();
        this.playedSeconds = new LinkedHashSet();
        this.timeSpentAds = Duration.Companion.getZERO-UwyO8pc();
        this.timePlayed = Duration.Companion.getZERO-UwyO8pc();
        this.timePlayedMuted = Duration.Companion.getZERO-UwyO8pc();
        this.timePaused = Duration.Companion.getZERO-UwyO8pc();
        this.timeBuffering = Duration.Companion.getZERO-UwyO8pc();
    }

    public /* synthetic */ MediaSessionTrackingStats(MediaSessionEntity mediaSessionEntity, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(mediaSessionEntity, (Function0<? extends Date>)function0);
    }

    @NotNull
    public final MediaSessionEntity getSession() {
        return this.session;
    }

    public final void setSession(@NotNull MediaSessionEntity mediaSessionEntity) {
        Intrinsics.checkNotNullParameter((Object)mediaSessionEntity, (String)"<set-?>");
        this.session = mediaSessionEntity;
    }

    public final long getContentWatched-UwyO8pc() {
        return DurationKt.toDuration((int)this.playedSeconds.size(), (DurationUnit)DurationUnit.SECONDS);
    }

    public final long getTimeSpentAds-UwyO8pc() {
        return this.timeSpentAds;
    }

    public final long getTimePlayed-UwyO8pc() {
        return this.timePlayed;
    }

    public final void setTimePlayed-LRDsOJo(long l) {
        this.timePlayed = l;
    }

    public final long getTimePlayedMuted-UwyO8pc() {
        return this.timePlayedMuted;
    }

    public final void setTimePlayedMuted-LRDsOJo(long l) {
        this.timePlayedMuted = l;
    }

    public final long getTimePaused-UwyO8pc() {
        return this.timePaused;
    }

    public final void setTimePaused-LRDsOJo(long l) {
        this.timePaused = l;
    }

    public final long getTimeBuffering-UwyO8pc() {
        return this.timeBuffering;
    }

    public final void setTimeBuffering-LRDsOJo(long l) {
        this.timeBuffering = l;
    }

    public final double getAvgPlaybackRate() {
        return Duration.compareTo-LRDsOJo((long)this.timePlayed, (long)Duration.Companion.getZERO-UwyO8pc()) > 0 ? Duration.div-LRDsOJo((long)this.playbackDurationWithPlaybackRate, (long)this.timePlayed) : 1.0;
    }

    public final int getAdBreaks() {
        return this.adBreaks;
    }

    public final void setAdBreaks(int n) {
        this.adBreaks = n;
    }

    public final int getAds() {
        return this.ads;
    }

    public final void setAds(int n) {
        this.ads = n;
    }

    public final int getAdsSkipped() {
        return this.adsSkipped;
    }

    public final void setAdsSkipped(int n) {
        this.adsSkipped = n;
    }

    public final int getAdsClicked() {
        return this.adsClicked;
    }

    public final void setAdsClicked(int n) {
        this.adsClicked = n;
    }

    public final void update(@Nullable Event event, @NotNull MediaPlayerEntity player, @Nullable MediaAdBreakEntity adBreak) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Date date = (Date)this.dateGenerator.invoke();
        Double d = player.getCurrentTime();
        double d2 = d != null ? d : 0.0;
        Double d3 = player.getPlaybackRate();
        double d4 = d3 != null ? d3 : 1.0;
        Boolean bl = player.getPaused();
        boolean bl2 = bl != null ? bl : true;
        Boolean bl3 = player.getMuted();
        boolean bl4 = bl3 != null ? bl3 : false;
        Object object = adBreak;
        if (object == null || (object = object.getBreakType()) == null) {
            object = MediaAdBreakType.Linear;
        }
        Log log = new Log(date, d2, d4, bl2, bl4, object == MediaAdBreakType.Linear);
        this.updateDurationStats(log);
        this.updateAdStats(event, log);
        this.updateBufferingStats(event, log);
        this.lastLog = log;
    }

    public static /* synthetic */ void update$default(MediaSessionTrackingStats mediaSessionTrackingStats, Event event, MediaPlayerEntity mediaPlayerEntity, MediaAdBreakEntity mediaAdBreakEntity, int n, Object object) {
        if ((n & 4) != 0) {
            mediaAdBreakEntity = null;
        }
        mediaSessionTrackingStats.update(event, mediaPlayerEntity, mediaAdBreakEntity);
    }

    private final void updateDurationStats(Log log) {
        block7: {
            boolean shouldCountStats;
            boolean wasPlayingAd = this.lastAdUpdateAt != null;
            boolean bl = shouldCountStats = !wasPlayingAd || !log.getLinearAd();
            if (!shouldCountStats) {
                return;
            }
            Log log2 = this.lastLog;
            if (log2 == null) break block7;
            Log lastLog = log2;
            boolean bl2 = false;
            long duration = this.timeDiff-3nIYWDw(lastLog.getTime(), log.getTime());
            if (lastLog.getPaused()) {
                this.timePaused = Duration.plus-LRDsOJo((long)this.timePaused, (long)duration);
            } else {
                this.timePlayed = Duration.plus-LRDsOJo((long)this.timePlayed, (long)duration);
                this.playbackDurationWithPlaybackRate = Duration.plus-LRDsOJo((long)this.playbackDurationWithPlaybackRate, (long)Duration.times-UwyO8pc((long)duration, (double)lastLog.getPlaybackRate()));
                if (lastLog.getMuted()) {
                    this.timePlayedMuted = Duration.plus-LRDsOJo((long)this.timePlayedMuted, (long)duration);
                }
                if (!log.getPaused() && log.getContentTime() > lastLog.getContentTime()) {
                    int n = (int)log.getContentTime();
                    for (int i = (int)lastLog.getContentTime(); i < n; ++i) {
                        this.playedSeconds.add(i);
                    }
                }
            }
            if (!log.getPaused()) {
                this.playedSeconds.add((int)log.getContentTime());
            }
        }
    }

    private final void updateAdStats(Event event, Log log) {
        Event event2 = event;
        if (event2 instanceof MediaAdBreakStartEvent) {
            int n = this.adBreaks;
            this.adBreaks = n + 1;
        } else if (event2 instanceof MediaAdStartEvent) {
            int n = this.ads;
            this.ads = n + 1;
        } else if (event2 instanceof MediaAdSkipEvent) {
            int n = this.adsSkipped;
            this.adsSkipped = n + 1;
        } else if (event2 instanceof MediaAdClickEvent) {
            int n = this.adsClicked;
            this.adsClicked = n + 1;
        }
        event2 = event;
        if (event2 instanceof MediaAdStartEvent ? true : event2 instanceof MediaAdResumeEvent) {
            if (this.lastAdUpdateAt == null) {
                this.lastAdUpdateAt = log.getTime();
            }
        } else if (((event2 instanceof MediaAdClickEvent ? true : event2 instanceof MediaAdFirstQuartileEvent) ? true : event2 instanceof MediaAdMidpointEvent) ? true : event2 instanceof MediaAdThirdQuartileEvent) {
            Date date = this.lastAdUpdateAt;
            if (date != null) {
                Date lastAdUpdateAt = date;
                boolean bl = false;
                this.timeSpentAds = Duration.plus-LRDsOJo((long)this.timeSpentAds, (long)this.timeDiff-3nIYWDw(lastAdUpdateAt, log.getTime()));
            }
            this.lastAdUpdateAt = log.getTime();
        } else if ((event2 instanceof MediaAdCompleteEvent ? true : event2 instanceof MediaAdSkipEvent) ? true : event2 instanceof MediaAdPauseEvent) {
            Date date = this.lastAdUpdateAt;
            if (date != null) {
                Date lastAdUpdateAt = date;
                boolean bl = false;
                this.timeSpentAds = Duration.plus-LRDsOJo((long)this.timeSpentAds, (long)this.timeDiff-3nIYWDw(lastAdUpdateAt, log.getTime()));
            }
            this.lastAdUpdateAt = null;
        }
    }

    private final void updateBufferingStats(Event event, Log log) {
        if (event instanceof MediaBufferStartEvent) {
            this.bufferingStartedAt = log.getTime();
            this.bufferingStartTime = log.getContentTime();
        } else {
            Date date = this.bufferingStartedAt;
            if (date == null) {
                return;
            }
            Date bufferingStartedAt = date;
            Double d = this.bufferingStartTime;
            if (d == null) {
                return;
            }
            double bufferingStartTime = d;
            if (!(log.getContentTime() == bufferingStartTime) && !log.getPaused() || event instanceof MediaBufferEndEvent || event instanceof MediaPlayEvent) {
                this.timeBuffering = Duration.plus-LRDsOJo((long)this.timeBuffering, (long)this.timeDiff-3nIYWDw(bufferingStartedAt, log.getTime()));
                this.bufferingStartedAt = null;
                this.bufferingStartTime = null;
            } else {
                this.timeBuffering = Duration.plus-LRDsOJo((long)this.timeBuffering, (long)this.timeDiff-3nIYWDw(bufferingStartedAt, log.getTime()));
                this.bufferingStartedAt = log.getTime();
            }
        }
    }

    private final long timeDiff-3nIYWDw(Date since, Date until) {
        return DurationKt.toDuration((long)(until.getTime() - since.getTime()), (DurationUnit)DurationUnit.MILLISECONDS);
    }
}

