/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.media.controller;

import com.snowplowanalytics.core.Controller;
import com.snowplowanalytics.core.media.controller.MediaPingInterval;
import com.snowplowanalytics.core.media.controller.MediaSessionTracking;
import com.snowplowanalytics.core.media.controller.MediaTrackingImpl;
import com.snowplowanalytics.core.tracker.ServiceProvider;
import com.snowplowanalytics.snowplow.media.configuration.MediaTrackingConfiguration;
import com.snowplowanalytics.snowplow.media.controller.MediaController;
import com.snowplowanalytics.snowplow.media.controller.MediaTracking;
import com.snowplowanalytics.snowplow.media.entity.MediaPlayerEntity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/snowplowanalytics/core/media/controller/MediaControllerImpl;", "Lcom/snowplowanalytics/core/Controller;", "Lcom/snowplowanalytics/snowplow/media/controller/MediaController;", "serviceProvider", "Lcom/snowplowanalytics/core/tracker/ServiceProvider;", "(Lcom/snowplowanalytics/core/tracker/ServiceProvider;)V", "mediaTrackings", "", "", "Lcom/snowplowanalytics/core/media/controller/MediaTrackingImpl;", "endMediaTracking", "", "id", "getMediaTracking", "Lcom/snowplowanalytics/snowplow/media/controller/MediaTracking;", "startMediaTracking", "configuration", "Lcom/snowplowanalytics/snowplow/media/configuration/MediaTrackingConfiguration;", "player", "Lcom/snowplowanalytics/snowplow/media/entity/MediaPlayerEntity;", "snowplow-android-tracker_release"})
public final class MediaControllerImpl
extends Controller
implements MediaController {
    @NotNull
    private Map<String, MediaTrackingImpl> mediaTrackings;

    public MediaControllerImpl(@NotNull ServiceProvider serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        super(serviceProvider);
        this.mediaTrackings = new LinkedHashMap();
    }

    @Override
    @NotNull
    public MediaTracking startMediaTracking(@NotNull String id, @Nullable MediaPlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MediaTrackingConfiguration configuration = new MediaTrackingConfiguration(id, player, false, null, null, false, null, null, null, 508, null);
        return this.startMediaTracking(configuration);
    }

    @Override
    @NotNull
    public MediaTracking startMediaTracking(@NotNull MediaTrackingConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        MediaSessionTracking session = configuration.getSession() ? new MediaSessionTracking(configuration.getId(), null, configuration.getPingInterval(), null, 10, null) : null;
        MediaPingInterval pingInterval = configuration.getPings() ? new MediaPingInterval(configuration.getPingInterval(), configuration.getMaxPausedPings(), null, 4, null) : null;
        MediaTrackingImpl mediaTracking = new MediaTrackingImpl(configuration.getId(), this.getServiceProvider().getOrMakeTrackerController(), configuration.getPlayer(), session, pingInterval, configuration.getBoundaries(), configuration.getCaptureEvents(), configuration.getEntities());
        this.mediaTrackings.put(configuration.getId(), mediaTracking);
        return mediaTracking;
    }

    @Override
    @Nullable
    public MediaTracking getMediaTracking(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.mediaTrackings.get(id);
    }

    @Override
    public void endMediaTracking(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MediaTrackingImpl mediaTrackingImpl = this.mediaTrackings.get(id);
        if (mediaTrackingImpl != null) {
            mediaTrackingImpl.end();
        }
        this.mediaTrackings.remove(id);
    }
}

