/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.emitter.storage.EventStoreHelper;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.emitter.EmitterEvent;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0006\u0010#\u001a\u00020!J\"\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000b2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u000b2\u0006\u0010)\u001a\u00020&H\u0016J\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\f2\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010-\u001a\u00020!H\u0002J\u0006\u0010.\u001a\u00020!J0\u0010/\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000b2\b\u00100\u001a\u0004\u0018\u00010\u00052\b\u00101\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u00102\u001a\u00020\u0013H\u0016J\u0010\u00103\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0019H\u0016J\u0018\u00104\u001a\u00020\u00132\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001eH\u0016J\b\u00106\u001a\u00020\u0019H\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR%\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/snowplowanalytics/core/emitter/storage/SQLiteEventStore;", "Lcom/snowplowanalytics/snowplow/emitter/EventStore;", "context", "Landroid/content/Context;", "namespace", "", "(Landroid/content/Context;Ljava/lang/String;)V", "allColumns", "", "[Ljava/lang/String;", "allEvents", "", "", "", "getAllEvents", "()Ljava/util/List;", "database", "Landroid/database/sqlite/SQLiteDatabase;", "databaseOpen", "", "getDatabaseOpen", "()Z", "dbHelper", "Lcom/snowplowanalytics/core/emitter/storage/EventStoreHelper;", "<set-?>", "", "lastInsertedRowId", "getLastInsertedRowId", "()J", "payloadWaitingList", "", "Lcom/snowplowanalytics/snowplow/payload/Payload;", "add", "", "payload", "close", "getDescEventsInRange", "range", "", "getEmittableEvents", "Lcom/snowplowanalytics/snowplow/emitter/EmitterEvent;", "queryLimit", "getEvent", "id", "insertEvent", "insertWaitingEventsIfReady", "open", "queryDatabase", "query", "orderBy", "removeAllEvents", "removeEvent", "removeEvents", "ids", "size", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nSQLiteEventStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteEventStore.kt\ncom/snowplowanalytics/core/emitter/storage/SQLiteEventStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class SQLiteEventStore
implements EventStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String namespace;
    @NotNull
    private final List<Payload> payloadWaitingList;
    @Nullable
    private SQLiteDatabase database;
    private EventStoreHelper dbHelper;
    @NotNull
    private final String[] allColumns;
    private long lastInsertedRowId;
    private static final String TAG = SQLiteEventStore.class.getSimpleName();

    public SQLiteEventStore(@NotNull Context context, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
        this.payloadWaitingList = new ArrayList();
        String[] stringArray = new String[]{"id", "eventData", "dateCreated"};
        this.allColumns = stringArray;
        this.lastInsertedRowId = -1L;
        Executor.futureCallable(() -> SQLiteEventStore._init_$lambda$0(this, context));
    }

    public final long getLastInsertedRowId() {
        return this.lastInsertedRowId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getDatabaseOpen() {
        if (this.database == null) return false;
        SQLiteDatabase sQLiteDatabase = this.database;
        Intrinsics.checkNotNull((Object)sQLiteDatabase);
        if (!sQLiteDatabase.isOpen()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NotNull Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (!this.getDatabaseOpen()) {
            SQLiteEventStore sQLiteEventStore = this;
            synchronized (sQLiteEventStore) {
                boolean bl = false;
                boolean bl2 = this.payloadWaitingList.add(payload);
            }
        } else {
            this.insertWaitingEventsIfReady();
            this.insertEvent(payload);
        }
    }

    public final void open() {
        block2: {
            if (this.getDatabaseOpen()) break block2;
            EventStoreHelper eventStoreHelper = this.dbHelper;
            if (eventStoreHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dbHelper");
                eventStoreHelper = null;
            }
            SQLiteDatabase sQLiteDatabase = this.database = eventStoreHelper.getWritableDatabase();
            if (sQLiteDatabase != null) {
                sQLiteDatabase.enableWriteAheadLogging();
            }
        }
    }

    public final void close() {
        EventStoreHelper eventStoreHelper = this.dbHelper;
        if (eventStoreHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dbHelper");
            eventStoreHelper = null;
        }
        eventStoreHelper.close();
        EventStoreHelper.Companion.removeInstance(this.namespace);
    }

    public final long insertEvent(@NotNull Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.getDatabaseOpen()) {
            byte[] bytes = Util.serialize(Util.objectMapToString(payload.getMap()));
            ContentValues values = new ContentValues(2);
            values.put("eventData", bytes);
            SQLiteDatabase sQLiteDatabase = this.database;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            this.lastInsertedRowId = sQLiteDatabase.insert("events", null, values);
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{this.lastInsertedRowId};
        Logger.d(string, "Added event to database: %s", objectArray);
        return this.lastInsertedRowId;
    }

    @Override
    public boolean removeEvent(long id) {
        int retval = -1;
        if (this.getDatabaseOpen()) {
            SQLiteDatabase sQLiteDatabase = this.database;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            retval = sQLiteDatabase.delete("events", "id=" + id, null);
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{"" + id};
        Logger.d(string, "Removed event from database: %s", objectArray);
        return retval == 1;
    }

    @Override
    public boolean removeEvents(@NotNull List<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return false;
        }
        int retval = -1;
        if (this.getDatabaseOpen()) {
            SQLiteDatabase sQLiteDatabase = this.database;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            retval = sQLiteDatabase.delete("events", "id in (" + Util.joinLongList(ids) + ')', null);
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{retval};
        Logger.d(string, "Removed events from database: %s", objectArray);
        return retval == ids.size();
    }

    @Override
    public boolean removeAllEvents() {
        int retval = 0;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "Removing all events from database.", new Object[0]);
        if (this.getDatabaseOpen()) {
            SQLiteDatabase sQLiteDatabase = this.database;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            retval = sQLiteDatabase.delete("events", null, null);
        } else {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Logger.e(string2, "Database is not open.", new Object[0]);
        }
        this.payloadWaitingList.clear();
        return (retval += this.payloadWaitingList.size()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Map<String, Object>> queryDatabase(String query, String orderBy) {
        List res = new ArrayList();
        if (this.getDatabaseOpen()) {
            Cursor cursor = null;
            try {
                SQLiteDatabase sQLiteDatabase = this.database;
                Intrinsics.checkNotNull((Object)sQLiteDatabase);
                cursor = sQLiteDatabase.query("events", this.allColumns, query, null, null, null, orderBy);
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    Map eventMetadata = new HashMap();
                    eventMetadata.put("id", cursor.getLong(0));
                    Map map = eventMetadata;
                    String string = "eventData";
                    byte[] byArray = cursor.getBlob(1);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cursor.getBlob(1)");
                    Map<String, String> map2 = Util.deserializer(byArray);
                    map.put(string, map2);
                    eventMetadata.put("dateCreated", cursor.getString(2));
                    cursor.moveToNext();
                    res.add(eventMetadata);
                }
            }
            finally {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }
        return res;
    }

    @Override
    public long size() {
        long l;
        if (this.getDatabaseOpen()) {
            this.insertWaitingEventsIfReady();
            l = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)"events");
        } else {
            l = this.payloadWaitingList.size();
        }
        return l;
    }

    @Override
    @NotNull
    public List<EmitterEvent> getEmittableEvents(int queryLimit) {
        if (!this.getDatabaseOpen()) {
            return CollectionsKt.emptyList();
        }
        this.insertWaitingEventsIfReady();
        ArrayList<EmitterEvent> events = new ArrayList<EmitterEvent>();
        for (Map<String, Object> eventMetadata : this.getDescEventsInRange(queryLimit)) {
            Object object;
            Long eventId;
            Map eventData;
            TrackerPayload payload = new TrackerPayload();
            Object object2 = eventMetadata.get("eventData");
            Map map = eventData = object2 instanceof Map ? (Map)object2 : null;
            if (eventData != null) {
                payload.addMap(eventData);
            }
            Long l = eventId = (object = eventMetadata.get("id")) instanceof Long ? (Long)object : null;
            if (eventId == null) {
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.e(string, "Unable to get ID of an event extracted from the database.", new Object[0]);
                continue;
            }
            EmitterEvent event = new EmitterEvent(payload, eventId);
            events.add(event);
        }
        return events;
    }

    @Nullable
    public final Map<String, Object> getEvent(long id) {
        List<Map<String, Object>> res = this.queryDatabase("id=" + id, null);
        return !((Collection)res).isEmpty() ? res.get(0) : null;
    }

    @NotNull
    public final List<Map<String, Object>> getAllEvents() {
        return this.queryDatabase(null, null);
    }

    @NotNull
    public final List<Map<String, Object>> getDescEventsInRange(int range) {
        return this.queryDatabase(null, "id DESC LIMIT " + range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void insertWaitingEventsIfReady() {
        if (this.getDatabaseOpen() && this.payloadWaitingList.size() > 0) {
            SQLiteEventStore sQLiteEventStore = this;
            synchronized (sQLiteEventStore) {
                boolean bl = false;
                for (Payload p : this.payloadWaitingList) {
                    this.insertEvent(p);
                }
                this.payloadWaitingList.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final Object _init_$lambda$0(SQLiteEventStore this$0, Context $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        this$0.dbHelper = EventStoreHelper.Companion.getInstance($context, this$0.namespace);
        this$0.open();
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[1];
        SQLiteDatabase sQLiteDatabase = this$0.database;
        objectArray[0] = sQLiteDatabase != null ? sQLiteDatabase.getPath() : null;
        Logger.d(string, "DB Path: %s", objectArray);
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/snowplowanalytics/core/emitter/storage/SQLiteEventStore$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "removeUnsentEventsExceptForNamespaces", "", "context", "Landroid/content/Context;", "allowedNamespaces", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> removeUnsentEventsExceptForNamespaces(@NotNull Context context, @Nullable List<String> allowedNamespaces) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return EventStoreHelper.Companion.removeUnsentEventsExceptForNamespaces(context, allowedNamespaces);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

