/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.tracker.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J$\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0003J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/snowplowanalytics/core/emitter/Executor;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "count", "", "threadCount", "getThreadCount", "()I", "setThreadCount", "(I)V", "execute", "", "runnable", "Ljava/lang/Runnable;", "exceptionHandler", "Lcom/snowplowanalytics/core/emitter/Executor$ExceptionHandler;", "reportsOnDiagnostic", "", "tag", "", "futureCallable", "Ljava/util/concurrent/Future;", "callable", "Ljava/util/concurrent/Callable;", "getExecutor", "shutdown", "ExceptionHandler", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Executor {
    @NotNull
    public static final Executor INSTANCE = new Executor();
    @Nullable
    private static ExecutorService executor;
    private static int threadCount;

    private Executor() {
    }

    public final int getThreadCount() {
        return threadCount;
    }

    @JvmStatic
    public static final void setThreadCount(int count) {
        if (count >= 2) {
            threadCount = count;
        }
    }

    @JvmStatic
    private static final synchronized ExecutorService getExecutor() {
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(threadCount);
        }
        ExecutorService executorService = executor;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    @JvmStatic
    public static final void execute(@Nullable String tag, @Nullable Runnable runnable) {
        Executor.execute(false, tag, runnable);
    }

    @JvmStatic
    public static final void execute(boolean reportsOnDiagnostic, @Nullable String tag, @Nullable Runnable runnable) {
        String string = tag;
        if (string == null) {
            string = "Source not provided";
        }
        String loggerTag = string;
        Executor.execute(runnable, arg_0 -> Executor.execute$lambda$0(reportsOnDiagnostic, loggerTag, arg_0));
    }

    @JvmStatic
    public static final void execute(@Nullable Runnable runnable, @Nullable ExceptionHandler exceptionHandler) {
        block2: {
            ExecutorService executor = INSTANCE.getExecutor();
            try {
                executor.execute(() -> Executor.execute$lambda$1(runnable, exceptionHandler));
            }
            catch (Exception e) {
                ExceptionHandler exceptionHandler2 = exceptionHandler;
                if (exceptionHandler2 == null) break block2;
                exceptionHandler2.handle(e);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final Future<?> futureCallable(@NotNull Callable<?> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Future<?> future = INSTANCE.getExecutor().submit(callable);
        Intrinsics.checkNotNullExpressionValue(future, (String)"getExecutor().submit(callable)");
        return future;
    }

    @JvmStatic
    @Nullable
    public static final ExecutorService shutdown() {
        if (executor != null) {
            ExecutorService executorService = executor;
            Intrinsics.checkNotNull((Object)executorService);
            executorService.shutdown();
            ExecutorService es = executor;
            executor = null;
            return es;
        }
        return null;
    }

    private static final void execute$lambda$0(boolean $reportsOnDiagnostic, String $loggerTag, Throwable t) {
        String message;
        Intrinsics.checkNotNullParameter((Object)$loggerTag, (String)"$loggerTag");
        Throwable throwable = t;
        String string = message = throwable != null ? throwable.getLocalizedMessage() : null;
        if (message == null) {
            message = "No message provided.";
        }
        if ($reportsOnDiagnostic) {
            Object[] objectArray = new Object[]{t};
            Logger.track($loggerTag, message, objectArray);
        } else {
            Object[] objectArray = new Object[]{t};
            Logger.e($loggerTag, message, objectArray);
        }
    }

    private static final void execute$lambda$1(Runnable $runnable, ExceptionHandler $exceptionHandler) {
        block2: {
            try {
                Runnable runnable = $runnable;
                if (runnable == null) break block2;
                runnable.run();
            }
            catch (Throwable t) {
                ExceptionHandler exceptionHandler = $exceptionHandler;
                if (exceptionHandler == null) break block2;
                exceptionHandler.handle(t);
            }
        }
    }

    static {
        threadCount = 2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/emitter/Executor$ExceptionHandler;", "", "handle", "", "t", "", "snowplow-android-tracker_release"})
    public static interface ExceptionHandler {
        public void handle(@Nullable Throwable var1);
    }
}

