/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import androidx.annotation.RestrictTo;
import com.snowplowanalytics.core.Controller;
import com.snowplowanalytics.core.emitter.Emitter;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.configuration.EmitterConfiguration;
import com.snowplowanalytics.snowplow.controller.EmitterController;
import com.snowplowanalytics.snowplow.emitter.BufferOption;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.network.RequestCallback;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020CH\u0016R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R@\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00162\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R(\u00102\u001a\u0004\u0018\u0001032\b\u00102\u001a\u0004\u0018\u0001038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00109\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u00101\"\u0004\b;\u0010<R$\u0010=\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u00101\"\u0004\b?\u0010<R\u0014\u0010@\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010%\u00a8\u0006F"}, d2={"Lcom/snowplowanalytics/core/emitter/EmitterControllerImpl;", "Lcom/snowplowanalytics/core/Controller;", "Lcom/snowplowanalytics/snowplow/controller/EmitterController;", "serviceProvider", "Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;", "(Lcom/snowplowanalytics/core/tracker/ServiceProviderInterface;)V", "bufferOption", "Lcom/snowplowanalytics/snowplow/emitter/BufferOption;", "getBufferOption", "()Lcom/snowplowanalytics/snowplow/emitter/BufferOption;", "setBufferOption", "(Lcom/snowplowanalytics/snowplow/emitter/BufferOption;)V", "byteLimitGet", "", "getByteLimitGet", "()J", "setByteLimitGet", "(J)V", "byteLimitPost", "getByteLimitPost", "setByteLimitPost", "customRetryForStatusCodes", "", "", "", "getCustomRetryForStatusCodes", "()Ljava/util/Map;", "setCustomRetryForStatusCodes", "(Ljava/util/Map;)V", "dbCount", "getDbCount", "dirtyConfig", "Lcom/snowplowanalytics/snowplow/configuration/EmitterConfiguration;", "getDirtyConfig", "()Lcom/snowplowanalytics/snowplow/configuration/EmitterConfiguration;", "emitRange", "getEmitRange", "()I", "setEmitRange", "(I)V", "emitter", "Lcom/snowplowanalytics/core/emitter/Emitter;", "getEmitter", "()Lcom/snowplowanalytics/core/emitter/Emitter;", "eventStore", "Lcom/snowplowanalytics/snowplow/emitter/EventStore;", "getEventStore", "()Lcom/snowplowanalytics/snowplow/emitter/EventStore;", "isSending", "()Z", "requestCallback", "Lcom/snowplowanalytics/snowplow/network/RequestCallback;", "getRequestCallback", "()Lcom/snowplowanalytics/snowplow/network/RequestCallback;", "setRequestCallback", "(Lcom/snowplowanalytics/snowplow/network/RequestCallback;)V", "value", "retryFailedRequests", "getRetryFailedRequests", "setRetryFailedRequests", "(Z)V", "serverAnonymisation", "getServerAnonymisation", "setServerAnonymisation", "threadPoolSize", "getThreadPoolSize", "pause", "", "resume", "Companion", "snowplow-android-tracker_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EmitterControllerImpl
extends Controller
implements EmitterController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = EmitterControllerImpl.class.getSimpleName();

    public EmitterControllerImpl(@NotNull ServiceProviderInterface serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        super(serviceProvider);
    }

    private final Emitter getEmitter() {
        return this.getServiceProvider().getOrMakeTracker().getEmitter();
    }

    @Override
    @Nullable
    public EventStore getEventStore() {
        return this.getEmitter().getEventStore();
    }

    @Override
    @NotNull
    public BufferOption getBufferOption() {
        return this.getEmitter().getBufferOption();
    }

    @Override
    public void setBufferOption(@NotNull BufferOption bufferOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)bufferOption), (String)"bufferOption");
        this.getDirtyConfig().setBufferOption(bufferOption);
        this.getEmitter().setBufferOption(bufferOption);
    }

    @Override
    public int getEmitRange() {
        return this.getEmitter().getSendLimit();
    }

    @Override
    public void setEmitRange(int emitRange) {
        this.getDirtyConfig().setEmitRange(emitRange);
        this.getEmitter().setSendLimit(emitRange);
    }

    @Override
    public int getThreadPoolSize() {
        return Executor.INSTANCE.getThreadCount();
    }

    @Override
    public long getByteLimitGet() {
        return this.getEmitter().getByteLimitGet();
    }

    @Override
    public void setByteLimitGet(long byteLimitGet) {
        this.getDirtyConfig().setByteLimitGet(byteLimitGet);
        this.getEmitter().setByteLimitGet(byteLimitGet);
    }

    @Override
    public long getByteLimitPost() {
        return this.getEmitter().getByteLimitPost();
    }

    @Override
    public void setByteLimitPost(long byteLimitPost) {
        this.getDirtyConfig().setByteLimitPost(byteLimitPost);
        this.getEmitter().setByteLimitPost(byteLimitPost);
    }

    @Override
    @Nullable
    public RequestCallback getRequestCallback() {
        return this.getEmitter().getRequestCallback();
    }

    @Override
    public void setRequestCallback(@Nullable RequestCallback requestCallback) {
        this.getDirtyConfig().setRequestCallback(requestCallback);
        this.getEmitter().setRequestCallback(requestCallback);
    }

    @Override
    @Nullable
    public Map<Integer, Boolean> getCustomRetryForStatusCodes() {
        return this.getEmitter().getCustomRetryForStatusCodes();
    }

    @Override
    public void setCustomRetryForStatusCodes(@Nullable Map<Integer, Boolean> customRetryForStatusCodes) {
        this.getDirtyConfig().setCustomRetryForStatusCodes(customRetryForStatusCodes);
        this.getEmitter().setCustomRetryForStatusCodes(customRetryForStatusCodes);
    }

    @Override
    public boolean getServerAnonymisation() {
        return this.getEmitter().getServerAnonymisation();
    }

    @Override
    public void setServerAnonymisation(boolean serverAnonymisation) {
        this.getDirtyConfig().setServerAnonymisation(serverAnonymisation);
        this.getEmitter().setServerAnonymisation(serverAnonymisation);
    }

    @Override
    public boolean getRetryFailedRequests() {
        return this.getEmitter().getRetryFailedRequests();
    }

    @Override
    public void setRetryFailedRequests(boolean value) {
        this.getDirtyConfig().setRetryFailedRequests(value);
        this.getEmitter().setRetryFailedRequests(value);
    }

    @Override
    public long getDbCount() {
        EventStore eventStore = this.getEmitter().getEventStore();
        if (eventStore == null) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.e(string, "EventStore not available in the Emitter.", new Object[0]);
            return -1L;
        }
        return eventStore.size();
    }

    @Override
    public boolean isSending() {
        return this.getEmitter().getEmitterStatus();
    }

    @Override
    public void pause() {
        this.getDirtyConfig().setPaused$snowplow_android_tracker_release(true);
        this.getEmitter().pauseEmit();
    }

    @Override
    public void resume() {
        this.getDirtyConfig().setPaused$snowplow_android_tracker_release(false);
        this.getEmitter().resumeEmit();
    }

    private final EmitterConfiguration getDirtyConfig() {
        return this.getServiceProvider().getEmitterConfiguration();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/snowplowanalytics/core/emitter/EmitterControllerImpl$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

