/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.core.emitter;

import android.content.Context;
import com.snowplowanalytics.core.emitter.EmitterDefaults;
import com.snowplowanalytics.core.emitter.Executor;
import com.snowplowanalytics.core.emitter.TLSVersion;
import com.snowplowanalytics.core.emitter.storage.SQLiteEventStore;
import com.snowplowanalytics.core.tracker.Logger;
import com.snowplowanalytics.core.utils.Util;
import com.snowplowanalytics.snowplow.emitter.BufferOption;
import com.snowplowanalytics.snowplow.emitter.EmitterEvent;
import com.snowplowanalytics.snowplow.emitter.EventStore;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.OkHttpNetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.network.Request;
import com.snowplowanalytics.snowplow.network.RequestCallback;
import com.snowplowanalytics.snowplow.network.RequestResult;
import com.snowplowanalytics.snowplow.payload.Payload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00aa\u00012\u00020\u0001:\u0002\u00aa\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0097\u0001\u001a\u00020\b2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\u001c\u0010\u009a\u0001\u001a\u00020\b2\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u0005H\u0002J\u0013\u0010\u009c\u0001\u001a\u00020\b2\b\u0010f\u001a\u0004\u0018\u00010\u0012H\u0002J,\u0010\u009d\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u009e\u00012\u0011\u0010\u00a0\u0001\u001a\f\u0012\u0007\u0012\u0005\u0018\u00010\u00a1\u00010\u009e\u00012\u0006\u0010Z\u001a\u00020YH\u0002J\u0007\u0010\u00a2\u0001\u001a\u00020\bJ\u001b\u0010\u00a3\u0001\u001a\u00020\u00102\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u0010Z\u001a\u00020YH\u0002J-\u0010\u00a3\u0001\u001a\u00020\u00102\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00a4\u0001\u001a\u00020\u001d2\u000f\u0010\u00a5\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u009e\u0001H\u0002J,\u0010\u00a3\u0001\u001a\u00020\u00102\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u000f\u0010\u00a5\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u009e\u00012\u0006\u0010Z\u001a\u00020YH\u0002J\u0007\u0010\u00a6\u0001\u001a\u00020\bJ\u0007\u0010\u00a7\u0001\u001a\u00020\bJ\u0007\u0010\u00a8\u0001\u001a\u00020\bJ\u0010\u0010\u00a8\u0001\u001a\u00020\u00102\u0007\u0010\u00a9\u0001\u001a\u00020\u001dR\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00100\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R(\u0010%\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010+\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00101\u001a\u0004\u0018\u00010\u00052\b\u00101\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R@\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R*\u0010<\u001a\u0004\u0018\u00010\u000f2\b\u0010<\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010A\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0011\u0010B\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR$\u0010K\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u00103\"\u0004\bM\u00105R\u000e\u0010N\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010O\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010G\"\u0004\bQ\u0010IR(\u0010R\u001a\u0004\u0018\u00010S2\b\u0010R\u001a\u0004\u0018\u00010S@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010Z\u001a\u00020Y2\u0006\u0010X\u001a\u00020Y@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u000e\u0010_\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010c\u001a\u0004\u0018\u00010\u00052\b\u0010c\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u00103\"\u0004\be\u00105R(\u0010f\u001a\u0004\u0018\u00010\u00122\b\u00106\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001c\u0010k\u001a\u0004\u0018\u00010lX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR@\u0010q\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e2\u0014\u0010q\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u00109\"\u0004\bs\u0010;R$\u0010v\u001a\u00020u2\u0006\u0010t\u001a\u00020u@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR$\u0010{\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b|\u0010D\"\u0004\b}\u0010~R\u001c\u0010\u007f\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010G\"\u0005\b\u0081\u0001\u0010IR(\u0010\u0082\u0001\u001a\u00020\u00102\u0007\u0010\u0082\u0001\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010D\"\u0005\b\u0084\u0001\u0010~R(\u0010\u0086\u0001\u001a\u00020\u000f2\u0007\u0010\u0085\u0001\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0087\u0001\u0010G\"\u0005\b\u0088\u0001\u0010IR,\u0010\u008b\u0001\u001a\u00030\u008a\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001\"\u0006\b\u008e\u0001\u0010\u008f\u0001R'\u0010\u0090\u0001\u001a\n\u0012\u0005\u0012\u00030\u0092\u00010\u0091\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001\"\u0006\b\u0095\u0001\u0010\u0096\u0001R\u000e\u0010J\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/snowplowanalytics/core/emitter/Emitter;", "", "context", "Landroid/content/Context;", "collectorUri", "", "builder", "Lkotlin/Function1;", "", "(Landroid/content/Context;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "TAG", "kotlin.jvm.PlatformType", "_customRetryForStatusCodes", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "", "_networkConnection", "Lcom/snowplowanalytics/snowplow/network/NetworkConnection;", "_retryFailedRequests", "option", "Lcom/snowplowanalytics/snowplow/emitter/BufferOption;", "bufferOption", "getBufferOption", "()Lcom/snowplowanalytics/snowplow/emitter/BufferOption;", "setBufferOption", "(Lcom/snowplowanalytics/snowplow/emitter/BufferOption;)V", "builderFinished", "byteLimitGet", "", "getByteLimitGet", "()J", "setByteLimitGet", "(J)V", "byteLimitPost", "getByteLimitPost", "setByteLimitPost", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "setClient", "(Lokhttp3/OkHttpClient;)V", "cookieJar", "Lokhttp3/CookieJar;", "getCookieJar", "()Lokhttp3/CookieJar;", "setCookieJar", "(Lokhttp3/CookieJar;)V", "customPostPath", "getCustomPostPath", "()Ljava/lang/String;", "setCustomPostPath", "(Ljava/lang/String;)V", "value", "customRetryForStatusCodes", "getCustomRetryForStatusCodes", "()Ljava/util/Map;", "setCustomRetryForStatusCodes", "(Ljava/util/Map;)V", "emitTimeout", "getEmitTimeout", "()Ljava/lang/Integer;", "setEmitTimeout", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "emitterStatus", "getEmitterStatus", "()Z", "emitterTick", "getEmitterTick", "()I", "setEmitterTick", "(I)V", "uri", "emitterUri", "getEmitterUri", "setEmitterUri", "emptyCount", "emptyLimit", "getEmptyLimit", "setEmptyLimit", "eventStore", "Lcom/snowplowanalytics/snowplow/emitter/EventStore;", "getEventStore", "()Lcom/snowplowanalytics/snowplow/emitter/EventStore;", "setEventStore", "(Lcom/snowplowanalytics/snowplow/emitter/EventStore;)V", "method", "Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "httpMethod", "getHttpMethod", "()Lcom/snowplowanalytics/snowplow/network/HttpMethod;", "setHttpMethod", "(Lcom/snowplowanalytics/snowplow/network/HttpMethod;)V", "isCustomNetworkConnection", "isEmittingPaused", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRunning", "namespace", "getNamespace", "setNamespace", "networkConnection", "getNetworkConnection", "()Lcom/snowplowanalytics/snowplow/network/NetworkConnection;", "setNetworkConnection", "(Lcom/snowplowanalytics/snowplow/network/NetworkConnection;)V", "requestCallback", "Lcom/snowplowanalytics/snowplow/network/RequestCallback;", "getRequestCallback", "()Lcom/snowplowanalytics/snowplow/network/RequestCallback;", "setRequestCallback", "(Lcom/snowplowanalytics/snowplow/network/RequestCallback;)V", "requestHeaders", "getRequestHeaders", "setRequestHeaders", "security", "Lcom/snowplowanalytics/snowplow/network/Protocol;", "requestSecurity", "getRequestSecurity", "()Lcom/snowplowanalytics/snowplow/network/Protocol;", "setRequestSecurity", "(Lcom/snowplowanalytics/snowplow/network/Protocol;)V", "retryFailedRequests", "getRetryFailedRequests", "setRetryFailedRequests", "(Z)V", "sendLimit", "getSendLimit", "setSendLimit", "serverAnonymisation", "getServerAnonymisation", "setServerAnonymisation", "poolSize", "threadPoolSize", "getThreadPoolSize", "setThreadPoolSize", "unit", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "setTimeUnit", "(Ljava/util/concurrent/TimeUnit;)V", "tlsVersions", "Ljava/util/EnumSet;", "Lcom/snowplowanalytics/core/emitter/TLSVersion;", "getTlsVersions", "()Ljava/util/EnumSet;", "setTlsVersions", "(Ljava/util/EnumSet;)V", "add", "payload", "Lcom/snowplowanalytics/snowplow/payload/Payload;", "addSendingTimeToPayload", "timestamp", "attemptEmit", "buildRequests", "", "Lcom/snowplowanalytics/snowplow/network/Request;", "events", "Lcom/snowplowanalytics/snowplow/emitter/EmitterEvent;", "flush", "isOversize", "byteLimit", "previousPayloads", "pauseEmit", "resumeEmit", "shutdown", "timeout", "Companion", "snowplow-android-tracker_release"})
@SourceDebugExtension(value={"SMAP\nEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Emitter.kt\ncom/snowplowanalytics/core/emitter/Emitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,749:1\n1#2:750\n*E\n"})
public final class Emitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String TAG;
    private boolean builderFinished;
    @NotNull
    private final AtomicBoolean isRunning;
    @NotNull
    private final AtomicBoolean isEmittingPaused;
    private boolean isCustomNetworkConnection;
    @NotNull
    private final Context context;
    private String uri;
    private int emptyCount;
    @NotNull
    private TimeUnit timeUnit;
    @Nullable
    private CookieJar cookieJar;
    private int threadPoolSize;
    @Nullable
    private OkHttpClient client;
    @Nullable
    private EventStore eventStore;
    @NotNull
    private EnumSet<TLSVersion> tlsVersions;
    private int emitterTick;
    private int emptyLimit;
    private int sendLimit;
    private long byteLimitGet;
    private long byteLimitPost;
    @Nullable
    private RequestCallback requestCallback;
    @NotNull
    private HttpMethod httpMethod;
    @NotNull
    private BufferOption bufferOption;
    @NotNull
    private Protocol requestSecurity;
    @Nullable
    private String namespace;
    @Nullable
    private Integer emitTimeout;
    @Nullable
    private String customPostPath;
    @NotNull
    private final AtomicReference<NetworkConnection> _networkConnection;
    private boolean serverAnonymisation;
    @NotNull
    private final AtomicReference<Map<Integer, Boolean>> _customRetryForStatusCodes;
    @NotNull
    private final AtomicReference<Boolean> _retryFailedRequests;
    @Nullable
    private Map<String, String> requestHeaders;
    private static final int POST_WRAPPER_BYTES = 88;

    /*
     * WARNING - void declaration
     */
    public Emitter(@NotNull Context context, @NotNull String collectorUri, @Nullable Function1<? super Emitter, Unit> builder2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)collectorUri, (String)"collectorUri");
        this.TAG = Emitter.class.getSimpleName();
        this.isRunning = new AtomicBoolean(false);
        this.isEmittingPaused = new AtomicBoolean(false);
        this.timeUnit = EmitterDefaults.INSTANCE.getTimeUnit();
        this.threadPoolSize = EmitterDefaults.INSTANCE.getThreadPoolSize();
        this.tlsVersions = EmitterDefaults.INSTANCE.getTlsVersions();
        this.emitterTick = EmitterDefaults.INSTANCE.getEmitterTick();
        this.emptyLimit = EmitterDefaults.INSTANCE.getEmptyLimit();
        this.sendLimit = EmitterDefaults.INSTANCE.getSendLimit();
        this.byteLimitGet = EmitterDefaults.INSTANCE.getByteLimitGet();
        this.byteLimitPost = EmitterDefaults.INSTANCE.getByteLimitPost();
        this.httpMethod = EmitterDefaults.INSTANCE.getHttpMethod();
        this.bufferOption = EmitterDefaults.INSTANCE.getBufferOption();
        this.requestSecurity = EmitterDefaults.INSTANCE.getHttpProtocol();
        this.emitTimeout = EmitterDefaults.INSTANCE.getEmitTimeout();
        this._networkConnection = new AtomicReference();
        this.serverAnonymisation = EmitterDefaults.INSTANCE.getServerAnonymisation();
        this._customRetryForStatusCodes = new AtomicReference();
        this._retryFailedRequests = new AtomicReference<Boolean>(EmitterDefaults.INSTANCE.getRetryFailedRequests());
        this.context = context;
        Function1<? super Emitter, Unit> function1 = builder2;
        if (function1 != null) {
            Function1<? super Emitter, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)this);
        }
        if (this.getNetworkConnection() == null) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            this.isCustomNetworkConnection = false;
            String endpoint = null;
            endpoint = collectorUri;
            if (!StringsKt.startsWith$default((String)endpoint, (String)"http", (boolean)false, (int)2, null)) {
                String protocol = this.requestSecurity == Protocol.HTTPS ? "https://" : "http://";
                endpoint = protocol + endpoint;
            }
            this.uri = endpoint;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(endpoint, context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        } else {
            this.isCustomNetworkConnection = true;
        }
        if (this.threadPoolSize > 2) {
            Executor.setThreadCount(this.threadPoolSize);
        }
        this.builderFinished = true;
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Emitter created successfully!", new Object[0]);
    }

    public /* synthetic */ Emitter(Context context, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(context, string, (Function1<? super Emitter, Unit>)function1);
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public final void setTimeUnit(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!this.builderFinished) {
            this.timeUnit = unit;
        }
    }

    @Nullable
    public final CookieJar getCookieJar() {
        return this.cookieJar;
    }

    public final void setCookieJar(@Nullable CookieJar cookieJar) {
        if (!this.builderFinished) {
            this.cookieJar = cookieJar;
        }
    }

    public final int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public final void setThreadPoolSize(int poolSize) {
        if (!this.builderFinished) {
            this.threadPoolSize = poolSize;
        }
    }

    @Nullable
    public final OkHttpClient getClient() {
        return this.client;
    }

    public final void setClient(@Nullable OkHttpClient client) {
        if (!this.builderFinished) {
            this.client = client;
        }
    }

    @Nullable
    public final EventStore getEventStore() {
        return this.eventStore;
    }

    public final void setEventStore(@Nullable EventStore eventStore) {
        if (this.eventStore == null) {
            this.eventStore = eventStore;
        }
    }

    @NotNull
    public final EnumSet<TLSVersion> getTlsVersions() {
        return this.tlsVersions;
    }

    public final void setTlsVersions(@NotNull EnumSet<TLSVersion> enumSet) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
        this.tlsVersions = enumSet;
    }

    public final int getEmitterTick() {
        return this.emitterTick;
    }

    public final void setEmitterTick(int n) {
        this.emitterTick = n;
    }

    public final int getEmptyLimit() {
        return this.emptyLimit;
    }

    public final void setEmptyLimit(int n) {
        this.emptyLimit = n;
    }

    public final int getSendLimit() {
        return this.sendLimit;
    }

    public final void setSendLimit(int n) {
        this.sendLimit = n;
    }

    public final long getByteLimitGet() {
        return this.byteLimitGet;
    }

    public final void setByteLimitGet(long l) {
        this.byteLimitGet = l;
    }

    public final long getByteLimitPost() {
        return this.byteLimitPost;
    }

    public final void setByteLimitPost(long l) {
        this.byteLimitPost = l;
    }

    @Nullable
    public final RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public final void setRequestCallback(@Nullable RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public final boolean getEmitterStatus() {
        return this.isRunning.get();
    }

    @NotNull
    public final String getEmitterUri() {
        NetworkConnection networkConnection = this.getNetworkConnection();
        return String.valueOf(networkConnection != null ? networkConnection.getUri() : null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setEmitterUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(uri, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    @NotNull
    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHttpMethod(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.httpMethod = method;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    @NotNull
    public final BufferOption getBufferOption() {
        return this.bufferOption;
    }

    public final void setBufferOption(@NotNull BufferOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        if (!this.isRunning.get()) {
            this.bufferOption = option;
        }
    }

    @NotNull
    public final Protocol getRequestSecurity() {
        return this.requestSecurity;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequestSecurity(@NotNull Protocol security) {
        Intrinsics.checkNotNullParameter((Object)((Object)security), (String)"security");
        this.requestSecurity = security;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
        if (this.eventStore == null) {
            SQLiteEventStore sQLiteEventStore;
            Emitter emitter = this;
            String string = this.namespace;
            if (string != null) {
                void it;
                String string2 = string;
                Emitter emitter2 = emitter;
                boolean bl = false;
                sQLiteEventStore = new SQLiteEventStore(this.context, (String)it);
                emitter = emitter2;
            } else {
                sQLiteEventStore = null;
            }
            emitter.setEventStore(sQLiteEventStore);
        }
    }

    @Nullable
    public final Integer getEmitTimeout() {
        return this.emitTimeout;
    }

    public final void setEmitTimeout(@Nullable Integer emitTimeout) {
        block2: {
            Integer n = emitTimeout;
            if (n == null) break block2;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.emitTimeout = emitTimeout;
            if (!this.isCustomNetworkConnection && this.builderFinished) {
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                this.setNetworkConnection(new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout(emitTimeout).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build());
            }
        }
    }

    @Nullable
    public final String getCustomPostPath() {
        return this.customPostPath;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCustomPostPath(@Nullable String customPostPath) {
        this.customPostPath = customPostPath;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    @Nullable
    public final NetworkConnection getNetworkConnection() {
        return this._networkConnection.get();
    }

    public final void setNetworkConnection(@Nullable NetworkConnection value) {
        this._networkConnection.set(value);
    }

    public final boolean getServerAnonymisation() {
        return this.serverAnonymisation;
    }

    /*
     * WARNING - void declaration
     */
    public final void setServerAnonymisation(boolean serverAnonymisation) {
        this.serverAnonymisation = serverAnonymisation;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(serverAnonymisation).requestHeaders(this.requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    @Nullable
    public final Map<Integer, Boolean> getCustomRetryForStatusCodes() {
        return this._customRetryForStatusCodes.get();
    }

    public final void setCustomRetryForStatusCodes(@Nullable Map<Integer, Boolean> value) {
        Map map = value;
        if (map == null) {
            map = new HashMap();
        }
        this._customRetryForStatusCodes.set(map);
    }

    public final boolean getRetryFailedRequests() {
        Boolean bl = this._retryFailedRequests.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"_retryFailedRequests.get()");
        return bl;
    }

    public final void setRetryFailedRequests(boolean value) {
        this._retryFailedRequests.set(value);
    }

    @Nullable
    public final Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequestHeaders(@Nullable Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
        if (!this.isCustomNetworkConnection && this.builderFinished) {
            OkHttpNetworkConnection okHttpNetworkConnection;
            Emitter emitter = this;
            Integer n = this.emitTimeout;
            if (n != null) {
                void it;
                int n2 = ((Number)n).intValue();
                Emitter emitter2 = emitter;
                boolean bl = false;
                String string = this.uri;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                    string = null;
                }
                okHttpNetworkConnection = new OkHttpNetworkConnection.OkHttpNetworkConnectionBuilder(string, this.context).method(this.httpMethod).tls(this.tlsVersions).emitTimeout((int)it).customPostPath(this.customPostPath).client(this.client).cookieJar(this.cookieJar).serverAnonymisation(this.serverAnonymisation).requestHeaders(requestHeaders).build();
                emitter = emitter2;
            } else {
                okHttpNetworkConnection = null;
            }
            emitter.setNetworkConnection(okHttpNetworkConnection);
        }
    }

    public final void add(@NotNull Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Executor.execute(this.TAG, () -> Emitter.add$lambda$10(this, payload));
    }

    public final void flush() {
        Executor.execute(this.TAG, () -> Emitter.flush$lambda$11(this));
    }

    public final void pauseEmit() {
        this.isEmittingPaused.set(true);
    }

    public final void resumeEmit() {
        if (this.isEmittingPaused.compareAndSet(true, false)) {
            this.flush();
        }
    }

    public final void shutdown() {
        this.shutdown(0L);
    }

    public final boolean shutdown(long timeout) {
        boolean bl;
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.d(string, "Shutting down emitter.", new Object[0]);
        this.isRunning.compareAndSet(true, false);
        ExecutorService es = Executor.shutdown();
        if (es == null || timeout <= 0L) {
            bl = true;
        } else {
            boolean bl2;
            try {
                boolean isTerminated = es.awaitTermination(timeout, TimeUnit.SECONDS);
                String string2 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Logger.d(string2, "Executor is terminated: " + isTerminated, new Object[0]);
                bl2 = isTerminated;
            }
            catch (InterruptedException e) {
                String string3 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                Logger.e(string3, "Executor termination is interrupted: " + e.getMessage(), new Object[0]);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void attemptEmit(NetworkConnection networkConnection) {
        if (this.isEmittingPaused.get()) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Emitter paused.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        if (!Util.isOnline(this.context)) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "Emitter loop stopping: emitter offline.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        if (this.eventStore == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "No EventStore set.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        EventStore eventStore = this.eventStore;
        if (eventStore == null) {
            return;
        }
        EventStore eventStore2 = eventStore;
        if (networkConnection == null) {
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.d(string, "No networkConnection set.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
            return;
        }
        if (eventStore2.size() <= 0L) {
            if (this.emptyCount >= this.emptyLimit) {
                String string = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.d(string, "Emitter loop stopping: empty limit reached.", new Object[0]);
                this.isRunning.compareAndSet(true, false);
                return;
            }
            int n = this.emptyCount;
            this.emptyCount = n + 1;
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.e(string, "Emitter database empty: " + this.emptyCount, new Object[0]);
            try {
                this.timeUnit.sleep(this.emitterTick);
            }
            catch (InterruptedException e) {
                String string2 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                Logger.e(string2, "Emitter thread sleep interrupted: " + e, new Object[0]);
            }
            this.attemptEmit(networkConnection);
            return;
        }
        this.emptyCount = 0;
        List<EmitterEvent> events = eventStore2.getEmittableEvents(this.sendLimit);
        List<Request> requests = this.buildRequests(events, networkConnection.getHttpMethod());
        List<RequestResult> results = networkConnection.sendRequests(requests);
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Logger.v(string, "Processing emitter results.", new Object[0]);
        int successCount = 0;
        int failedWillRetryCount = 0;
        int failedWontRetryCount = 0;
        List removableEvents = new ArrayList();
        for (RequestResult res : results) {
            if (res.isSuccessful()) {
                removableEvents.addAll((Collection)res.getEventIds());
                successCount += res.getEventIds().size();
                continue;
            }
            if (res.shouldRetry(this.getCustomRetryForStatusCodes(), this.getRetryFailedRequests())) {
                failedWillRetryCount += res.getEventIds().size();
                String string3 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                Logger.e(string3, "Request sending failed but we will retry later.", new Object[0]);
                continue;
            }
            failedWontRetryCount += res.getEventIds().size();
            removableEvents.addAll((Collection)res.getEventIds());
            String string4 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            String string5 = "Sending events to Collector failed with status %d. Events will be dropped.";
            Object[] objectArray = new Object[]{res.getStatusCode()};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
            Logger.e(string4, string6, new Object[0]);
        }
        eventStore2.removeEvents(removableEvents);
        int allFailureCount = failedWillRetryCount + failedWontRetryCount;
        String string7 = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"TAG");
        Object[] objectArray = new Object[]{successCount};
        Logger.d(string7, "Success Count: %s", objectArray);
        String string8 = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"TAG");
        objectArray = new Object[]{allFailureCount};
        Logger.d(string8, "Failure Count: %s", objectArray);
        if (this.requestCallback != null) {
            if (allFailureCount != 0) {
                RequestCallback requestCallback = this.requestCallback;
                if (requestCallback != null) {
                    requestCallback.onFailure(successCount, allFailureCount);
                }
            } else {
                RequestCallback requestCallback = this.requestCallback;
                if (requestCallback != null) {
                    requestCallback.onSuccess(successCount);
                }
            }
        }
        if (failedWillRetryCount > 0 && successCount == 0) {
            if (Util.isOnline(this.context)) {
                String string9 = this.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"TAG");
                objectArray = new Object[]{networkConnection.getUri()};
                Logger.e(string9, "Ensure collector path is valid: %s", objectArray);
            }
            String string10 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"TAG");
            Logger.e(string10, "Emitter loop stopping: failures.", new Object[0]);
            this.isRunning.compareAndSet(true, false);
        } else {
            this.attemptEmit(networkConnection);
        }
    }

    private final List<Request> buildRequests(List<EmitterEvent> events, HttpMethod httpMethod) {
        List requests = new ArrayList();
        String sendingTime = Util.timestamp();
        if (httpMethod == HttpMethod.GET) {
            Iterator<EmitterEvent> iterator = events.iterator();
            while (iterator.hasNext()) {
                EmitterEvent event;
                EmitterEvent emitterEvent = event = iterator.next();
                Payload payload = emitterEvent != null ? emitterEvent.getPayload() : null;
                if (payload == null) continue;
                this.addSendingTimeToPayload(payload, sendingTime);
                boolean isOversize = this.isOversize(payload, httpMethod);
                Request request = new Request(payload, event.getEventId(), isOversize);
                requests.add(request);
            }
        } else {
            for (int i = 0; i < events.size(); i += this.bufferOption.getCode()) {
                List reqEventIds = new ArrayList();
                List postPayloadMaps = new ArrayList();
                int j = i;
                while (j < i + this.bufferOption.getCode() && j < events.size()) {
                    Request request;
                    Long eventId;
                    EmitterEvent event;
                    EmitterEvent emitterEvent = event = events.get(j);
                    Payload payload = emitterEvent != null ? emitterEvent.getPayload() : null;
                    EmitterEvent emitterEvent2 = event;
                    Long l = eventId = emitterEvent2 != null ? Long.valueOf(emitterEvent2.getEventId()) : null;
                    if (payload == null || eventId == null) continue;
                    this.addSendingTimeToPayload(payload, sendingTime);
                    if (this.isOversize(payload, httpMethod)) {
                        request = new Request(payload, eventId, true);
                        requests.add(request);
                    } else if (this.isOversize(payload, postPayloadMaps, httpMethod)) {
                        request = new Request(postPayloadMaps, reqEventIds);
                        requests.add(request);
                        postPayloadMaps = new ArrayList();
                        reqEventIds = new ArrayList();
                        postPayloadMaps.add(payload);
                        reqEventIds.add(eventId);
                    } else {
                        postPayloadMaps.add(payload);
                        reqEventIds.add(eventId);
                    }
                    ++j;
                }
                if (!(!((Collection)postPayloadMaps).isEmpty())) continue;
                Request request = new Request(postPayloadMaps, reqEventIds);
                requests.add(request);
            }
        }
        return requests;
    }

    private final boolean isOversize(Payload payload, HttpMethod httpMethod) {
        return this.isOversize(payload, new ArrayList(), httpMethod);
    }

    private final boolean isOversize(Payload payload, List<? extends Payload> previousPayloads, HttpMethod httpMethod) {
        long byteLimit = httpMethod == HttpMethod.GET ? this.byteLimitGet : this.byteLimitPost;
        return this.isOversize(payload, byteLimit, previousPayloads);
    }

    private final boolean isOversize(Payload payload, long byteLimit, List<? extends Payload> previousPayloads) {
        long totalByteSize = payload.getByteSize();
        for (Payload payload2 : previousPayloads) {
            totalByteSize += payload2.getByteSize();
        }
        int wrapperBytes = !((Collection)previousPayloads).isEmpty() ? previousPayloads.size() + 88 : 0;
        return totalByteSize + (long)wrapperBytes > byteLimit;
    }

    private final void addSendingTimeToPayload(Payload payload, String timestamp) {
        payload.add("stm", timestamp);
    }

    private static final void add$lambda$10(Emitter this$0, Payload $payload) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        EventStore eventStore = this$0.eventStore;
        if (eventStore != null) {
            eventStore.add($payload);
        }
        if (this$0.isRunning.compareAndSet(false, true)) {
            try {
                this$0.attemptEmit(this$0.getNetworkConnection());
            }
            catch (Throwable t) {
                this$0.isRunning.set(false);
                String string = this$0.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Object[] objectArray = new Object[]{t};
                Logger.e(string, "Received error during emission process: %s", objectArray);
            }
        }
    }

    private static final void flush$lambda$11(Emitter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isRunning.compareAndSet(false, true)) {
            try {
                this$0.attemptEmit(this$0.getNetworkConnection());
            }
            catch (Throwable t) {
                this$0.isRunning.set(false);
                String string = this$0.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Object[] objectArray = new Object[]{t};
                Logger.e(string, "Received error during emission process: %s", objectArray);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/snowplowanalytics/core/emitter/Emitter$Companion;", "", "()V", "POST_WRAPPER_BYTES", "", "snowplow-android-tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

