/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.PublicPreview;
import com.snowflake.snowpark.Row;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.AsyncJob;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.DataFrameReader;
import com.snowflake.snowpark_java.FileOperation;
import com.snowflake.snowpark_java.SProcRegistration;
import com.snowflake.snowpark_java.SessionBuilder;
import com.snowflake.snowpark_java.StoredProcedure;
import com.snowflake.snowpark_java.TableFunction;
import com.snowflake.snowpark_java.UDFRegistration;
import com.snowflake.snowpark_java.UDTFRegistration;
import com.snowflake.snowpark_java.Updatable;
import com.snowflake.snowpark_java.types.InternalUtils;
import com.snowflake.snowpark_java.types.StructType;
import java.net.URI;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import scala.Option;

public class Session {
    private final com.snowflake.snowpark.Session session;
    private UDFRegistration udf = null;
    private UDTFRegistration udtf = null;
    private SProcRegistration sproc = null;

    Session(com.snowflake.snowpark.Session session) {
        this.session = session;
    }

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    public DataFrame sql(String query) {
        return new DataFrame(this.session.sql(query));
    }

    public Updatable table(String name) {
        return new Updatable(this.session.table(name));
    }

    public Updatable table(String[] multipartIdentifier) {
        return new Updatable(this.session.table(multipartIdentifier));
    }

    public DataFrame range(long end) {
        return new DataFrame(this.session.range(end));
    }

    public DataFrame range(long start, long end, long step) {
        return new DataFrame(this.session.range(start, end, step));
    }

    public DataFrame range(long start, long end) {
        return new DataFrame(this.session.range(start, end));
    }

    public DataFrame createDataFrame(com.snowflake.snowpark_java.Row[] data, StructType schema) {
        Row[] scalaRows = new Row[data.length];
        for (int i = 0; i < data.length; ++i) {
            scalaRows[i] = data[i].getScalaRow();
        }
        return new DataFrame(this.session.createDataFrame(scalaRows, InternalUtils.toScalaStructType(schema)));
    }

    public UDFRegistration udf() {
        if (this.udf == null) {
            this.udf = new UDFRegistration(this.session.udf());
        }
        return this.udf;
    }

    public UDTFRegistration udtf() {
        if (this.udtf == null) {
            this.udtf = new UDTFRegistration(this.session.udtf());
        }
        return this.udtf;
    }

    public void removeDependency(String path) {
        this.session.removeDependency(path);
    }

    public void addDependency(String path) {
        this.session.addDependency(path);
    }

    public Set<URI> getDependencies() {
        return this.session.getDependenciesAsJavaSet();
    }

    public void cancelAll() {
        this.session.cancelAll();
    }

    public Connection jdbcConnection() {
        return this.session.jdbcConnection();
    }

    public void setQueryTag(String queryTag) {
        this.session.setQueryTag(queryTag);
    }

    public void unsetQueryTag() {
        this.session.unsetQueryTag();
    }

    public DataFrame generator(long rowCount, Column ... columns) {
        return new DataFrame(this.session.generator(rowCount, JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(columns))));
    }

    public Optional<String> getDefaultDatabase() {
        Option<String> result = this.session.getDefaultDatabase();
        if (result.isDefined()) {
            return Optional.of((String)result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getDefaultSchema() {
        Option<String> result = this.session.getDefaultSchema();
        if (result.isDefined()) {
            return Optional.of((String)result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getCurrentDatabase() {
        Option<String> result = this.session.getCurrentDatabase();
        if (result.isDefined()) {
            return Optional.of((String)result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getCurrentSchema() {
        Option<String> result = this.session.getCurrentSchema();
        if (result.isDefined()) {
            return Optional.of((String)result.get());
        }
        return Optional.empty();
    }

    public String getFullyQualifiedCurrentSchema() {
        return this.session.getFullyQualifiedCurrentSchema();
    }

    public Optional<String> getQueryTag() {
        Option<String> result = this.session.getQueryTag();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((String)result.get());
    }

    public String getSessionStage() {
        return this.session.getSessionStage();
    }

    public DataFrame flatten(Column input) {
        return new DataFrame(this.session.flatten(input.toScalaColumn()));
    }

    public DataFrame flatten(Column input, String path, boolean outer, boolean recursive, String mode) {
        return new DataFrame(this.session.flatten(input.toScalaColumn(), path, outer, recursive, mode));
    }

    public void close() {
        this.session.close();
    }

    public String getSessionInfo() {
        return this.session.getSessionInfo();
    }

    public DataFrameReader read() {
        return new DataFrameReader(this.session.read());
    }

    public FileOperation file() {
        return new FileOperation(this.session.file());
    }

    public DataFrame tableFunction(TableFunction func, Column ... args) {
        return new DataFrame(this.session.tableFunction(func.getScalaTableFunction(), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(args))));
    }

    public DataFrame tableFunction(TableFunction func, Map<String, Column> args) {
        HashMap<String, com.snowflake.snowpark.Column> scalaArgs = new HashMap<String, com.snowflake.snowpark.Column>();
        for (Map.Entry<String, Column> entry : args.entrySet()) {
            scalaArgs.put(entry.getKey(), entry.getValue().toScalaColumn());
        }
        return new DataFrame(this.session.tableFunction(func.getScalaTableFunction(), JavaUtils.javaStringColumnMapToScala(scalaArgs)));
    }

    @PublicPreview
    public SProcRegistration sproc() {
        if (this.sproc == null) {
            this.sproc = new SProcRegistration(this, this.session.sproc());
        }
        return this.sproc;
    }

    @PublicPreview
    public DataFrame storedProcedure(String spName, Object ... args) {
        return new DataFrame(this.session.storedProcedure(spName, JavaUtils.objectArrayToSeq(args)));
    }

    @PublicPreview
    public DataFrame storedProcedure(StoredProcedure sp2, Object ... args) {
        return new DataFrame(this.session.storedProcedure(sp2.sp, JavaUtils.objectArrayToSeq(args)));
    }

    public AsyncJob createAsyncJob(String queryID) {
        return new AsyncJob(this.session.createAsyncJob(queryID), this.session);
    }

    com.snowflake.snowpark.Session getScalaSession() {
        return this.session;
    }
}

