/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.types;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.types.ArrayType;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.ByteType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.FloatType$;
import com.snowflake.snowpark.types.GeographyType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.MapType;
import com.snowflake.snowpark.types.ShortType$;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.TimeType$;
import com.snowflake.snowpark.types.TimestampType$;
import com.snowflake.snowpark.types.VariantType$;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toJavaType(DataType datatype) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = datatype;
        if (ShortType$.MODULE$.equals(dataType2)) {
            return Short.class.getCanonicalName();
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return Integer.class.getCanonicalName();
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return Long.class.getCanonicalName();
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return Double.class.getCanonicalName();
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return Float.class.getCanonicalName();
        }
        if (dataType2 instanceof DecimalType) {
            return BigDecimal.class.getCanonicalName();
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return Boolean.class.getCanonicalName();
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return Date.class.getCanonicalName();
        }
        if (TimeType$.MODULE$.equals(dataType2)) {
            return Time.class.getCanonicalName();
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return Timestamp.class.getCanonicalName();
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return "byte[]";
        }
        if (dataType2 instanceof ArrayType && StringType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return "String[]";
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType dataType4 = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType3) && StringType$.MODULE$.equals(dataType4)) {
                return "java.util.Map<String,String>";
            }
        }
        if (GeographyType$.MODULE$.equals(dataType2)) {
            return "Geography";
        }
        if (!VariantType$.MODULE$.equals(dataType2)) throw new UnsupportedOperationException(new StringBuilder(29).append(datatype.toString()).append(" not supported for scala UDFs").toString());
        return "Variant";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toUDFArgumentType(DataType datatype) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = datatype;
        if (GeographyType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            return String.class.getCanonicalName();
        }
        if (dataType2 instanceof ArrayType && VariantType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return "String[]";
        }
        if (!(dataType2 instanceof MapType)) return this.toJavaType(datatype);
        MapType mapType = (MapType)dataType2;
        DataType dataType3 = mapType.keyType();
        DataType dataType4 = mapType.valueType();
        if (!StringType$.MODULE$.equals(dataType3)) return this.toJavaType(datatype);
        if (!VariantType$.MODULE$.equals(dataType4)) return this.toJavaType(datatype);
        return "java.util.Map<String,String>";
    }

    public String convertToSFType(DataType dataType) {
        String string;
        DataType dataType2 = dataType;
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            string = new StringBuilder(10).append("NUMBER(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString();
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            string = "INT";
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            string = "SMALLINT";
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            string = "BYTEINT";
        } else if (LongType$.MODULE$.equals(dataType2)) {
            string = "BIGINT";
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            string = "FLOAT";
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            string = "DOUBLE";
        } else if (StringType$.MODULE$.equals(dataType2)) {
            string = "STRING";
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            string = "BOOLEAN";
        } else if (DateType$.MODULE$.equals(dataType2)) {
            string = "DATE";
        } else if (TimeType$.MODULE$.equals(dataType2)) {
            string = "TIME";
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            string = "TIMESTAMP";
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            string = "BINARY";
        } else if (dataType2 instanceof ArrayType) {
            string = "ARRAY";
        } else if (dataType2 instanceof MapType) {
            string = "OBJECT";
        } else if (VariantType$.MODULE$.equals(dataType2)) {
            string = "VARIANT";
        } else if (GeographyType$.MODULE$.equals(dataType2)) {
            string = "GEOGRAPHY";
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dataType.typeName()).toString());
        }
        return string;
    }

    public DataType javaTypeToDataType(Class<?> cls) {
        DataType dataType;
        String className = cls.getCanonicalName();
        String string = className;
        boolean bl = "short".equals(string) ? true : "java.lang.Short".equals(string);
        if (bl) {
            dataType = ShortType$.MODULE$;
        } else {
            boolean bl2 = "int".equals(string) ? true : "java.lang.Integer".equals(string);
            if (bl2) {
                dataType = IntegerType$.MODULE$;
            } else {
                boolean bl3 = "long".equals(string) ? true : "java.lang.Long".equals(string);
                if (bl3) {
                    dataType = LongType$.MODULE$;
                } else {
                    boolean bl4 = "float".equals(string) ? true : "java.lang.Float".equals(string);
                    if (bl4) {
                        dataType = FloatType$.MODULE$;
                    } else {
                        boolean bl5 = "double".equals(string) ? true : "java.lang.Double".equals(string);
                        if (bl5) {
                            dataType = DoubleType$.MODULE$;
                        } else if ("java.math.BigDecimal".equals(string)) {
                            dataType = new DecimalType(38, 18);
                        } else {
                            boolean bl6 = "boolean".equals(string) ? true : "java.lang.Boolean".equals(string);
                            if (bl6) {
                                dataType = BooleanType$.MODULE$;
                            } else if ("java.lang.String".equals(string)) {
                                dataType = StringType$.MODULE$;
                            } else if ("byte[]".equals(string)) {
                                dataType = BinaryType$.MODULE$;
                            } else if ("java.sql.Date".equals(string)) {
                                dataType = DateType$.MODULE$;
                            } else if ("java.sql.Time".equals(string)) {
                                dataType = TimeType$.MODULE$;
                            } else if ("java.sql.Timestamp".equals(string)) {
                                dataType = TimestampType$.MODULE$;
                            } else if ("com.snowflake.snowpark_java.types.Variant".equals(string)) {
                                dataType = VariantType$.MODULE$;
                            } else if ("java.lang.String[]".equals(string)) {
                                dataType = new ArrayType(StringType$.MODULE$);
                            } else if ("com.snowflake.snowpark_java.types.Variant[]".equals(string)) {
                                dataType = new ArrayType(VariantType$.MODULE$);
                            } else {
                                if ("java.util.Map".equals(string)) {
                                    throw ErrorMessage$.MODULE$.UDF_CANNOT_INFER_MAP_TYPES();
                                }
                                throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(className).toString());
                            }
                        }
                    }
                }
            }
        }
        return dataType;
    }

    private package$() {
        MODULE$ = this;
    }
}

