/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.MergeResult;
import com.snowflake.snowpark.Row;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.UpdateResult;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.AsyncJob;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.DeleteResult;
import com.snowflake.snowpark_java.WriteFileResult;
import scala.collection.Iterator;

public class TypedAsyncJob<T>
extends AsyncJob {
    private final com.snowflake.snowpark.TypedAsyncJob<?> typedJob;
    private final AsyncJobDataType type;

    private TypedAsyncJob(com.snowflake.snowpark.TypedAsyncJob<?> typedJob, Session session, AsyncJobDataType type) {
        super(typedJob, session);
        this.typedJob = typedJob;
        this.type = type;
    }

    public T getResult(int maxWaitTimeInSeconds) {
        Object result = this.typedJob.getResult(maxWaitTimeInSeconds);
        return this.toJavaResult(result);
    }

    public T getResult() {
        return this.getResult(JavaUtils.session_requestTimeoutInSeconds(this.session));
    }

    private T toJavaResult(Object scalaResult) {
        switch (this.type) {
            case ArrayOfRow: {
                assert (scalaResult instanceof Row[]);
                Row[] rows = (Row[])scalaResult;
                com.snowflake.snowpark_java.Row[] javaResult = new com.snowflake.snowpark_java.Row[rows.length];
                for (int i = 0; i < javaResult.length; ++i) {
                    javaResult[i] = new com.snowflake.snowpark_java.Row(rows[i]);
                }
                return (T)javaResult;
            }
            case IteratorOfRow: {
                assert (scalaResult instanceof Iterator);
                return (T)DataFrame.toJavaIterator((Iterator<Row>)((Iterator)scalaResult));
            }
            case Long: {
                assert (scalaResult instanceof Long);
                return (T)scalaResult;
            }
            case Void: {
                return null;
            }
            case UpdateResult: {
                assert (scalaResult instanceof UpdateResult);
                return (T)new com.snowflake.snowpark_java.UpdateResult((UpdateResult)scalaResult);
            }
            case DeleteResult: {
                assert (scalaResult instanceof com.snowflake.snowpark.DeleteResult);
                return (T)new DeleteResult((com.snowflake.snowpark.DeleteResult)scalaResult);
            }
            case MergeResult: {
                assert (scalaResult instanceof MergeResult);
                return (T)new com.snowflake.snowpark_java.MergeResult((MergeResult)scalaResult);
            }
            case WriteFileResult: {
                assert (scalaResult instanceof com.snowflake.snowpark.WriteFileResult);
                return (T)new WriteFileResult((com.snowflake.snowpark.WriteFileResult)scalaResult);
            }
        }
        throw new RuntimeException("Unexpected DataType");
    }

    static TypedAsyncJob<com.snowflake.snowpark_java.Row[]> createRowArrayJob(com.snowflake.snowpark.TypedAsyncJob<Row[]> job, Session session) {
        return new TypedAsyncJob<com.snowflake.snowpark_java.Row[]>(job, session, AsyncJobDataType.ArrayOfRow);
    }

    static TypedAsyncJob<java.util.Iterator<com.snowflake.snowpark_java.Row>> createRowIteratorJob(com.snowflake.snowpark.TypedAsyncJob<Iterator<Row>> job, Session session) {
        return new TypedAsyncJob<java.util.Iterator<com.snowflake.snowpark_java.Row>>(job, session, AsyncJobDataType.IteratorOfRow);
    }

    static TypedAsyncJob<Long> createLongJob(com.snowflake.snowpark.TypedAsyncJob<Object> job, Session session) {
        return new TypedAsyncJob<Long>(job, session, AsyncJobDataType.Long);
    }

    static TypedAsyncJob<Void> createVoidJob(com.snowflake.snowpark.TypedAsyncJob<?> job, Session session) {
        return new TypedAsyncJob<Void>(job, session, AsyncJobDataType.Void);
    }

    static TypedAsyncJob<com.snowflake.snowpark_java.UpdateResult> createUpdateResultJob(com.snowflake.snowpark.TypedAsyncJob<UpdateResult> job, Session session) {
        return new TypedAsyncJob<com.snowflake.snowpark_java.UpdateResult>(job, session, AsyncJobDataType.UpdateResult);
    }

    static TypedAsyncJob<DeleteResult> createDeleteResultJob(com.snowflake.snowpark.TypedAsyncJob<com.snowflake.snowpark.DeleteResult> job, Session session) {
        return new TypedAsyncJob<DeleteResult>(job, session, AsyncJobDataType.DeleteResult);
    }

    static TypedAsyncJob<com.snowflake.snowpark_java.MergeResult> createMergeResultJob(com.snowflake.snowpark.TypedAsyncJob<MergeResult> job, Session session) {
        return new TypedAsyncJob<com.snowflake.snowpark_java.MergeResult>(job, session, AsyncJobDataType.MergeResult);
    }

    static TypedAsyncJob<WriteFileResult> createWriteFileResultJob(com.snowflake.snowpark.TypedAsyncJob<com.snowflake.snowpark.WriteFileResult> job, Session session) {
        return new TypedAsyncJob<WriteFileResult>(job, session, AsyncJobDataType.WriteFileResult);
    }

    private static enum AsyncJobDataType {
        ArrayOfRow,
        IteratorOfRow,
        Long,
        Void,
        UpdateResult,
        DeleteResult,
        MergeResult,
        WriteFileResult;

    }
}

