/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.PublicPreview;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.TypedAsyncJob;
import com.snowflake.snowpark_java.WriteFileResult;

public class DataFrameWriterAsyncActor {
    private final com.snowflake.snowpark.DataFrameWriterAsyncActor asyncActor;
    private final Session session;

    DataFrameWriterAsyncActor(com.snowflake.snowpark.DataFrameWriterAsyncActor asyncActor, Session session) {
        this.asyncActor = asyncActor;
        this.session = session;
    }

    public TypedAsyncJob<Void> saveAsTable(String tableName) {
        return TypedAsyncJob.createVoidJob(this.asyncActor.saveAsTable(tableName), this.session);
    }

    public TypedAsyncJob<Void> saveAsTable(String[] multipartIdentifier) {
        return TypedAsyncJob.createVoidJob(this.asyncActor.saveAsTable(JavaUtils.stringArrayToStringSeq(multipartIdentifier)), this.session);
    }

    @PublicPreview
    public TypedAsyncJob<WriteFileResult> csv(String path) {
        return TypedAsyncJob.createWriteFileResultJob(this.asyncActor.csv(path), this.session);
    }

    @PublicPreview
    public TypedAsyncJob<WriteFileResult> json(String path) {
        return TypedAsyncJob.createWriteFileResultJob(this.asyncActor.json(path), this.session);
    }

    @PublicPreview
    public TypedAsyncJob<WriteFileResult> parquet(String path) {
        return TypedAsyncJob.createWriteFileResultJob(this.asyncActor.parquet(path), this.session);
    }
}

