/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.Row;
import java.util.Iterator;

public class AsyncJob {
    com.snowflake.snowpark.AsyncJob job;
    Session session;

    AsyncJob(com.snowflake.snowpark.AsyncJob job, Session session) {
        this.job = job;
        this.session = session;
    }

    public String getQueryId() {
        return this.job.getQueryId();
    }

    public Iterator<Row> getIterator(int maxWaitTimeInSeconds) {
        return DataFrame.toJavaIterator(this.job.getIterator(maxWaitTimeInSeconds));
    }

    public Iterator<Row> getIterator() {
        return this.getIterator(JavaUtils.session_requestTimeoutInSeconds(this.session));
    }

    public Row[] getRows(int maxWaitTimeInSeconds) {
        com.snowflake.snowpark.Row[] results = this.job.getRows(maxWaitTimeInSeconds);
        Row[] rows = new Row[results.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = new Row(results[i]);
        }
        return rows;
    }

    public Row[] getRows() {
        return this.getRows(JavaUtils.session_requestTimeoutInSeconds(this.session));
    }

    public boolean isDone() {
        return this.job.isDone();
    }

    public void cancel() {
        this.job.cancel();
    }
}

