/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.Utils$;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$;
import com.snowflake.snowpark.types.StructType;
import com.snowflake.snowpark.types.VariantType$;
import java.io.Serializable;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055g!\u0002\u0016,\u0001=*\u0004\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\nuB\u0001B\u0011\u0001\u0003\u0002\u0004%\ta\u0011\u0005\t)\u0002\u0011\t\u0019!C\u0001+\"AA\f\u0001B\u0001B\u0003&A\t\u0003\u0005^\u0001\t\u0005\r\u0011\"\u0001_\u0011!y\u0006A!a\u0001\n\u0003\u0001\u0007\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0015B)\t\u0011\r\u0004!\u00111A\u0005\u0002yC\u0001\u0002\u001a\u0001\u0003\u0002\u0004%\t!\u001a\u0005\tO\u0002\u0011\t\u0011)Q\u0005#\"A\u0001\u000e\u0001BA\u0002\u0013\u0005a\f\u0003\u0005j\u0001\t\u0005\r\u0011\"\u0001k\u0011!a\u0007A!A!B\u0013\t\u0006\u0002C7\u0001\u0005\u0003\u0007I\u0011\u00018\t\u0011a\u0004!\u00111A\u0005\u0002eD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006Ka\u001c\u0005\ty\u0002\u0011\t\u0019!C\u0001{\"Iq\u0010\u0001BA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003\u000b\u0001!\u0011!Q!\nyD!\"a\u0002\u0001\u0005\u0003\u0007I\u0011AA\u0005\u0011)\ti\u0002\u0001BA\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003G\u0001!\u0011!Q!\n\u0005-\u0001BCA\u0013\u0001\t\u0005\r\u0011\"\u0001\u0002(!Q\u00111\u0007\u0001\u0003\u0002\u0004%\t!!\u000e\t\u0015\u0005e\u0002A!A!B\u0013\tI\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005m\u0002\u0001\"\u0001\u0002T!9\u00111\b\u0001\u0005\u0002\u0005]\u0003\"CA/\u0001\t\u0007IQBA0\u0011!\ty\b\u0001Q\u0001\u000e\u0005\u0005\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002*\u0002!\t!a+\t\r5\u0004A\u0011AAX\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a\u0002\u0001\t\u0003\tY\fC\u0004\u0002&\u0001!\t!a0\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\n\u00012\u000b^1hK\u00124\u0015\u000e\\3SK\u0006$WM\u001d\u0006\u0003Y5\n\u0001\"\u00198bYfTXM\u001d\u0006\u0003]=\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003aE\n\u0001b\u001d8poB\f'o\u001b\u0006\u0003eM\n\u0011b\u001d8po\u001ad\u0017m[3\u000b\u0003Q\n1aY8n'\t\u0001a\u0007\u0005\u00028q5\tQ&\u0003\u0002:[\t9Aj\\4hS:<\u0017aB:fgNLwN\\\u0002\u0001+\u0005i\u0004C\u0001 @\u001b\u0005y\u0013B\u0001!0\u0005\u001d\u0019Vm]:j_:\f\u0001b]3tg&|g\u000eI\u0001\u000bGV\u0014x\n\u001d;j_:\u001cX#\u0001#\u0011\t\u0015s\u0015+\u0015\b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S!!S\u001e\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0004\u001b\u0006\u0004(BA'K!\t)%+\u0003\u0002T!\n11\u000b\u001e:j]\u001e\fabY;s\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002W5B\u0011q\u000bW\u0007\u0002\u0015&\u0011\u0011L\u0013\u0002\u0005+:LG\u000fC\u0004\\\t\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\u0006dkJ|\u0005\u000f^5p]N\u0004\u0013!D:uC\u001e,Gj\\2bi&|g.F\u0001R\u0003E\u0019H/Y4f\u0019>\u001c\u0017\r^5p]~#S-\u001d\u000b\u0003-\u0006DqaW\u0004\u0002\u0002\u0003\u0007\u0011+\u0001\bti\u0006<W\rT8dCRLwN\u001c\u0011\u0002\u0015\u0019|'/\\1u)f\u0004X-\u0001\bg_Jl\u0017\r\u001e+za\u0016|F%Z9\u0015\u0005Y3\u0007bB.\u000b\u0003\u0003\u0005\r!U\u0001\fM>\u0014X.\u0019;UsB,\u0007%\u0001\u000bgk2d\u00170U;bY&4\u0017.\u001a3TG\",W.Y\u0001\u0019MVdG._)vC2Lg-[3e'\u000eDW-\\1`I\u0015\fHC\u0001,l\u0011\u001dYV\"!AA\u0002E\u000bQCZ;mYf\fV/\u00197jM&,GmU2iK6\f\u0007%\u0001\u0006vg\u0016\u00148k\u00195f[\u0006,\u0012a\u001c\t\u0004/B\u0014\u0018BA9K\u0005\u0019y\u0005\u000f^5p]B\u00111O^\u0007\u0002i*\u0011QoL\u0001\u0006if\u0004Xm]\u0005\u0003oR\u0014!b\u0015;sk\u000e$H+\u001f9f\u00039)8/\u001a:TG\",W.Y0%KF$\"A\u0016>\t\u000fm\u0003\u0012\u0011!a\u0001_\u0006YQo]3s'\u000eDW-\\1!\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001\u007f!\r9\u0006/U\u0001\u000ei\u0006\u0014G.\u001a(b[\u0016|F%Z9\u0015\u0007Y\u000b\u0019\u0001C\u0004\\'\u0005\u0005\t\u0019\u0001@\u0002\u0015Q\f'\r\\3OC6,\u0007%A\u0006d_2,XN\u001c(b[\u0016\u001cXCAA\u0006!\u0015\ti!a\u0006R\u001d\u0011\ty!a\u0005\u000f\u0007\u001d\u000b\t\"C\u0001L\u0013\r\t)BS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI\"a\u0007\u0003\u0007M+\u0017OC\u0002\u0002\u0016)\u000bqbY8mk6tg*Y7fg~#S-\u001d\u000b\u0004-\u0006\u0005\u0002\u0002C.\u0017\u0003\u0003\u0005\r!a\u0003\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\u0002\u001fQ\u0014\u0018M\\:g_Jl\u0017\r^5p]N,\"!!\u000b\u0011\r\u00055\u0011qCA\u0016!\u0011\ti#a\f\u000e\u0003-J1!!\r,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0014iJ\fgn\u001d4pe6\fG/[8og~#S-\u001d\u000b\u0004-\u0006]\u0002\u0002C.\u001a\u0003\u0003\u0005\r!!\u000b\u0002!Q\u0014\u0018M\\:g_Jl\u0017\r^5p]N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011\u000b\t\u0004\u0003[\u0001\u0001\"\u0002\u001e\u001c\u0001\u0004i\u0004\"\u0002\"\u001c\u0001\u0004!\u0005\"B/\u001c\u0001\u0004\t\u0006\"B2\u001c\u0001\u0004\t\u0006\"\u00025\u001c\u0001\u0004\t\u0006\"B7\u001c\u0001\u0004y\u0007\"\u0002?\u001c\u0001\u0004q\bbBA\u00047\u0001\u0007\u00111\u0002\u0005\b\u0003KY\u0002\u0019AA\u0015)\u0011\ty$!\u0016\t\u000bib\u0002\u0019A\u001f\u0015\t\u0005}\u0012\u0011\f\u0005\b\u00037j\u0002\u0019AA \u0003A\u0019H/Y4fI\u001aKG.\u001a*fC\u0012,'/\u0001\ntkB\u0004xN\u001d;fI\u001aKG.\u001a+za\u0016\u001cXCAA1!\u0019\t\u0019'!\u001c\u0002r5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005j[6,H/\u00192mK*\u0019\u00111\u000e&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002p\u0005\u0015$aA*fiB!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001\u00027b]\u001eT!!a\u001f\u0002\t)\fg/Y\u0005\u0004'\u0006U\u0014aE:vaB|'\u000f^3e\r&dW\rV=qKN\u0004\u0013\u0001\u00029bi\"$B!a\u0010\u0002\u0006\")Q\f\ta\u0001#\u00061am\u001c:nCR$B!a\u0010\u0002\f\")1-\ta\u0001#\u00061q\u000e\u001d;j_:$b!a\u0010\u0002\u0012\u0006U\u0005BBAJE\u0001\u0007\u0011+A\u0002lKfDq!a&#\u0001\u0004\tI*A\u0003wC2,X\rE\u0002X\u00037K1!!(K\u0005\r\te._\u0001\b_B$\u0018n\u001c8t)\u0011\ty$a)\t\u000f\u0005\u00156\u00051\u0001\u0002(\u000691m\u001c8gS\u001e\u001c\b#B#O#\u0006e\u0015A\u00043bi\u0006\u0014\u0017m]3TG\",W.\u0019\u000b\u0005\u0003\u007f\ti\u000bC\u0003iI\u0001\u0007\u0011\u000b\u0006\u0003\u0002@\u0005E\u0006BBAZK\u0001\u0007!/\u0001\u0004tG\",W.Y\u0001\u0006i\u0006\u0014G.\u001a\u000b\u0005\u0003\u007f\tI\fC\u0003}M\u0001\u0007\u0011\u000b\u0006\u0003\u0002@\u0005u\u0006bBA\u0004O\u0001\u0007\u00111\u0002\u000b\u0005\u0003\u007f\t\t\rC\u0004\u0002&!\u0002\r!!\u000b\u0002'\r\u0014X-\u0019;f':|wO\u001a7bW\u0016\u0004F.\u00198\u0015\u0005\u0005\u001d\u0007\u0003BA\u0017\u0003\u0013L1!a3,\u00055\u0019fn\\<gY\u0006\\W\r\u00157b]\u0002")
public class StagedFileReader
extends Logging {
    private final Session session;
    private Map<String, String> curOptions;
    private String stageLocation;
    private String formatType;
    private String fullyQualifiedSchema;
    private Option<StructType> userSchema;
    private Option<String> tableName;
    private Seq<String> columnNames;
    private Seq<Expression> transformations;
    private final Set<String> supportedFileTypes;

    public Session session() {
        return this.session;
    }

    public Map<String, String> curOptions() {
        return this.curOptions;
    }

    public void curOptions_$eq(Map<String, String> x$1) {
        this.curOptions = x$1;
    }

    public String stageLocation() {
        return this.stageLocation;
    }

    public void stageLocation_$eq(String x$1) {
        this.stageLocation = x$1;
    }

    public String formatType() {
        return this.formatType;
    }

    public void formatType_$eq(String x$1) {
        this.formatType = x$1;
    }

    public String fullyQualifiedSchema() {
        return this.fullyQualifiedSchema;
    }

    public void fullyQualifiedSchema_$eq(String x$1) {
        this.fullyQualifiedSchema = x$1;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    public void userSchema_$eq(Option<StructType> x$1) {
        this.userSchema = x$1;
    }

    public Option<String> tableName() {
        return this.tableName;
    }

    public void tableName_$eq(Option<String> x$1) {
        this.tableName = x$1;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public void columnNames_$eq(Seq<String> x$1) {
        this.columnNames = x$1;
    }

    public Seq<Expression> transformations() {
        return this.transformations;
    }

    public void transformations_$eq(Seq<Expression> x$1) {
        this.transformations = x$1;
    }

    private final Set<String> supportedFileTypes() {
        return this.supportedFileTypes;
    }

    public StagedFileReader path(String stageLocation) {
        this.stageLocation_$eq(stageLocation);
        return this;
    }

    public StagedFileReader format(String formatType) {
        String upperFormatType = formatType.toUpperCase(Locale.ROOT);
        if (!this.supportedFileTypes().contains((Object)upperFormatType)) {
            throw ErrorMessage$.MODULE$.PLAN_UNSUPPORTED_FILE_FORMAT_TYPE(formatType);
        }
        this.formatType_$eq(upperFormatType);
        return this;
    }

    public StagedFileReader option(String key, Object value) {
        this.curOptions_$eq((Map<String, String>)this.curOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toUpperCase(Locale.ROOT)), (Object)Utils$.MODULE$.quoteForOption(value))));
        return this;
    }

    public StagedFileReader options(Map<String, Object> configs) {
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            StagedFileReader stagedFileReader = this.option(k, v);
            return stagedFileReader;
        });
        return this;
    }

    public StagedFileReader databaseSchema(String fullyQualifiedSchema) {
        this.fullyQualifiedSchema_$eq(fullyQualifiedSchema);
        return this;
    }

    public StagedFileReader userSchema(StructType schema) {
        this.userSchema_$eq((Option<StructType>)new Some((Object)schema));
        return this;
    }

    public StagedFileReader table(String tableName) {
        this.tableName_$eq((Option<String>)new Some((Object)tableName));
        return this;
    }

    public StagedFileReader columnNames(Seq<String> columnNames) {
        this.columnNames_$eq(columnNames);
        return this;
    }

    public StagedFileReader transformations(Seq<Expression> transformations) {
        this.transformations_$eq(transformations);
        return this;
    }

    public SnowflakePlan createSnowflakePlan() {
        SnowflakePlan snowflakePlan;
        if (this.tableName().nonEmpty()) {
            snowflakePlan = this.session().plans().copyInto((String)this.tableName().get(), this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), this.columnNames(), (Seq<String>)((Seq)this.transformations().map((Function1 & Serializable & scala.Serializable)expr -> SqlGenerator$.MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), this.userSchema());
        } else if (this.formatType().equals("CSV")) {
            if (this.userSchema().isEmpty()) {
                throw ErrorMessage$.MODULE$.DF_MUST_PROVIDE_SCHEMA_FOR_READING_FILE();
            }
            snowflakePlan = this.session().plans().readFile(this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), ((StructType)this.userSchema().get()).toAttributes());
        } else {
            Predef$.MODULE$.require(this.userSchema().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Read ").append(this.formatType()).append(" does not support user schema").toString());
            snowflakePlan = this.session().plans().readFile(this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), (Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("\"$1\"", VariantType$.MODULE$)}))));
        }
        return snowflakePlan;
    }

    public StagedFileReader(Session session, Map<String, String> curOptions, String stageLocation, String formatType, String fullyQualifiedSchema, Option<StructType> userSchema, Option<String> tableName, Seq<String> columnNames, Seq<Expression> transformations) {
        this.session = session;
        this.curOptions = curOptions;
        this.stageLocation = stageLocation;
        this.formatType = formatType;
        this.fullyQualifiedSchema = fullyQualifiedSchema;
        this.userSchema = userSchema;
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.transformations = transformations;
        this.supportedFileTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV", "JSON", "PARQUET", "AVRO", "ORC", "XML"}));
    }

    public StagedFileReader(Session session) {
        this(session, (Map<String, String>)Predef$.MODULE$.Map().empty(), "", "CSV", "", (Option<StructType>)None$.MODULE$, (Option<String>)None$.MODULE$, (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Seq<Expression>)((Seq)Seq$.MODULE$.empty()));
    }

    public StagedFileReader(StagedFileReader stagedFileReader) {
        this(stagedFileReader.session(), stagedFileReader.curOptions(), stagedFileReader.stageLocation(), stagedFileReader.formatType(), stagedFileReader.fullyQualifiedSchema(), stagedFileReader.userSchema(), stagedFileReader.tableName(), stagedFileReader.columnNames(), stagedFileReader.transformations());
    }
}

