/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.DataFrame$;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.SnowparkClientException;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.Query;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import java.io.Serializable;
import java.util.Locale;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SnowflakePlan$
extends Logging {
    public static SnowflakePlan$ MODULE$;
    private final HashSet<String> CopyOptionForCopyIntoTable;
    private final HashSet<String> FormatTypeOptionsForCopyIntoLocation;
    private final HashSet<String> CopyOptionsForCopyIntoLocation;
    private final HashSet<String> CopySubClausesForCopyIntoLocation;

    static {
        new SnowflakePlan$();
    }

    public SnowflakePlan apply(Seq<Query> queries, String schemaQuery, Session session, Option<LogicalPlan> sourcePlan, boolean supportAsyncMode) {
        return new SnowflakePlan(queries, schemaQuery, (Seq<Query>)((Seq)Seq$.MODULE$.empty()), session, sourcePlan, supportAsyncMode);
    }

    public SnowflakePlan apply(Seq<Query> queries, String schemaQuery, Seq<Query> postActions, Session session, Option<LogicalPlan> sourcePlan, boolean supportAsyncMode) {
        return new SnowflakePlan(queries, schemaQuery, postActions, session, sourcePlan, supportAsyncMode);
    }

    public <T> T wrapException(Seq<LogicalPlan> children, Function0<T> thunk) {
        Object object;
        try {
            object = thunk.apply();
        }
        catch (Throwable throwable) {
            boolean bl = false;
            SnowflakeSQLException snowflakeSQLException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SnowflakeSQLException) {
                bl = true;
                snowflakeSQLException = (SnowflakeSQLException)throwable2;
                if (snowflakeSQLException.getMessage().toLowerCase(Locale.ROOT).contains("unexpected 'as'")) {
                    SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_UNEXPECTED_ALIAS();
                    newEx.initCause(snowflakeSQLException);
                    throw newEx;
                }
            }
            if (bl) {
                String string = snowflakeSQLException.getSQLState();
                String string2 = "42000";
                if (!(string != null ? !string.equals(string2) : string2 != null) && snowflakeSQLException.getMessage().contains("invalid identifier")) {
                    String colName2;
                    String string3;
                    Regex ColPattern = new StringOps(Predef$.MODULE$.augmentString("(?s).*invalid identifier '\"?([^'\"]*)\"?'.*")).r();
                    Option option = ColPattern.unapplySeq((CharSequence)(string3 = snowflakeSQLException.getMessage()));
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                        throw snowflakeSQLException;
                    }
                    String string4 = colName2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String col = string4;
                    Seq remapped = (Seq)((TraversableLike)children.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.aliasMap().values(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replaceAll("^\"|\"$", ""), Seq$.MODULE$.canBuildFrom());
                    if (remapped.count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.equals(col))) > 0) {
                        String origColName = (String)DataFrame$.MODULE$.getUnaliased(col).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<colname>");
                        SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_INVALID_ID(origColName);
                        newEx.initCause(snowflakeSQLException);
                        throw newEx;
                    }
                    if (((TraversableOnce)remapped.flatMap((Function1 & Serializable & scala.Serializable)colName -> DataFrame$.MODULE$.getUnaliased((String)colName), Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.equals(col))) > 1) {
                        SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_JOIN_AMBIGUOUS(col, col);
                        newEx.initCause(snowflakeSQLException);
                        throw newEx;
                    }
                    throw snowflakeSQLException;
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    public HashSet<String> CopyOptionForCopyIntoTable() {
        return this.CopyOptionForCopyIntoTable;
    }

    public final HashSet<String> FormatTypeOptionsForCopyIntoLocation() {
        return this.FormatTypeOptionsForCopyIntoLocation;
    }

    public final HashSet<String> CopyOptionsForCopyIntoLocation() {
        return this.CopyOptionsForCopyIntoLocation;
    }

    public final HashSet<String> CopySubClausesForCopyIntoLocation() {
        return this.CopySubClausesForCopyIntoLocation;
    }

    private SnowflakePlan$() {
        MODULE$ = this;
        this.CopyOptionForCopyIntoTable = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ON_ERROR", "SIZE_LIMIT", "PURGE", "RETURN_FAILED_ONLY", "MATCH_BY_COLUMN_NAME", "ENFORCE_LENGTH", "TRUNCATECOLUMNS", "FORCE", "LOAD_UNCERTAIN_FILES"}));
        this.FormatTypeOptionsForCopyIntoLocation = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FORMAT_NAME", "COMPRESSION", "RECORD_DELIMITER", "FIELD_DELIMITER", "FILE_EXTENSION", "ESCAPE", "ESCAPE_UNENCLOSED_FIELD", "DATE_FORMAT", "TIME_FORMAT", "TIMESTAMP_FORMAT", "BINARY_FORMAT", "FIELD_OPTIONALLY_ENCLOSED_BY", "NULL_IF", "EMPTY_FIELD_AS_NULL", "FILE_EXTENSION", "SNAPPY_COMPRESSION"}));
        this.CopyOptionsForCopyIntoLocation = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SINGLE", "MAX_FILE_SIZE", "INCLUDE_QUERY_ID", "DETAILED_OUTPUT", "VALIDATION_MODE"}));
        this.CopySubClausesForCopyIntoLocation = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PARTITION BY", "HEADER"}));
    }
}

