/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.SnowparkSFConnectionHandler$;
import com.snowflake.snowpark.internal.Utils;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.udtf.UDTF;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.Random;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class Utils$
extends Logging {
    public static Utils$ MODULE$;
    private String OSName;
    private boolean isWindows;
    private String ScalaVersion;
    private String JavaVersion;
    private String clientPackageName;
    private final String Version;
    private final String SnowparkPackageName;
    private final String PackageNameDelimiter;
    private final String ScalaCompatVersion;
    private final String ScalaMinimumMinorVersion;
    private final String MinimumGSVersionForSnowparkClientType;
    private final String DateInputFormat;
    private final String TimestampInputFormat;
    private final String TempObjectNamePattern;
    private final Random randomGenerator;
    private final String _TEMP_OBJECT_PREFIX;
    private final int RETRY_SLEEP_TIME_UNIT_IN_MS;
    private final int MAX_SLEEP_TIME_IN_MS;
    private volatile byte bitmap$0;

    static {
        new Utils$();
    }

    public String Version() {
        return this.Version;
    }

    public String SnowparkPackageName() {
        return this.SnowparkPackageName;
    }

    public String PackageNameDelimiter() {
        return this.PackageNameDelimiter;
    }

    public String ScalaCompatVersion() {
        return this.ScalaCompatVersion;
    }

    public String ScalaMinimumMinorVersion() {
        return this.ScalaMinimumMinorVersion;
    }

    public String MinimumGSVersionForSnowparkClientType() {
        return this.MinimumGSVersionForSnowparkClientType;
    }

    public String DateInputFormat() {
        return this.DateInputFormat;
    }

    public String TimestampInputFormat() {
        return this.TimestampInputFormat;
    }

    public String TempObjectNamePattern() {
        return this.TempObjectNamePattern;
    }

    public Random randomGenerator() {
        return this.randomGenerator;
    }

    private final String _TEMP_OBJECT_PREFIX() {
        return this._TEMP_OBJECT_PREFIX;
    }

    public String convertWindowsPathToLinux(String path) {
        return path.replace("\\", "/");
    }

    public String convertPathIfNecessary(String path) {
        return this.isWindows() ? this.convertWindowsPathToLinux(path) : path;
    }

    private String OSName$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.OSName = System.getProperty("os.name");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.OSName;
    }

    public String OSName() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.OSName$lzycompute() : this.OSName;
    }

    private boolean isWindows$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isWindows = this.OSName().toLowerCase(Locale.ENGLISH).contains("win");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isWindows;
    }

    public boolean isWindows() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isWindows$lzycompute() : this.isWindows;
    }

    private String ScalaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.ScalaVersion = Properties$.MODULE$.versionNumberString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.ScalaVersion;
    }

    public String ScalaVersion() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.ScalaVersion$lzycompute() : this.ScalaVersion;
    }

    private String JavaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.JavaVersion = System.getProperty("java.version");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.JavaVersion;
    }

    public String JavaVersion() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.JavaVersion$lzycompute() : this.JavaVersion;
    }

    public boolean isSnowparkJar(String path) {
        String fileName = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).last()).toLowerCase(Locale.ROOT);
        return fileName.startsWith("snowpark") && (fileName.endsWith(".jar") || fileName.endsWith(".jar.gz"));
    }

    public String getUserCodeMeta() {
        ObjectRef lastInternalLine = ObjectRef.create((Object)"<unknown>");
        BooleanRef internalCode = BooleanRef.create((boolean)true);
        ArrayBuffer stackTrace = new ArrayBuffer();
        int stackDepth = 3;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).foreach((Function1 & Serializable & scala.Serializable)ste -> {
            Utils$.$anonfun$getUserCodeMeta$1(internalCode, lastInternalLine, stackTrace, ste);
            return BoxedUnit.UNIT;
        });
        return new StringBuilder(1).append((String)lastInternalLine.elem).append("\n").append(((TraversableOnce)stackTrace.take(stackDepth)).mkString("\n")).toString();
    }

    public <T> T logTime(Function0<T> f, String funcDescription) {
        this.logInfo(funcDescription);
        long start = System.currentTimeMillis();
        Object ret = f.apply();
        long end = System.currentTimeMillis();
        this.logInfo(new StringBuilder(16).append("Finished ").append(funcDescription).append(" in ").append(end - start).append(" ms").toString());
        return (T)ret;
    }

    public Option<Class<?>> getContainingClass(Object closure) {
        None$ none$;
        try {
            Some some;
            Object object = closure;
            if (object instanceof UDTF) {
                UDTF uDTF = (UDTF)object;
                some = new Some(uDTF.getClass());
            } else {
                Method writeReplace = closure.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                writeReplace.setAccessible(true);
                SerializedLambda lambda = (SerializedLambda)writeReplace.invoke(closure, new Object[0]);
                String className = lambda.getCapturingClass().replaceAll("/", ".");
                some = new Some(Class.forName(className));
            }
            none$ = some;
        }
        catch (Exception e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String normalizeStageLocation(String name) {
        String trimName = name.trim();
        return trimName.startsWith("@") ? trimName : new StringBuilder(1).append("@").append(trimName).toString();
    }

    private boolean isSingleQuoted(String name) {
        return name.startsWith("'") && name.endsWith("'");
    }

    public String normalizeLocalFile(String file) {
        String trimFile = file.trim();
        return trimFile.startsWith("file://") || this.isSingleQuoted(trimFile) ? trimFile : new StringBuilder(7).append("file://").append(trimFile).toString();
    }

    public String calculateMD5(File file) {
        byte[] buffer = new byte[8192];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(file), md5);){
            while (dis.read(buffer) != -1) {
            }
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(md5.digest())).map((Function1 & Serializable & scala.Serializable)x$1 -> Utils$.$anonfun$calculateMD5$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    public String checkUDFStage(String normalized) {
        return !normalized.endsWith("/") ? new StringBuilder(1).append(normalized).append("/").toString() : normalized;
    }

    public int stageFilePrefixLength(String stageLocation) {
        String normalized = this.checkUDFStage(this.normalizeStageLocation(stageLocation));
        if (normalized.startsWith("@~")) {
            return normalized.length() - 3;
        }
        IntRef res = IntRef.create((int)0);
        BooleanRef isQuoted = BooleanRef.create((boolean)false);
        ((IterableLike)new StringOps(Predef$.MODULE$.augmentString(normalized)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Utils$.$anonfun$stageFilePrefixLength$1(isQuoted, res, normalized, x0$1);
            return BoxedUnit.UNIT;
        });
        return res.elem;
    }

    public Tuple3<String, String, String> parseStageFileLocation(String stageLocation) {
        Object object = new Object();
        try {
            String normalized = this.normalizeStageLocation(stageLocation);
            if (stageLocation.endsWith("/")) {
                throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation, "Stage file location must point to a file, not a folder");
            }
            BooleanRef isQuoted = BooleanRef.create((boolean)false);
            ((IterableLike)new StringOps(Predef$.MODULE$.augmentString(normalized)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Utils$.$anonfun$parseStageFileLocation$1(isQuoted, normalized, stageLocation, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation, "Missing '/' to separate stage name and file name");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple3)ex.value();
        }
    }

    public void checkScalaVersionCompatibility() {
        this.checkScalaVersionCompatibility(this.ScalaVersion());
    }

    public void checkScalaVersionCompatibility(String inputScalaVersion) {
        if (!inputScalaVersion.startsWith(this.ScalaCompatVersion()) || this.compareVersion(inputScalaVersion, this.ScalaMinimumMinorVersion()) < 0) {
            throw ErrorMessage$.MODULE$.MISC_SCALA_VERSION_NOT_SUPPORTED(inputScalaVersion, this.ScalaCompatVersion(), this.ScalaMinimumMinorVersion());
        }
    }

    public int compareVersion(String version1, String version2) {
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])version1.split("\\."))).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])version2.split("\\.")), (Object)"0", (Object)"0", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$compareVersion$1(x0$1))).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$compareVersion$3(x0$2))));
    }

    public void validateObjectName(String name) {
        String unQuotedIdPattern = "([a-zA-Z_][\\w$]*)";
        String quotedIdPattern = "(\"([^\"]|\"\")+\")";
        String idPattern = new StringBuilder(3).append("(").append(unQuotedIdPattern).append("|").append(quotedIdPattern).append(")").toString();
        String pattern = new StringBuilder(20).append("^((").append(idPattern).append("\\.){0,2}|(").append(idPattern).append("\\.\\.))").append(idPattern).append("$").toString();
        if (!name.matches(pattern)) {
            throw ErrorMessage$.MODULE$.MISC_INVALID_OBJECT_NAME(name);
        }
    }

    public boolean isValidJavaIdentifier(String name) {
        return name.length() > 0 && Character.isJavaIdentifierStart(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(name)).head())) && ((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(name)).drop(1))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$isValidJavaIdentifier$1(BoxesRunTime.unboxToChar((Object)x$2))))).isEmpty();
    }

    public String getUDFUploadPrefix(String udfName) {
        return udfName.matches("[\\w]+") ? udfName : new StringBuilder(1).append(udfName.replaceAll("\\W", "")).append("_").append(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(udfName.hashCode()))).toString();
    }

    public <T> Set<T> createConcurrentSet() {
        return (Set)JavaConverters$.MODULE$.asScalaSetConverter(Collections.newSetFromMap(new ConcurrentHashMap())).asScala();
    }

    public String randomNameForTempObject(Utils.TempObjectType tempObjectType) {
        String typeStr = tempObjectType.toString().replaceAll("\\s", "_").toUpperCase();
        String randStr = this.randomGenerator().alphanumeric().take(15).mkString().toUpperCase();
        String name = new StringBuilder(2).append(this._TEMP_OBJECT_PREFIX()).append("_").append(typeStr).append("_").append(randStr).toString();
        Predef$.MODULE$.assert(name.matches(this.TempObjectNamePattern()), (Function0 & Serializable & scala.Serializable)() -> "Generated temp object name does not match the required pattern");
        return name;
    }

    public String escapePath(String path) {
        return this.isWindows() ? path.replace("\\", "\\\\") : path;
    }

    private int RETRY_SLEEP_TIME_UNIT_IN_MS() {
        return this.RETRY_SLEEP_TIME_UNIT_IN_MS;
    }

    private int MAX_SLEEP_TIME_IN_MS() {
        return this.MAX_SLEEP_TIME_IN_MS;
    }

    /*
     * WARNING - void declaration
     */
    public int retrySleepTimeInMS(int retry) {
        void var2_2;
        int expectedTime = this.RETRY_SLEEP_TIME_UNIT_IN_MS() * (int)Math.pow(2.0, retry);
        expectedTime = Math.min(expectedTime, this.MAX_SLEEP_TIME_IN_MS());
        expectedTime = expectedTime / 2 + RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt(expectedTime / 2)));
        return (int)var2_2;
    }

    public boolean isRetryable(Throwable t) {
        SnowflakeSQLException snowflakeSQLException;
        Throwable throwable = t;
        boolean bl = throwable instanceof SnowflakeSQLException && ((snowflakeSQLException = (SnowflakeSQLException)throwable).getMessage().contains("JDBC driver internal error") || snowflakeSQLException.getMessage().contains("JDBC driver encountered IO error"));
        return bl;
    }

    public <T> void withRetry(int maxRetry, String logPrefix, Function0<T> thunk) {
        int retry = 0;
        boolean done = false;
        None$ lastError = None$.MODULE$;
        while (retry < maxRetry && !done) {
            try {
                thunk.apply();
                done = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && this.isRetryable(throwable2 = throwable3)) {
                    this.logError(new StringBuilder(59).append("withRetry() failed: ").append(logPrefix).append(", sleep ").append(this.retrySleepTimeInMS(retry)).append(" ms").append(" and retry: ").append(retry).append(" error message: ").append(throwable2.getMessage()).toString());
                    Thread.sleep(this.retrySleepTimeInMS(retry));
                    lastError = new Some((Object)throwable2);
                    ++retry;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    this.logError(new StringBuilder(82).append("withRetry() failed: ").append(logPrefix).append(", but don't retry because it is not retryable,").append(" error message: ").append(throwable4.getMessage()).toString());
                    throw throwable4;
                }
                throw throwable;
            }
        }
        if (!done && lastError.nonEmpty()) {
            throw (Throwable)lastError.get();
        }
    }

    public boolean isPutOrGetCommand(String sql) {
        String adjustSql;
        return sql != null ? (adjustSql = sql.trim().toLowerCase(Locale.ENGLISH)).startsWith("put") || adjustSql.startsWith("get") : false;
    }

    public boolean isStringEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private String clientPackageName$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.clientPackageName = new StringBuilder(0).append(this.SnowparkPackageName()).append(this.PackageNameDelimiter()).append(SnowparkSFConnectionHandler$.MODULE$.extractValidVersionNumber(this.Version())).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.clientPackageName;
    }

    public String clientPackageName() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.clientPackageName$lzycompute() : this.clientPackageName;
    }

    public String quoteForOption(Object v) {
        String string;
        Object object = v;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            string = ((Object)BoxesRunTime.boxToBoolean((boolean)bl)).toString();
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            string = ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            string = n.toString();
        } else {
            String string2;
            string = object instanceof String && ((string2 = (String)object).equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) ? string2 : package$.MODULE$.singleQuote(v.toString());
        }
        return string;
    }

    public Seq<Attribute> getDisplayColumnNames(Seq<Attribute> attrs, Map<String, String> renamedColumns) {
        return (Seq)attrs.map((Function1 & Serializable & scala.Serializable)att -> (Attribute)renamedColumns.get((Object)att.name()).map((Function1 & Serializable & scala.Serializable)newName -> Attribute$.MODULE$.apply((String)newName, att.dataType(), att.nullable(), att.exprId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> att), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$getUserCodeMeta$1(BooleanRef internalCode$1, ObjectRef lastInternalLine$1, ArrayBuffer stackTrace$1, StackTraceElement ste) {
        block2: {
            if (ste == null || ste.getMethodName() == null || ste.getMethodName().contains("getStackTrace") || !internalCode$1.elem) break block2;
            if (ste.getClassName().startsWith("net.snowflake.client.") || ste.getClassName().startsWith("com.snowflake.snowpark.") || ste.getClassName().startsWith("scala.")) {
                lastInternalLine$1.elem = new StringBuilder(1).append(ste.getClassName()).append(".").append(ste.getMethodName()).toString();
            } else {
                stackTrace$1.$plus$eq((Object)ste.toString().replaceAll("(\\$\\$iw)+", "\\$iw"));
                internalCode$1.elem = false;
            }
        }
    }

    public static final /* synthetic */ String $anonfun$calculateMD5$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$stageFilePrefixLength$1(BooleanRef isQuoted$1, IntRef res$1, String normalized$1, Tuple2 x0$1) {
        char c;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && '\"' == (c = tuple2._1$mcC$sp())) {
            isQuoted$1.elem = !isQuoted$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (tuple2 != null) {
            char c2 = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            if ('/' == c2) {
                BoxedUnit boxedUnit;
                if (!isQuoted$1.elem && res$1.elem == 0) {
                    String fullStageName = normalized$1.substring(0, i);
                    String path = normalized$1.substring(i + 1);
                    Regex stageNamePattern = new StringOps(Predef$.MODULE$.augmentString("%?[A-Za-z0-9_$]+|\"([^\"]|\"\")+\"")).r();
                    String stageName = (String)stageNamePattern.findAllIn((CharSequence)fullStageName).toSeq().last();
                    if (stageName.startsWith("%")) {
                        res$1.elem = path.length();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        res$1.elem = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(stageName)).stripSuffix("\""))).stripPrefix("\"").length() + path.length() + 1;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$parseStageFileLocation$1(BooleanRef isQuoted$2, String normalized$2, String stageLocation$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        char c;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && '\"' == (c = tuple2._1$mcC$sp())) {
            isQuoted$2.elem = !isQuoted$2.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (tuple2 != null) {
            char c2 = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            if ('/' == c2) {
                if (isQuoted$2.elem) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                String fullStageName = normalized$2.substring(0, i);
                String pathAndFileName = normalized$2.substring(i + 1);
                if (pathAndFileName.isEmpty()) {
                    throw ErrorMessage$.MODULE$.MISC_INVALID_STAGE_LOCATION(stageLocation$1, "Missing file name after the stage name");
                }
                String[] pathList = pathAndFileName.split("/");
                String path = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).take(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).size() - 1))).mkString("/");
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple3((Object)fullStageName, (Object)path, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathList)).last()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$compareVersion$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String a = (String)tuple2._1();
        String b = (String)tuple2._2();
        String string = a;
        String string2 = b;
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ int $anonfun$compareVersion$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String a = (String)tuple2._1();
        String b = (String)tuple2._2();
        int n = new StringOps(Predef$.MODULE$.augmentString(a)).toInt() - new StringOps(Predef$.MODULE$.augmentString(b)).toInt();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$isValidJavaIdentifier$1(char x$2) {
        return !Character.isJavaIdentifierPart(x$2);
    }

    private Utils$() {
        MODULE$ = this;
        this.Version = "1.7.0";
        this.SnowparkPackageName = "com.snowflake:snowpark";
        this.PackageNameDelimiter = ":";
        this.ScalaCompatVersion = "2.12";
        this.ScalaMinimumMinorVersion = "2.12.9";
        this.MinimumGSVersionForSnowparkClientType = "5.20.0";
        this.DateInputFormat = "YYYY-MM-DD";
        this.TimestampInputFormat = "YYYY-MM-DD HH24:MI:SS.FF";
        this.TempObjectNamePattern = "^SNOWPARK_TEMP_(TABLE|VIEW|STAGE|FUNCTION|TABLE_FUNCTION|FILE_FORMAT|PROCEDURE)_[0-9A-Z]+$";
        this.randomGenerator = new Random(System.nanoTime());
        this._TEMP_OBJECT_PREFIX = "SNOWPARK_TEMP";
        this.RETRY_SLEEP_TIME_UNIT_IN_MS = 1500;
        this.MAX_SLEEP_TIME_IN_MS = 60000;
    }
}

