/*
 * Decompiled with CFR 0.152.
 */
package com.snappydb;

import android.content.Context;
import com.esotericsoftware.kryo.Kryo;
import com.snappydb.DB;
import com.snappydb.SnappydbException;
import com.snappydb.internal.DBImpl;
import java.io.File;

public class DBFactory {
    private static final String DEFAULT_DBNAME = "snappydb";

    public static DB open(String folder, String dbName, Kryo ... kryo) throws SnappydbException {
        String dbFilePath = folder + File.separator + dbName;
        return new DBImpl(dbFilePath, kryo);
    }

    public static DB open(String folder, Kryo ... kryo) throws SnappydbException {
        return DBFactory.open(folder, DEFAULT_DBNAME, kryo);
    }

    public static DB open(Context ctx, String dbName, Kryo ... kryo) throws SnappydbException {
        return DBFactory.open(ctx.getFilesDir().getAbsolutePath(), dbName, kryo);
    }

    public static DB open(Context ctx, Kryo ... kryo) throws SnappydbException {
        return DBFactory.open(ctx, DEFAULT_DBNAME, kryo);
    }
}

