/*
 * Decompiled with CFR 0.152.
 */
package com.snail.antifake.deviceid.macaddress;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class IWifiManagerUtil {
    private static String INVALID_ADDRESS = "02:00:00:00:00:00";

    public static String getMacAddress(Context context) {
        String address = IWifiManagerUtil.getMacAddressLevel1(context);
        if (!TextUtils.isEmpty((CharSequence)address) && !INVALID_ADDRESS.endsWith(address)) {
            return address;
        }
        address = IWifiManagerUtil.getMacAddressLevel0(context);
        if (!TextUtils.isEmpty((CharSequence)address) && !INVALID_ADDRESS.endsWith(address)) {
            return address;
        }
        return address;
    }

    private static String getMacAddressLevel0(Context context) {
        String macAddress = null;
        try {
            WifiInfo info;
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = info = null == wifiManager ? null : wifiManager.getConnectionInfo();
            if (null != info) {
                macAddress = info.getMacAddress();
            }
            if (!TextUtils.isEmpty(macAddress)) {
                return macAddress;
            }
            if (wifiManager != null && !wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
                wifiManager.setWifiEnabled(false);
            }
            WifiInfo wifiInfo2 = info = null == wifiManager ? null : wifiManager.getConnectionInfo();
            if (null != info) {
                macAddress = info.getMacAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return macAddress;
    }

    private static String getMacAddressLevel1(Context context) {
        String macAddress = null;
        try {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            Field IWifiManagerService = wifiManager.getClass().getDeclaredField("mService");
            IWifiManagerService.setAccessible(true);
            Object service = IWifiManagerService.get(wifiManager);
            Method getConnectionInfo = service.getClass().getDeclaredMethod("getConnectionInfo", new Class[0]);
            getConnectionInfo.setAccessible(true);
            WifiInfo info = (WifiInfo)getConnectionInfo.invoke(service, new Object[0]);
            if (info == null && !wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
                wifiManager.setWifiEnabled(false);
                info = (WifiInfo)getConnectionInfo.invoke(service, new Object[0]);
            }
            try {
                Field mMacAddress = info.getClass().getDeclaredField("mMacAddress");
                mMacAddress.setAccessible(true);
                macAddress = (String)mMacAddress.get(info);
                if (!TextUtils.isEmpty((CharSequence)macAddress)) {
                    return macAddress;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (info != null) {
                macAddress = info.getMacAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return macAddress;
    }
}

