/*
 * Decompiled with CFR 0.152.
 */
package com.snail.antifake.deviceid.emulator;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.v4.content.PermissionChecker;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.snail.antifake.deviceid.AndroidDeviceIMEIUtil;
import com.snail.antifake.deviceid.ShellAdbUtils;
import com.snail.antifake.deviceid.deviceid.DeviceIdUtil;
import com.snail.antifake.deviceid.deviceid.IPhoneSubInfoUtil;
import com.snail.antifake.deviceid.deviceid.ITelephonyUtil;
import com.snail.antifake.jni.PropertiesGet;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class EmuCheckUtil {
    public static boolean mayOnEmulator(Context context) {
        return EmuCheckUtil.mayOnEmulatorViaQEMU(context) || EmuCheckUtil.isEmulatorViaBuild(context) || EmuCheckUtil.isEmulatorFromAbi() || EmuCheckUtil.isEmulatorFromCpu();
    }

    public static boolean checkPermissionGranted(Context context, String permission) {
        boolean result = true;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                int targetSdkVersion = info.applicationInfo.targetSdkVersion;
                result = targetSdkVersion >= 23 ? context.checkSelfPermission(permission) == 0 : PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isEmulatorViaBuild(Context context) {
        if (!TextUtils.isEmpty((CharSequence)PropertiesGet.getString("ro.product.model")) && PropertiesGet.getString("ro.product.model").toLowerCase().contains("sdk")) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)PropertiesGet.getString("ro.product.manufacturer")) && PropertiesGet.getString("ro.product.manufacture").toLowerCase().contains("unknown")) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)PropertiesGet.getString("ro.product.device")) && PropertiesGet.getString("ro.product.device").toLowerCase().contains("generic");
    }

    public static boolean mayOnEmulatorViaQEMU(Context context) {
        String qemu = PropertiesGet.getString("ro.kernel.qemu");
        return "1".equals(qemu);
    }

    public static boolean isFakeEmulatorFromIMEI(Context context) {
        String deviceId = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            deviceId = tm.getDeviceId();
        }
        catch (Exception tm) {
            // empty catch block
        }
        String deviceId1 = IPhoneSubInfoUtil.getDeviceId(context);
        String deviceId2 = ITelephonyUtil.getDeviceId(context);
        return !TextUtils.isEmpty((CharSequence)deviceId) && TextUtils.isEmpty((CharSequence)deviceId1) && TextUtils.isEmpty((CharSequence)deviceId2);
    }

    public static String getFinalIMEI(Context context) {
        return DeviceIdUtil.getDeviceId(context);
    }

    public static String getIMEIT(Context context) {
        return ITelephonyUtil.getDeviceId(context);
    }

    public static String getIMEIP(Context context) {
        return IPhoneSubInfoUtil.getDeviceId(context);
    }

    public static boolean hasQemuSocket() {
        File qemuSocket = new File("/dev/socket/qemud");
        return qemuSocket.exists();
    }

    public static boolean hasQemuPipe() {
        File qemuPipe = new File("/dev/socket/qemud");
        return qemuPipe.exists();
    }

    public static String getEmulatorQEMUKernel() {
        return PropertiesGet.getString("ro.kernel.qemu");
    }

    private static boolean isEmulatorFromCpu() {
        ShellAdbUtils.CommandResult commandResult = ShellAdbUtils.execCommand("cat /proc/cpuinfo", false);
        String cpuInfo = commandResult == null ? "" : commandResult.successMsg;
        return !TextUtils.isEmpty((CharSequence)cpuInfo) && (cpuInfo.toLowerCase().contains("intel") || cpuInfo.toLowerCase().contains("amd"));
    }

    private static boolean isEmulatorFromAbi() {
        String abi = AndroidDeviceIMEIUtil.getCpuAbi();
        return !TextUtils.isEmpty((CharSequence)abi) && abi.contains("x86");
    }

    public static String getCpuInfo() {
        ShellAdbUtils.CommandResult commandResult = ShellAdbUtils.execCommand("cat /proc/cpuinfo", false);
        return commandResult == null ? "" : commandResult.successMsg;
    }

    public static String getQEmuDriverFileString() {
        File driver_file = new File("/proc/tty/drivers");
        StringBuilder stringBuilder = new StringBuilder();
        if (driver_file.exists() && driver_file.canRead()) {
            try {
                int rsz;
                char[] data = new char[1024];
                FileInputStream inStream = new FileInputStream(driver_file);
                InputStreamReader in = new InputStreamReader((InputStream)inStream, "UTF-8");
                while ((rsz = ((Reader)in).read(data, 0, data.length)) >= 0) {
                    stringBuilder.append(data, 0, rsz);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static interface CheckEmulatorCallBack {
        public void onCheckSuccess(boolean var1);

        public void onCheckFaild();
    }
}

