/*
 * Decompiled with CFR 0.152.
 */
package com.snail.antifake.deviceid.deviceid;

import android.content.Context;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.snail.antifake.deviceid.BinderUtil;
import java.lang.reflect.Method;

public class ITelephonyUtil {
    public static String getDeviceId(Context context) {
        String deviceId = ITelephonyUtil.getDeviceIdLevel2(context);
        if (!(TextUtils.isEmpty((CharSequence)deviceId) && TextUtils.isEmpty((CharSequence)(deviceId = ITelephonyUtil.getDeviceIdLevel1(context))) && TextUtils.isEmpty((CharSequence)(deviceId = ITelephonyUtil.getDeviceIdLevel0(context))))) {
            return deviceId;
        }
        return deviceId;
    }

    public static String getDeviceIdLevel0(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        try {
            Method getDeviceId;
            Method method = TelephonyManager.class.getDeclaredMethod("getITelephony", new Class[0]);
            method.setAccessible(true);
            Object binderProxy = method.invoke((Object)telephonyManager, new Object[0]);
            Class<?> proxyClass = binderProxy.getClass();
            Method asBinder = proxyClass.getDeclaredMethod("asBinder", new Class[0]);
            asBinder.setAccessible(true);
            try {
                getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", String.class);
                if (getDeviceId != null) {
                    return (String)getDeviceId.invoke(binderProxy, context.getPackageName());
                }
            }
            catch (Exception getDeviceId2) {
                // empty catch block
            }
            getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", new Class[0]);
            if (getDeviceId != null) {
                return (String)getDeviceId.invoke(binderProxy, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getDeviceIdLevel1(Context context) {
        try {
            Method getDeviceId;
            Class<?> ServiceManager = Class.forName("android.os.ServiceManager");
            Method getService = ServiceManager.getDeclaredMethod("getService", String.class);
            getService.setAccessible(true);
            IBinder binder = (IBinder)getService.invoke(null, "phone");
            Class<?> Stub2 = Class.forName("com.android.internal.telephony.ITelephony$Stub");
            Method asInterface = Stub2.getDeclaredMethod("asInterface", IBinder.class);
            asInterface.setAccessible(true);
            Object binderProxy = asInterface.invoke(null, binder);
            try {
                getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", String.class);
                if (getDeviceId != null) {
                    return (String)getDeviceId.invoke(binderProxy, context.getPackageName());
                }
            }
            catch (Exception getDeviceId2) {
                // empty catch block
            }
            getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", new Class[0]);
            if (getDeviceId != null) {
                return (String)getDeviceId.invoke(binderProxy, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getDeviceIdLevel2(Context context) {
        String deviceId = "";
        try {
            Method getDeviceId;
            Class<?> ServiceManager = Class.forName("android.os.ServiceManager");
            Method getService = ServiceManager.getDeclaredMethod("getService", String.class);
            getService.setAccessible(true);
            IBinder binder = (IBinder)getService.invoke(null, "phone");
            Class<?> Stub2 = Class.forName("com.android.internal.telephony.ITelephony$Stub");
            Method asInterface = Stub2.getDeclaredMethod("asInterface", IBinder.class);
            asInterface.setAccessible(true);
            Object binderProxy = asInterface.invoke(null, binder);
            try {
                getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", String.class);
                if (getDeviceId != null) {
                    deviceId = ITelephonyUtil.binderGetHardwareInfo(context.getPackageName(), binder, BinderUtil.getInterfaceDescriptor(binderProxy), BinderUtil.getTransactionId(binderProxy, "TRANSACTION_getDeviceId"));
                }
            }
            catch (Exception getDeviceId2) {
                // empty catch block
            }
            getDeviceId = binderProxy.getClass().getDeclaredMethod("getDeviceId", new Class[0]);
            if (getDeviceId != null) {
                deviceId = ITelephonyUtil.binderGetHardwareInfo("", binder, BinderUtil.getInterfaceDescriptor(binderProxy), BinderUtil.getTransactionId(binderProxy, "TRANSACTION_getDeviceId"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String binderGetHardwareInfo(String callingPackage, IBinder remote, String DESCRIPTOR, int tid) throws RemoteException {
        String _result;
        Parcel _data = Parcel.obtain();
        Parcel _reply = Parcel.obtain();
        try {
            _data.writeInterfaceToken(DESCRIPTOR);
            if (!TextUtils.isEmpty((CharSequence)callingPackage)) {
                _data.writeString(callingPackage);
            }
            remote.transact(tid, _data, _reply, 0);
            _reply.readException();
            _result = _reply.readString();
        }
        finally {
            _reply.recycle();
            _data.recycle();
        }
        return _result;
    }
}

