/*
 * Decompiled with CFR 0.152.
 */
package com.snail.antifake.deviceid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.snail.antifake.deviceid.BatteryChangeReceiver;
import com.snail.antifake.deviceid.IpScanner;
import com.snail.antifake.deviceid.androidid.IAndroidIdUtil;
import com.snail.antifake.deviceid.deviceid.DeviceIdUtil;
import com.snail.antifake.deviceid.emulator.EmuCheckUtil;
import com.snail.antifake.deviceid.macaddress.MacAddressUtils;
import com.snail.antifake.jni.PropertiesGet;

public class AndroidDeviceIMEIUtil {
    public static BatteryChangeReceiver sBatteryChangeReceiver;

    public static boolean isRunOnEmulator(Context context) {
        return EmuCheckUtil.mayOnEmulator(context);
    }

    public static String getDeviceId(Context context) {
        return DeviceIdUtil.getDeviceId(context);
    }

    public static String getAndroidId(Context context) {
        return IAndroidIdUtil.getAndroidId(context);
    }

    public static String getMacAddress(Context context) {
        return MacAddressUtils.getMacAddress(context);
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getSerialno() {
        String serialno = "";
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                serialno = Build.getSerial();
            } else {
                serialno = PropertiesGet.getString("ro.serialno");
                if (TextUtils.isEmpty((CharSequence)serialno)) {
                    serialno = Build.SERIAL;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialno;
    }

    public static String getManufacturer() {
        return PropertiesGet.getString("ro.product.manufacturer");
    }

    public static String getBrand() {
        return PropertiesGet.getString("ro.product.brand");
    }

    public static String getModel() {
        return PropertiesGet.getString("ro.product.model");
    }

    public static String getCpuAbi() {
        return PropertiesGet.getString("ro.product.cpu.abi");
    }

    public static String getDevice() {
        return PropertiesGet.getString("ro.product.device");
    }

    public static String getBoard() {
        return PropertiesGet.getString("ro.product.board");
    }

    public static String getHardware() {
        return PropertiesGet.getString("ro.hardware");
    }

    public static String getBootloader() {
        return PropertiesGet.getString("ro.bootloader");
    }

    public static String getIMSI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getSubscriberId();
    }

    public static void registerBatteryChangeListener(Context context) {
        if (sBatteryChangeReceiver == null) {
            sBatteryChangeReceiver = new BatteryChangeReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            context.registerReceiver((BroadcastReceiver)sBatteryChangeReceiver, filter);
        }
    }

    public static void unRegisterBatteryChangeListener(Context context) {
        if (sBatteryChangeReceiver == null) {
            context.unregisterReceiver((BroadcastReceiver)sBatteryChangeReceiver);
            sBatteryChangeReceiver = null;
        }
    }

    public static boolean isCharging() {
        return sBatteryChangeReceiver != null && !sBatteryChangeReceiver.isCharging();
    }

    public static int getCurrentBatteryLevel() {
        return sBatteryChangeReceiver != null ? sBatteryChangeReceiver.getCurrentLevel() : -1;
    }

    public static void getMac(IpScanner.OnScanListener listener) {
        IpScanner ipScanner = new IpScanner();
        ipScanner.startScan(listener);
    }
}

