/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.UserResources;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.AlternateEmail;
import com.smartsheet.api.models.DeleteUserParameters;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Result;
import com.smartsheet.api.models.Sheet;
import com.smartsheet.api.models.User;
import com.smartsheet.api.models.UserProfile;
import com.smartsheet.api.models.enums.ListUserInclusion;
import com.smartsheet.api.models.enums.UserInclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserResourcesImpl
extends AbstractResources
implements UserResources {
    private static final String USERS = "users";
    private static final String ALTERNATE_EMAILS = "alternateemails";

    public UserResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<User> listUsers() throws SmartsheetException {
        return this.listResourcesWithWrapper(USERS, User.class);
    }

    @Override
    public PagedResult<User> listUsers(Set<String> email, PaginationParameters pagination) throws SmartsheetException {
        return this.listUsers(email, null, pagination);
    }

    @Override
    public PagedResult<User> listUsers(Set<String> email, EnumSet<ListUserInclusion> includes, PaginationParameters pagination) throws SmartsheetException {
        Object path = USERS;
        Map<Object, Object> parameters = new HashMap<String, String>();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        parameters.put("email", QueryUtil.generateCommaSeparatedList(email));
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper((String)path, User.class);
    }

    @Override
    public User addUser(User user) throws SmartsheetException {
        return this.createResource(USERS, User.class, user);
    }

    @Override
    public User addUser(User user, boolean sendEmail) throws SmartsheetException {
        return this.createResource("users?sendEmail=" + sendEmail, User.class, user);
    }

    @Override
    public UserProfile getUser(long userId) throws SmartsheetException {
        return this.getResource("users/" + userId, UserProfile.class);
    }

    @Override
    public UserProfile getCurrentUser() throws SmartsheetException {
        return this.getResource("users/me", UserProfile.class);
    }

    @Override
    public UserProfile getCurrentUser(EnumSet<UserInclusion> includes) throws SmartsheetException {
        Object path = "users/me";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.getResource((String)path, UserProfile.class);
    }

    @Override
    public PagedResult<Sheet> listOrgSheets(PaginationParameters pagination, Date modifiedSince) throws SmartsheetException {
        Object path = "users/sheets";
        Map<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper((String)path, Sheet.class);
    }

    @Override
    public PagedResult<Sheet> listOrgSheets(PaginationParameters pagination) throws SmartsheetException {
        return this.listOrgSheets(pagination, null);
    }

    @Override
    public PagedResult<AlternateEmail> listAlternateEmails(long userId, PaginationParameters pagination) throws SmartsheetException {
        String path = "users/" + userId + "/alternateemails";
        if (pagination != null) {
            path = path + pagination.toQueryString();
        }
        return this.listResourcesWithWrapper(path, AlternateEmail.class);
    }

    @Override
    public AlternateEmail getAlternateEmail(long userId, long altEmailId) throws SmartsheetException {
        return this.getResource("users/" + userId + "/alternateemails/" + altEmailId, AlternateEmail.class);
    }

    @Override
    public List<AlternateEmail> addAlternateEmail(long userId, List<AlternateEmail> altEmails) throws SmartsheetException {
        Util.throwIfNull(altEmails);
        if (altEmails.size() == 0) {
            return altEmails;
        }
        return this.postAndReceiveList("users/" + userId + "/alternateemails", altEmails, AlternateEmail.class);
    }

    @Override
    public void deleteAlternateEmail(long userId, long altEmailId) throws SmartsheetException {
        this.deleteResource("users/" + userId + "/alternateemails/" + altEmailId, AlternateEmail.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AlternateEmail promoteAlternateEmail(long userId, long altEmailId) throws SmartsheetException {
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve("users/" + userId + "/alternateemails/" + altEmailId + "/makeprimary"), HttpMethod.POST);
        Result<AlternateEmail> obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeResult(AlternateEmail.class, response.getEntity().getContent());
                    return (AlternateEmail)((Object)obj);
                }
                default: {
                    this.handleError(response);
                    return (AlternateEmail)((Object)obj);
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    @Override
    public User addProfileImage(long userId, String file, String fileType) throws SmartsheetException, FileNotFoundException {
        return this.attachProfileImage("users/" + userId + "/profileimage", file, fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private User attachProfileImage(String path, String file, String contentType) throws SmartsheetException, FileNotFoundException {
        Util.throwIfNull(file);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        HashMap parameters = new HashMap();
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve((String)path), HttpMethod.POST);
        String attachmentHeaderValue = "attachment; filename=\"" + URLEncoder.encode(file, StandardCharsets.UTF_8) + "\"";
        request.getHeaders().put("Content-Disposition", attachmentHeaderValue);
        File f = new File(file);
        FileInputStream is = new FileInputStream(f);
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(is);
        entity.setContentLength(f.length());
        request.setEntity(entity);
        User obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeResult(User.class, response.getEntity().getContent()).getResult();
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    @Override
    public User updateUser(User user) throws SmartsheetException {
        return this.updateResource("users/" + user.getId(), User.class, user);
    }

    @Override
    public void deleteUser(long userId, DeleteUserParameters parameters) throws SmartsheetException {
        String path = "users/" + userId;
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        this.deleteResource(path, User.class);
    }
}

