/*
 * Copyright (C) 2023 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.smartsheet.api.oauth;

/**
 * <p>This is the exception thrown by {@link OAuthFlow} to indicate "unsupported_response_type" error occurred when obtaining
 * an authorization code.</p>
 *
 * <p>Thread safety: Exceptions are not thread safe.</p>
 */
public class UnsupportedResponseTypeException extends OAuthAuthorizationCodeException {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * Constructor.
     *
     * @param message the message
     */
    public UnsupportedResponseTypeException(String message) {
        super(message);
    }
}
