/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.auth;

import com.smartling.api.sdk.auth.AuthApiClient;
import com.smartling.api.sdk.auth.AuthenticationCommand;
import com.smartling.api.sdk.auth.AuthenticationContext;
import com.smartling.api.sdk.auth.AuthenticationToken;
import com.smartling.api.sdk.auth.TokenProvider;
import com.smartling.api.sdk.exceptions.SmartlingApiException;

public class OAuthTokenProvider
implements TokenProvider {
    private final String userId;
    private final String userSecret;
    private volatile AuthenticationContext authenticationContext;
    private final AuthApiClient authApiClient;

    public OAuthTokenProvider(String userId, String userSecret, AuthApiClient authApiClient) {
        this.userId = userId;
        this.userSecret = userSecret;
        this.authApiClient = authApiClient;
    }

    @Override
    public AuthenticationToken getAuthenticationToken() throws SmartlingApiException {
        this.generateAuthenticationContext();
        return new AuthenticationToken(this.authenticationContext.getTokenType(), this.authenticationContext.getAccessToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAuthenticationContext() throws SmartlingApiException {
        if (this.accessTokenIsNotValid()) {
            AuthApiClient authApiClient = this.authApiClient;
            synchronized (authApiClient) {
                if (this.accessTokenIsNotValid()) {
                    this.authenticationContext = this.refreshTokenIsValid() ? this.authApiClient.refresh(this.authenticationContext.getRefreshToken()).retrieveData() : this.authApiClient.authenticate(new AuthenticationCommand(this.userId, this.userSecret)).retrieveData();
                }
            }
        }
    }

    private boolean refreshTokenIsValid() {
        return this.authenticationContext != null && System.currentTimeMillis() <= this.authenticationContext.getRefreshTokenExpireTime();
    }

    private boolean accessTokenIsNotValid() {
        return this.authenticationContext == null || System.currentTimeMillis() > this.authenticationContext.calculateAccessTokenExpireTime();
    }
}

