/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.smartling.api.sdk.BaseApiClient;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.auth.AuthenticationToken;
import com.smartling.api.sdk.auth.TokenProvider;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import java.util.Objects;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class TokenProviderAwareClient
extends BaseApiClient {
    private final TokenProvider tokenProvider;

    protected TokenProviderAwareClient(String baseUrl, ProxyConfiguration proxyConfiguration, TokenProvider tokenProvider) {
        super(baseUrl, proxyConfiguration);
        this.tokenProvider = Objects.requireNonNull(tokenProvider, "Token Provider can not be null");
    }

    @Override
    protected StringResponse executeRequest(HttpRequestBase request) throws SmartlingApiException {
        AuthenticationToken authenticationToken = this.tokenProvider.getAuthenticationToken();
        request.addHeader("Authorization", authenticationToken.getAuthorizationTokenString());
        return super.executeRequest(request);
    }
}

