/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.parameters;

import com.google.gson.JsonObject;
import com.smartling.api.sdk.LibNameVersionHolder;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.parameters.ParameterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class FileUploadParameterBuilder
implements ParameterBuilder {
    private static final String CLIENT_KEY = "client";
    private static final String VERSION_KEY = "version";
    private FileType fileType;
    private String fileUri;
    private Boolean authorize;
    private String callbackUrl;
    private List<String> localeIdsToAuthorize;
    private Boolean overwriteAuthorizedLocales;
    private Map<String, String> directives;
    private String charset;

    public FileUploadParameterBuilder(FileType fileType, String fileUri) {
        this.fileType = fileType;
        this.fileUri = fileUri;
    }

    public FileUploadParameterBuilder directives(Map<String, String> directives) {
        this.directives = directives;
        return this;
    }

    public FileUploadParameterBuilder overwriteAuthorizedLocales(Boolean overwriteAuthorizedLocales) {
        this.overwriteAuthorizedLocales = overwriteAuthorizedLocales;
        return this;
    }

    public FileUploadParameterBuilder localeIdsToAuthorize(List<String> localesToApprove) {
        this.localeIdsToAuthorize = localesToApprove;
        return this;
    }

    public List<String> getLocaleIdsToAuthorize() {
        return null != this.localeIdsToAuthorize ? this.localeIdsToAuthorize : new ArrayList<String>();
    }

    public FileUploadParameterBuilder callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public FileUploadParameterBuilder approveContent(Boolean approveContent) {
        this.authorize = approveContent;
        return this;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public FileUploadParameterBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public List<NameValuePair> getNameValueList() {
        LinkedList<NameValuePair> paramsList = new LinkedList<NameValuePair>();
        paramsList.add((NameValuePair)new BasicNameValuePair("fileUri", this.fileUri));
        paramsList.add((NameValuePair)new BasicNameValuePair("fileType", this.fileType.getIdentifier()));
        paramsList.add((NameValuePair)new BasicNameValuePair("authorize", null == this.authorize ? null : Boolean.toString(this.authorize)));
        paramsList.add((NameValuePair)new BasicNameValuePair("callbackUrl", this.callbackUrl));
        if (this.localeIdsToAuthorize != null && !this.localeIdsToAuthorize.isEmpty()) {
            paramsList.addAll(this.convertLocalesBasedApproveParams("localeIdsToAuthorize", this.localeIdsToAuthorize));
        }
        if (this.overwriteAuthorizedLocales != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("overwriteAuthorizedLocales", this.overwriteAuthorizedLocales.toString()));
        }
        paramsList.add((NameValuePair)new BasicNameValuePair("smartling.client_lib_id", this.getClientUidDirective()));
        paramsList.addAll(this.convertMapParams(this.directives));
        return paramsList;
    }

    private List<NameValuePair> convertLocalesBasedApproveParams(String prefix, List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (int index = 0; index < values.size(); ++index) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(prefix + "[]", values.get(index)));
        }
        return nameValuePairs;
    }

    private List<NameValuePair> convertMapParams(Map<String, String> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            LinkedList<NameValuePair> nameValuePairs = new LinkedList<NameValuePair>();
            for (String key : paramMap.keySet()) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key)));
            }
            return nameValuePairs;
        }
        return Collections.emptyList();
    }

    private String getClientUidDirective() {
        JsonObject object = new JsonObject();
        object.addProperty(CLIENT_KEY, LibNameVersionHolder.getClientLibName());
        object.addProperty(VERSION_KEY, LibNameVersionHolder.getClientLibVersion());
        return object.toString();
    }
}

