/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.auth;

import com.smartling.api.sdk.auth.AuthApiClient;
import com.smartling.api.sdk.auth.AuthenticationCommand;
import com.smartling.api.sdk.auth.AuthenticationContext;
import com.smartling.api.sdk.auth.AuthenticationToken;
import com.smartling.api.sdk.auth.TokenProvider;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class OAuthTokenProvider
implements TokenProvider {
    private final String userId;
    private final String userSecret;
    private final AuthApiClient authApiClient;
    private static final Log LOGGER = LogFactory.getLog(OAuthTokenProvider.class);
    private volatile AuthenticationContext authenticationContext;

    public OAuthTokenProvider(String userId, String userSecret, AuthApiClient authApiClient) {
        this.userId = userId;
        this.userSecret = userSecret;
        this.authApiClient = authApiClient;
    }

    @Override
    public AuthenticationToken getAuthenticationToken() throws SmartlingApiException {
        this.generateAuthenticationContext();
        return new AuthenticationToken(this.authenticationContext.getTokenType(), this.authenticationContext.getAccessToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAuthenticationContext() throws SmartlingApiException {
        if (this.accessTokenIsNotValid()) {
            AuthApiClient authApiClient = this.authApiClient;
            synchronized (authApiClient) {
                if (this.accessTokenIsNotValid()) {
                    if (this.refreshTokenIsValid()) {
                        String refreshToken = this.authenticationContext.getRefreshToken();
                        try {
                            this.authenticationContext = this.authApiClient.refresh(refreshToken).retrieveData();
                        }
                        catch (SmartlingApiException ex) {
                            this.authenticationContext = null;
                            LOGGER.warn((Object)"Reset refresh token after fail");
                            JwtConsumer consumer = new JwtConsumerBuilder().setSkipAllDefaultValidators().setRequireExpirationTime().setSkipSignatureVerification().build();
                            try {
                                LOGGER.warn((Object)("Failed token info: " + consumer.process(refreshToken).getJwtClaims().getRawJson()));
                            }
                            catch (InvalidJwtException e) {
                                LOGGER.warn((Object)"Can't parse refresh token");
                            }
                            throw ex;
                        }
                    }
                    this.authenticationContext = this.authApiClient.authenticate(new AuthenticationCommand(this.userId, this.userSecret)).retrieveData();
                }
            }
        }
    }

    private boolean refreshTokenIsValid() {
        return this.authenticationContext != null && System.currentTimeMillis() <= this.authenticationContext.calculateRefreshTokenExpireTime();
    }

    private boolean accessTokenIsNotValid() {
        return this.authenticationContext == null || System.currentTimeMillis() > this.authenticationContext.calculateAccessTokenExpireTime();
    }
}

