/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.commandline;

import com.smartling.api.sdk.FileApiClientAdapterImpl;
import com.smartling.api.sdk.dto.ApiResponse;
import com.smartling.api.sdk.dto.file.UploadFileData;
import com.smartling.api.sdk.exceptions.ApiException;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.commandline.UploadFileParams;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import java.io.File;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadFile {
    private static final Log logger = LogFactory.getLog((String)"com.smartling.api.sdk.file.commandline.UploadFile");
    private static final String RESULT = "Result for %s: %s";

    public static void main(String[] args) throws ApiException {
        UploadFile.upload(args);
    }

    protected static ApiResponse<UploadFileData> upload(String[] args) throws ApiException {
        UploadFileParams uploadParams = UploadFile.getParameters(args);
        File file = new File(uploadParams.getPathToFile());
        FileApiClientAdapterImpl smartlingFAPI = new FileApiClientAdapterImpl(uploadParams.isProductionMode(), uploadParams.getApiKey(), uploadParams.getProjectId());
        FileUploadParameterBuilder fileUploadParameterBuilder = new FileUploadParameterBuilder();
        fileUploadParameterBuilder.fileType(FileType.lookup(uploadParams.getFileType())).fileUri(file.getName()).approveContent(uploadParams.getApproveContent()).callbackUrl(uploadParams.getCallbackUrl());
        ApiResponse<UploadFileData> uploadResponse = smartlingFAPI.uploadFile(file, "UTF-8", fileUploadParameterBuilder);
        logger.info((Object)String.format(RESULT, file.getName(), uploadResponse));
        return uploadResponse;
    }

    private static UploadFileParams getParameters(String[] args) {
        Validate.isTrue((args.length >= 6 ? 1 : 0) != 0, (String)"Invalid number of arguments", (Object[])new Object[0]);
        UploadFileParams uploadParams = new UploadFileParams();
        uploadParams.setProductionMode(Boolean.valueOf(args[0]));
        uploadParams.setApiKey(args[1]);
        uploadParams.setProjectId(args[2]);
        uploadParams.setPathToFile(args[3]);
        uploadParams.setFileType(args[4]);
        uploadParams.setApproveContent(null == args[5] ? null : Boolean.valueOf(args[5]));
        if (args.length == 7) {
            uploadParams.setCallbackUrl(args[6]);
        }
        return uploadParams;
    }
}

