/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file;

import com.google.common.base.CaseFormat;

public enum FileType {
    JAVA_PROPERTIES("text/plain", true),
    IOS("text/plain", true),
    ANDROID("application/xml", true),
    GETTEXT("text/plain", true),
    XLIFF("application/xml", true),
    YAML("text/plain", true),
    JSON("application/json", true),
    XML("application/xml", true),
    HTML("text/html", true),
    FREEMARKER("application/octet-stream", false),
    DOCX("application/octet-stream", false),
    DOC("application/octet-stream", false),
    PPTX("application/octet-stream", false),
    XLSX("application/octet-stream", false),
    XLS("application/octet-stream", false),
    IDML("application/octet-stream", false),
    RESX("application/xml", true),
    QT("application/xml", true),
    CSV("text/csv", true),
    PLAIN_TEXT("text/plain", true),
    PPT("application/octet-stream", false),
    PRES("text/plain", true),
    STRINGSDICT("application/xml", true);

    private final String identifier = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    private final String mimeType;
    private final boolean isTextFormat;

    private FileType(String mimeType, boolean isTextFormat) {
        this.mimeType = mimeType;
        this.isTextFormat = isTextFormat;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isTextFormat() {
        return this.isTextFormat;
    }

    public static FileType lookup(String fileTypeString) {
        for (FileType fileType : FileType.values()) {
            if (!fileType.identifier.equalsIgnoreCase(fileTypeString)) continue;
            return fileType;
        }
        return null;
    }
}

