/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.file.FileApiClientAdapter;
import com.smartling.api.sdk.file.FileApiException;
import com.smartling.api.sdk.file.FileListSearchParams;
import com.smartling.api.sdk.file.ProxyConfiguration;
import com.smartling.api.sdk.file.RetrievalType;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import com.smartling.api.sdk.file.parameters.GetFileParameterBuilder;
import com.smartling.api.sdk.file.response.ApiResponse;
import com.smartling.api.sdk.file.response.ApiResponseWrapper;
import com.smartling.api.sdk.file.response.Data;
import com.smartling.api.sdk.file.response.EmptyResponse;
import com.smartling.api.sdk.file.response.FileLastModified;
import com.smartling.api.sdk.file.response.FileList;
import com.smartling.api.sdk.file.response.FileStatus;
import com.smartling.api.sdk.file.response.StringResponse;
import com.smartling.api.sdk.file.response.UploadData;
import com.smartling.api.sdk.file.util.DateFormatter;
import com.smartling.api.sdk.file.util.DateTypeAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileApiClientAdapterImpl
implements FileApiClientAdapter {
    private static final Log logger = LogFactory.getLog(FileApiClientAdapterImpl.class);
    private static final String API_KEY_MASK = "%s-XXXXXXXXXXXX";
    private static final String RESPONSE_MESSAGES = "Messages: %s";
    private static final String SUCCESS_CODE = "SUCCESS";
    private static final String GENERAL_ERROR_CODE = "GENERAL_ERROR";
    private static final String MIME_TYPE = "text/plain";
    private static final String SMARTLING_API_URL = "https://api.smartling.com/v1";
    private static final String SMARTLING_SANDBOX_API_URL = "https://sandbox-api.smartling.com/v1";
    private static final String UTF_16 = "UTF-16";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_HTTP = "http";
    private static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
    private static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
    private static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
    private static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";
    private static final String UPLOAD_FILE_API_URL = "%s/file/upload?";
    private static final String GET_FILE_API_URL = "%s/file/get?";
    private static final String GET_FILE_LIST_API_URL = "%s/file/list?";
    private static final String GET_FILE_STATUS_API_URL = "%s/file/status?";
    private static final String GET_FILE_LAST_MODIFIED = "%s/file/last_modified?";
    private static final String RENAME_FILE_URL = "%s/file/rename?";
    private static final String DELETE_FILE_URL = "%s/file/delete?";
    private String baseApiUrl;
    private String apiKey;
    private String projectId;
    private ProxyConfiguration proxyConfiguration;

    public FileApiClientAdapterImpl(String apiKey, String projectId) {
        this(SMARTLING_API_URL, apiKey, projectId);
    }

    public FileApiClientAdapterImpl(String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        this(SMARTLING_API_URL, apiKey, projectId, proxyConfiguration);
    }

    public FileApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId) {
        this(productionMode ? SMARTLING_API_URL : SMARTLING_SANDBOX_API_URL, apiKey, projectId);
    }

    public FileApiClientAdapterImpl(boolean productionMode, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        this(productionMode ? SMARTLING_API_URL : SMARTLING_SANDBOX_API_URL, apiKey, projectId, proxyConfiguration);
    }

    public FileApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId) {
        this(baseApiUrl, apiKey, projectId, null);
    }

    public FileApiClientAdapterImpl(String baseApiUrl, String apiKey, String projectId, ProxyConfiguration proxyConfiguration) {
        Assert.notNull((Object)baseApiUrl, (String)"Api url is required");
        Assert.notNull((Object)apiKey, (String)"apiKey is required");
        Assert.notNull((Object)projectId, (String)"projectId is required");
        this.baseApiUrl = baseApiUrl;
        this.apiKey = apiKey;
        this.projectId = projectId;
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    public StringResponse getFile(String fileUri, String locale, RetrievalType retrievalType) throws FileApiException {
        GetFileParameterBuilder getFileParameterBuilder = new GetFileParameterBuilder().fileUri(fileUri).locale(locale).retrievalType(retrievalType);
        return this.getFile(getFileParameterBuilder);
    }

    @Override
    public StringResponse getFile(GetFileParameterBuilder getFileParameterBuilder) throws FileApiException {
        logger.debug((Object)String.format("Get file: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", getFileParameterBuilder.getFileUri(), this.projectId, this.maskApiKey(this.apiKey), getFileParameterBuilder.getLocale()));
        List<NameValuePair> paramsList = getFileParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_API_URL, params));
        try {
            StringResponse stringResponse = this.executeHttpCall((HttpRequestBase)getRequest);
            logger.debug((Object)String.format("Get file: %s", SUCCESS_CODE));
            return stringResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Get file: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<FileList> getFilesList(FileListSearchParams fileListSearchParams) throws FileApiException {
        logger.debug((Object)String.format("Get files list: fileUriMask = %s, projectId = %s, apiKey = %s, locale = %s", fileListSearchParams.getUriMask(), this.projectId, this.maskApiKey(this.apiKey), fileListSearchParams.getLocale()));
        String params = this.buildFileListParams(fileListSearchParams);
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_LIST_API_URL, params));
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)getRequest);
            ApiResponse<FileList> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<FileList>>(){});
            logger.debug((Object)String.format("Get files list: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Get files list: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<FileStatus> getFileStatus(String fileUri, String locale) throws FileApiException {
        logger.debug((Object)String.format("Get file satatus: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey), locale));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("locale", locale)});
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_STATUS_API_URL, params));
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)getRequest);
            ApiResponse<FileStatus> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<FileStatus>>(){});
            logger.debug((Object)String.format("Get file status: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Get file status: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<UploadData> uploadFile(File fileToUpload, String fileEncoding, FileUploadParameterBuilder fileUploadParameterBuilder) throws FileApiException {
        logger.debug((Object)String.format("Upload file: fileUri = %s, projectId = %s, apiKey = %s, localesToApprove = %s", fileUploadParameterBuilder.getFileUri(), this.projectId, this.maskApiKey(this.apiKey), StringUtils.join(fileUploadParameterBuilder.getLocalesToApprove(), (String)", ")));
        List<NameValuePair> paramsList = fileUploadParameterBuilder.getNameValueList();
        String params = this.buildParamsQuery(paramsList.toArray(new NameValuePair[paramsList.size()]));
        HttpPost httpPostFile = this.createFileUploadHttpPostRequest(params, fileToUpload, fileEncoding);
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)httpPostFile);
            ApiResponse<UploadData> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<UploadData>>(){});
            logger.debug((Object)String.format("Upload file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Upload file: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<EmptyResponse> deleteFile(String fileUri) throws FileApiException {
        logger.debug((Object)String.format("Delete file: fileUri = %s, projectId = %s, apiKey = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey)));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri)});
        HttpDelete httpDeleteFileRequest = new HttpDelete(this.buildUrl(DELETE_FILE_URL, params));
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)httpDeleteFileRequest);
            ApiResponse<EmptyResponse> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<EmptyResponse>>(){});
            logger.debug((Object)String.format("Delete file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Delete file: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<EmptyResponse> renameFile(String fileUri, String newFileUri) throws FileApiException {
        logger.debug((Object)String.format("Rename file: fileUri = %s, projectId = %s, apiKey = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey)));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("newFileUri", newFileUri)});
        HttpPost httpPostRequest = new HttpPost(this.buildUrl(RENAME_FILE_URL, params));
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)httpPostRequest);
            ApiResponse<EmptyResponse> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<EmptyResponse>>(){});
            logger.debug((Object)String.format("Rename file: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Rename file: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    @Override
    public ApiResponse<FileLastModified> getLastModified(String fileUri, Date lastModifiedAfter, String locale) throws FileApiException {
        logger.debug((Object)String.format("Get last modified: fileUri = %s, projectId = %s, apiKey = %s, locale = %s", fileUri, this.projectId, this.maskApiKey(this.apiKey), locale));
        String params = this.buildParamsQuery(new NameValuePair[]{new BasicNameValuePair("fileUri", fileUri), new BasicNameValuePair("lastModifiedAfter", DateFormatter.format(lastModifiedAfter)), new BasicNameValuePair("locale", locale)});
        HttpGet getRequest = new HttpGet(this.buildUrl(GET_FILE_LAST_MODIFIED, params));
        try {
            StringResponse response = this.executeHttpCall((HttpRequestBase)getRequest);
            ApiResponse<FileLastModified> apiResponse = this.getApiResponse(response.getContents(), new TypeToken<ApiResponseWrapper<FileLastModified>>(){});
            logger.debug((Object)String.format("Get last modified: %s. %s", apiResponse.getCode(), this.getApiResponseMessages(apiResponse)));
            return apiResponse;
        }
        catch (FileApiException fapiException) {
            logger.error((Object)String.format("Get last modified: %s.", GENERAL_ERROR_CODE), (Throwable)fapiException);
            throw fapiException;
        }
    }

    private HttpPost createFileUploadHttpPostRequest(String apiParameters, File fileToUpload, String fileEncoding) {
        MultipartEntity mpEntity = new MultipartEntity();
        FileBody cbFile = new FileBody(fileToUpload, MIME_TYPE, fileEncoding);
        mpEntity.addPart("file", (ContentBody)cbFile);
        HttpPost httpPost = new HttpPost(String.format(UPLOAD_FILE_API_URL, this.baseApiUrl) + apiParameters);
        httpPost.setEntity((HttpEntity)mpEntity);
        return httpPost;
    }

    private String buildUrl(String apiServerUrl, String apiParameters) {
        StringBuilder urlWithParameters = new StringBuilder(String.format(apiServerUrl, this.baseApiUrl));
        urlWithParameters.append(apiParameters);
        return urlWithParameters.toString();
    }

    private StringResponse executeHttpCall(HttpRequestBase httpRequest) throws FileApiException {
        DefaultHttpClient httpClient = null;
        try {
            httpClient = new DefaultHttpClient();
            this.setupProxy((HttpClient)httpClient);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            if (response.getStatusLine().getStatusCode() == 200) {
                StringResponse stringResponse = this.inputStreamToString(response.getEntity().getContent(), null);
                return stringResponse;
            }
            try {
                throw new FileApiException(this.inputStreamToString(response.getEntity().getContent(), null).getContents());
            }
            catch (IOException e) {
                throw new FileApiException(e);
            }
        }
        finally {
            if (null != httpClient) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    private void setupProxy(HttpClient httpClient) {
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUsername = null;
        String proxyPassword = null;
        if (this.proxyConfiguration != null) {
            proxyHost = this.proxyConfiguration.getHost();
            proxyPort = this.proxyConfiguration.getPort();
            proxyUsername = this.proxyConfiguration.getUsername();
            proxyPassword = this.proxyConfiguration.getPassword();
        } else {
            String protocol = null;
            if (StringUtils.isNotBlank((String)System.getProperty("https.proxyHost")) && StringUtils.isNotBlank((String)System.getProperty("https.proxyPort"))) {
                protocol = SCHEME_HTTPS;
            } else if (StringUtils.isNotBlank((String)System.getProperty("http.proxyHost")) && StringUtils.isNotBlank((String)System.getProperty("http.proxyPort"))) {
                protocol = SCHEME_HTTP;
            }
            if (protocol != null) {
                proxyHost = System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST);
                proxyPort = Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT));
                proxyUsername = System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME);
                proxyPassword = System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD);
            }
        }
        if (proxyHost != null && proxyPort != null) {
            if (StringUtils.isNotBlank((String)proxyUsername) && StringUtils.isNotBlank((String)proxyPassword) && httpClient instanceof DefaultHttpClient) {
                ((DefaultHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    private StringResponse inputStreamToString(InputStream inputStream, String encoding) throws FileApiException {
        StringWriter writer = new StringWriter();
        try {
            String responseEncoding = null == encoding || !encoding.toUpperCase().contains(UTF_16) ? DEFAULT_ENCODING : UTF_16;
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)responseEncoding);
            return new StringResponse(writer.toString(), responseEncoding);
        }
        catch (IOException e) {
            throw new FileApiException(e);
        }
    }

    private String buildFileListParams(FileListSearchParams fileListSearchParams) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("locale", fileListSearchParams.getLocale()));
        nameValuePairs.add(new BasicNameValuePair("uriMask", fileListSearchParams.getUriMask()));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedAfter", DateFormatter.format(fileListSearchParams.getLastUploadedAfter())));
        nameValuePairs.add(new BasicNameValuePair("lastUploadedBefore", DateFormatter.format(fileListSearchParams.getLastUploadedBefore())));
        nameValuePairs.add(new BasicNameValuePair("offset", null == fileListSearchParams.getOffset() ? null : String.valueOf(fileListSearchParams.getOffset())));
        nameValuePairs.add(new BasicNameValuePair("limit", null == fileListSearchParams.getLimit() ? null : String.valueOf(fileListSearchParams.getLimit())));
        nameValuePairs.addAll(this.getNameValuePairs("fileTypes", fileListSearchParams.getFileTypes()));
        nameValuePairs.addAll(this.getNameValuePairs("conditions", fileListSearchParams.getConditions()));
        nameValuePairs.addAll(this.getNameValuePairs("orderBy", fileListSearchParams.getOrderBy()));
        return this.buildParamsQuery(nameValuePairs.toArray(new NameValuePair[nameValuePairs.size()]));
    }

    private List<BasicNameValuePair> getNameValuePairs(String name, List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String value : values) {
            nameValuePairs.add(new BasicNameValuePair(name, value));
        }
        return nameValuePairs;
    }

    private <T extends Data> ApiResponse<T> getApiResponse(String response, TypeToken<ApiResponseWrapper<T>> responseType) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        Gson gson = builder.create();
        ApiResponseWrapper responseWrapper = (ApiResponseWrapper)gson.fromJson(response, responseType.getType());
        return responseWrapper.getResponse();
    }

    private String buildParamsQuery(NameValuePair ... nameValuePairs) {
        List<NameValuePair> qparams = this.getRequiredParams();
        for (NameValuePair nameValuePair : nameValuePairs) {
            if (nameValuePair.getValue() == null) continue;
            qparams.add(nameValuePair);
        }
        return URLEncodedUtils.format(qparams, (String)DEFAULT_ENCODING);
    }

    private List<NameValuePair> getRequiredParams() {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("apiKey", this.apiKey));
        qparams.add((NameValuePair)new BasicNameValuePair("projectId", this.projectId));
        return qparams;
    }

    private String maskApiKey(String apiKey) {
        return apiKey.contains("-") ? String.format(API_KEY_MASK, apiKey.substring(0, apiKey.lastIndexOf("-"))) : apiKey;
    }

    private String getApiResponseMessages(ApiResponse apiResponse) {
        String responseMessages = "";
        if (!SUCCESS_CODE.equals(apiResponse.getCode())) {
            responseMessages = String.format(RESPONSE_MESSAGES, StringUtils.join(apiResponse.getMessages(), (String)", "));
        }
        return responseMessages;
    }
}

